/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing.renderer;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.netbeans.lib.profiler.ui.swing.renderer.BarRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.MultiRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.NumberPercentRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

public class HideableBarRenderer
extends MultiRenderer {
    private static final int BAR_MARGIN = 20;
    private static final int MIN_BAR_WIDTH = 20;
    private static final int MAX_BAR_WIDTH = 100;
    private static final int OPT_BAR_WIDTH = 50;
    private int maxRendererWidth;
    private final BarRenderer barRenderer;
    private final ProfilerRenderer mainRenderer;
    private final NumberPercentRenderer numberPercentRenderer;
    private final ProfilerRenderer[] valueRenderers;

    public HideableBarRenderer(ProfilerRenderer renderer) {
        this(renderer, renderer.getComponent().getPreferredSize().width);
    }

    public HideableBarRenderer(ProfilerRenderer renderer, int maxWidth) {
        this.maxRendererWidth = maxWidth;
        this.barRenderer = new BarRenderer();
        this.mainRenderer = renderer;
        this.numberPercentRenderer = renderer instanceof NumberPercentRenderer ? (NumberPercentRenderer)renderer : null;
        this.valueRenderers = new ProfilerRenderer[]{this.barRenderer, this.mainRenderer};
        this.setOpaque(true);
        this.setHorizontalAlignment(11);
    }

    public void setMaxValue(long maxValue) {
        int oldDigits = Long.toString(this.barRenderer.getMaxValue()).length();
        int newDigits = Long.toString(maxValue).length();
        this.barRenderer.setMaxValue(maxValue);
        if (this.numberPercentRenderer != null) {
            this.numberPercentRenderer.setMaxValue(maxValue);
        }
        if (oldDigits < newDigits) {
            this.mainRenderer.setValue((long)Math.pow(10.0, newDigits) - 1L, -1);
            int mainWidth = this.mainRenderer.getComponent().getPreferredSize().width;
            this.maxRendererWidth = Math.max(this.maxRendererWidth, mainWidth);
        }
    }

    @Override
    public void setValue(Object value, int row) {
        this.barRenderer.setValue(value, row);
        this.mainRenderer.setValue(value, row);
    }

    @Override
    protected ProfilerRenderer[] valueRenderers() {
        return this.valueRenderers;
    }

    @Override
    protected int renderersGap() {
        return 20;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.mainRenderer.getComponent().getPreferredSize();
    }

    public int getOptimalWidth() {
        return this.maxRendererWidth + this.renderersGap() + 50;
    }

    public int getMaxNoBarWidth() {
        return this.maxRendererWidth + this.renderersGap() + 20 - 1;
    }

    public int getNoBarWidth() {
        return this.maxRendererWidth;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(this.location.x, this.location.y, this.size.width, this.size.height);
        JComponent component = this.mainRenderer.getComponent();
        int componentWidth = component.getPreferredSize().width;
        int componentX = this.size.width - componentWidth;
        this.mainRenderer.move(this.location.x + componentX, this.location.y);
        component.setSize(componentWidth, this.size.height);
        component.paint(g);
        int freeWidth = this.size.width - this.maxRendererWidth - this.renderersGap();
        if (freeWidth >= 20) {
            this.barRenderer.setSize(Math.min(freeWidth, 100), this.size.height);
            this.barRenderer.move(this.location.x, this.location.y);
            this.barRenderer.paint(g);
        }
    }

    @Override
    public String toString() {
        return this.mainRenderer.toString();
    }
}

