/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.api;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptionListener;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;
import org.netbeans.modules.cnd.repository.api.RepositoryListener;
import org.netbeans.modules.cnd.repository.api.RepositoryListenersManager;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.impl.ShuttedDownRepositoryImpl;
import org.netbeans.modules.cnd.repository.impl.UninitializedRepositoryImpl;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;
import org.netbeans.modules.cnd.repository.impl.spi.RepositoryImplementation;
import org.netbeans.modules.cnd.repository.impl.spi.RepositoryImplementationFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.openide.util.Lookup;

public final class Repository {
    private static final AtomicReference<RepositoryImplementation> implRef = new AtomicReference<UninitializedRepositoryImpl>(new UninitializedRepositoryImpl("Not initialized repository"));
    private static final Object lock = new Object();
    private static int persistMechanismVersion = -1;

    public static Persistent get(Key key) {
        return implRef.get().get(key);
    }

    public static void put(Key key, Persistent obj) {
        implRef.get().put(key, obj);
    }

    public static void remove(Key key) {
        implRef.get().remove(key);
    }

    public static void hang(Key key, Persistent obj) {
        implRef.get().hang(key, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(int persistMechanismVersion) {
        if (persistMechanismVersion < 0) {
            throw new IllegalArgumentException();
        }
        Object object = lock;
        synchronized (object) {
            if (Repository.persistMechanismVersion == persistMechanismVersion) {
                return;
            }
            if (Repository.persistMechanismVersion != -1) {
                throw new IllegalStateException("Repository persistMechanismVersion is already set to " + Repository.persistMechanismVersion);
            }
            RepositoryImplementationFactory factory = (RepositoryImplementationFactory)Lookup.getDefault().lookup(RepositoryImplementationFactory.class);
            implRef.set(factory.createRepository(persistMechanismVersion));
            Repository.persistMechanismVersion = persistMechanismVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        Object object = lock;
        synchronized (object) {
            if (persistMechanismVersion == -1) {
                return;
            }
            try {
                RepositoryImplementation impl = implRef.get();
                impl.shutdown();
            }
            finally {
                persistMechanismVersion = -1;
                implRef.set(new ShuttedDownRepositoryImpl("Shutted down repository"));
            }
        }
    }

    public static void openUnit(int unitId) {
        implRef.get().openUnit(unitId);
        RepositoryListenersManager.getInstance().fireUnitOpenedEvent(unitId);
    }

    public static void closeUnit(int unitId, boolean cleanRepository, Set<Integer> requiredUnits) {
        implRef.get().closeUnit(unitId, cleanRepository, requiredUnits);
        RepositoryListenersManager.getInstance().fireUnitClosedEvent(unitId);
    }

    public static void removeUnit(int unitId) {
        implRef.get().removeUnit(unitId);
    }

    public static int getFileIdByName(int unitId, CharSequence fileName) {
        return implRef.get().getFileIdByName(unitId, fileName);
    }

    public static CharSequence getFileNameById(int unitId, int fileId) {
        return implRef.get().getFileNameById(unitId, fileId);
    }

    public static CharSequence getFileNameByIdSafe(int unitId, int fileId) {
        return implRef.get().getFileNameByIdSafe(unitId, fileId);
    }

    public static CharSequence getUnitName(int unitId) {
        return implRef.get().getUnitName(unitId);
    }

    public static int getUnitIdForStorage(UnitDescriptor unitDescriptor, int storageID) {
        return implRef.get().getUnitID(unitDescriptor, storageID);
    }

    public static int getUnitId(UnitDescriptor unitDescriptor) {
        return implRef.get().getUnitID(unitDescriptor);
    }

    public static void registerRepositoryListener(RepositoryListener listener) {
        RepositoryListenersManager.getInstance().registerListener(listener);
    }

    public static void unregisterRepositoryListener(RepositoryListener listener) {
        RepositoryListenersManager.getInstance().unregisterListener(listener);
    }

    public static void addRepositoryExceptionListener(RepositoryExceptionListener listener) {
        RepositoryExceptions.addRepositoryExceptionListener(listener);
    }

    public static void removeRepositoryExceptionListener(RepositoryExceptionListener listener) {
        RepositoryExceptions.removeRepositoryExceptionListener(listener);
    }

    public static LayeringSupport getLayeringSupport(int sourceUnitId) {
        return implRef.get().getLayeringSupport(sourceUnitId);
    }
}

