/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.Util;
import java.io.ByteArrayOutputStream;

public class AttributeInfo {
    short nameIndex;
    int length;
    byte[] value;

    public void setNameIndex(short s) {
        this.nameIndex = s;
    }

    public void setValue(int n, byte[] byArray) {
        this.length = n;
        this.value = new byte[this.length];
        System.arraycopy(byArray, 0, this.value, 0, this.length);
    }

    public boolean equals(Object object) {
        if (!(object instanceof AttributeInfo)) {
            return false;
        }
        AttributeInfo attributeInfo = (AttributeInfo)object;
        if (this.length != attributeInfo.length) {
            return false;
        }
        return Util.compareByteArrays(this.value, attributeInfo.value);
    }

    void write(ByteArrayOutputStream byteArrayOutputStream) {
        byte[] byArray = Util.getShortBytes(this.nameIndex);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byte[] byArray2 = Util.getIntBytes(this.length);
        byteArrayOutputStream.write(byArray2, 0, 4);
        byteArrayOutputStream.write(this.value, 0, this.length);
    }

    public void print(String string) {
        byte[] byArray = Util.getShortBytes(this.nameIndex);
        Util.printArray(string + "\tAttribute name index: ", byArray, byArray.length);
        byte[] byArray2 = Util.getIntBytes(this.length);
        Util.printArray(string + "\tAttribute Length (" + this.length + "): ", byArray2, 4);
        Util.printArray(string + "\tAttribute Info bytes: ", this.value, this.length);
    }
}

