/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.util.StringUtils;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.JavaCardXML;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.ModuleJCRD;
import com.sun.javacard.validator.PackageItem;
import com.sun.javacard.validator.ValidValues;
import com.sun.javacard.validator.XMLNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class WebXML
extends PackageItem {
    public static final String XSD_NAME = "jcweb-app_3_0.xsd";
    private String version;
    private File file;
    private XMLNode xmlNode;
    private Vector<String> servletClasses = new Vector();
    private Vector<String> listenerClasses = new Vector();
    private Vector<String> filterClasses = new Vector();
    private Vector<String> securityRoles = new Vector();

    public WebXML(File file) {
        this.file = file;
    }

    @Override
    public String getItemDisplayName() {
        String string = "";
        if (this.getParent() != null) {
            string = this.getParent().getItemDisplayName() + "/";
        }
        string = string + "web.xml";
        return string;
    }

    public void saveCanonicalizedTo(File file) throws Exception {
        if (!this.isOk()) {
            return;
        }
        String string = this.xmlNode.toString();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(string.getBytes());
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void initialize() {
        ArrayList<XMLNode> arrayList;
        ArrayList<XMLNode> arrayList2;
        Object object;
        ArrayList<XMLNode> arrayList3;
        this.xmlNode = null;
        try {
            this.xmlNode = new XMLNode(this, this.file, XSD_NAME, "http://java.sun.com/xml/ns/j2ee");
        }
        catch (Exception exception) {
            this.addError(ErrorKey.XMLParsingError, this.file.getName(), exception.getMessage());
            return;
        }
        this.version = this.xmlNode.getAttribute("version");
        if (!"2.4".equals(this.version)) {
            this.addError(ErrorKey.InvalidVersion, this.version);
        }
        if ((arrayList3 = this.xmlNode.getChildNodes("servlet")) != null) {
            object = arrayList3.iterator();
            while (object.hasNext()) {
                arrayList2 = (XMLNode)object.next();
                this.gatherServletClasses((XMLNode)((Object)arrayList2));
            }
        }
        if ((object = this.xmlNode.getChildNodes("listener")) != null) {
            arrayList2 = ((ArrayList)object).iterator();
            while (arrayList2.hasNext()) {
                arrayList = (XMLNode)arrayList2.next();
                this.gatherListenerClasses((XMLNode)((Object)arrayList));
            }
        }
        if ((arrayList2 = this.xmlNode.getChildNodes("filter")) != null) {
            arrayList = arrayList2.iterator();
            while (arrayList.hasNext()) {
                XMLNode xMLNode = (XMLNode)arrayList.next();
                this.gatherFilterClasses(xMLNode);
            }
        }
        if ((arrayList = this.xmlNode.getChildNodes("security-role")) != null) {
            for (XMLNode xMLNode : arrayList) {
                this.gatherSecurityRoles(xMLNode);
            }
        }
    }

    private void gatherServletClasses(XMLNode xMLNode) {
        ArrayList<XMLNode> arrayList = xMLNode.getChildNodes("servlet-class");
        for (XMLNode xMLNode2 : arrayList) {
            this.servletClasses.addElement(xMLNode2.getTextValue());
        }
    }

    private void gatherListenerClasses(XMLNode xMLNode) {
        ArrayList<XMLNode> arrayList = xMLNode.getChildNodes("listener-class");
        for (XMLNode xMLNode2 : arrayList) {
            this.listenerClasses.addElement(xMLNode2.getTextValue());
        }
    }

    private void gatherFilterClasses(XMLNode xMLNode) {
        ArrayList<XMLNode> arrayList = xMLNode.getChildNodes("filter-class");
        for (XMLNode xMLNode2 : arrayList) {
            this.filterClasses.addElement(xMLNode2.getTextValue());
        }
    }

    void gatherSecurityRoles(XMLNode xMLNode) {
        ArrayList<XMLNode> arrayList = xMLNode.getChildNodes("role-name");
        for (XMLNode xMLNode2 : arrayList) {
            String string = xMLNode2.getTextValue();
            if (!ValidValues.isValidNNMToken(string)) {
                this.addError(ErrorKey.RoleNameNotNMTOKEN, string);
            }
            this.securityRoles.addElement(string);
        }
    }

    @Override
    public void processInternal() {
        Module module = (Module)this.getParent();
        for (String string : this.servletClasses) {
            if (!StringUtils.isValidClassName(string)) {
                this.addError(ErrorKey.IllegalClassName, string, "servlet-class");
                continue;
            }
            if (!module.hasClass(string)) {
                this.addWarning(ErrorKey.DeclaredClassDoesNotExists, string, "servlet-class");
            }
            if (module.isConcreteClass(string)) continue;
            this.addWarning(ErrorKey.ServletClassNotConcrete, string);
        }
        for (String string : this.listenerClasses) {
            if (!StringUtils.isValidClassName(string)) {
                this.addError(ErrorKey.IllegalClassName, string, "listener-class");
                continue;
            }
            if (!module.hasClass(string)) {
                this.addWarning(ErrorKey.DeclaredClassDoesNotExists, string, "listener-class");
            }
            if (module.isConcreteClass(string)) continue;
            this.addWarning(ErrorKey.ListenerClassNotConcrete, string);
        }
        for (String string : this.filterClasses) {
            if (!StringUtils.isValidClassName(string)) {
                this.addError(ErrorKey.IllegalClassName, string, "filter-class");
                continue;
            }
            if (!module.hasClass(string)) {
                this.addWarning(ErrorKey.DeclaredClassDoesNotExists, string, "filter-class");
            }
            if (module.isConcreteClass(string)) continue;
            this.addWarning(ErrorKey.FilterClassNotConcrete, string);
        }
        this.verifySecurityRoles();
        this.verifySecurityConstraint();
        this.verifyLoginConfig();
    }

    void verifySecurityRoles() {
        Module module = (Module)this.getParent();
        ModuleJCRD moduleJCRD = module.getJCRD();
        Vector<String> vector = moduleJCRD.getUserRoleList();
        Vector<String> vector2 = moduleJCRD.getOncardClientRoleList();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        JavaCardXML javaCardXML = module.getJavaCardXML();
        if (javaCardXML != null) {
            for (String string : javaCardXML.getOncardClientRoles()) {
                vector3.addElement(string);
            }
            for (String string : javaCardXML.getUserRoles()) {
                vector4.addElement(string);
            }
        }
        for (String string : this.securityRoles) {
            if (vector.contains(string)) continue;
            this.addError(ErrorKey.MissingSecurityRoleInJCRD, string);
        }
        for (String string : vector) {
            if (vector4.contains(string) || this.securityRoles.contains(string)) continue;
            this.addError(ErrorKey.MissingUserRoleInJCADOrWebXml, string);
        }
        for (String string : vector2) {
            if (vector3.contains(string)) continue;
            this.addError(ErrorKey.MissingOnCardClientRoleInJCAD, string);
        }
    }

    void verifySecurityConstraint() {
        ArrayList<XMLNode> arrayList = this.xmlNode.getChildNodes("security-constraint");
        for (XMLNode xMLNode : arrayList) {
            ArrayList<XMLNode> arrayList2 = xMLNode.getChildNodes("auth-constraint");
            for (XMLNode xMLNode2 : arrayList2) {
                ArrayList<XMLNode> arrayList3 = xMLNode2.getChildNodes("role-name");
                for (XMLNode xMLNode3 : arrayList3) {
                    String string = xMLNode3.getTextValue();
                    if (string == null) {
                        this.addError(ErrorKey.InvalidAuthConstraintMissingRoleName, new Object[0]);
                        continue;
                    }
                    if (string.equals("*") || this.securityRoles.contains(string)) continue;
                    this.addError(ErrorKey.InvalidAuthConstraintInvalidRoleName, string);
                }
            }
        }
    }

    void verifyLoginConfig() {
        Module module = (Module)this.getParent();
        ModuleJCRD moduleJCRD = module.getJCRD();
        Hashtable<String, Vector<String>> hashtable = moduleJCRD.getUserRoleAuthURIMappings();
        ArrayList<XMLNode> arrayList = this.xmlNode.getChildNodes("login-config");
        for (XMLNode xMLNode : arrayList) {
            ArrayList<XMLNode> arrayList2 = xMLNode.getChildNodes("auth-method");
            for (XMLNode xMLNode2 : arrayList2) {
                String string = xMLNode2.getTextValue();
                if (ValidValues.isValidAuthMethod(string)) continue;
                this.addError(ErrorKey.InvalidAuthenticationMethod, string);
            }
        }
    }
}

