/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.toolchain.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ui.LocalToolsPanelModel;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsPanelModel;
import org.netbeans.modules.cnd.toolchain.ui.options.DownloadUtils;
import org.netbeans.modules.cnd.toolchain.ui.options.ToolsPanel;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class BuildToolsAction
extends CallableSystemAction
implements PropertyChangeListener {
    private String title;
    private String name = NbBundle.getMessage(BuildToolsAction.class, (String)"LBL_BuildToolsName");
    private JButton jOK = null;
    private ToolsPanel tp;

    public BuildToolsAction() {
        this.title = NbBundle.getMessage(BuildToolsAction.class, (String)"LBL_BuildToolsTitle");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void performAction() {
        this.initBuildTools(new LocalToolsPanelModel(), new ArrayList<String>(), null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().equals("valid") && ev.getSource() instanceof ToolsPanel) {
            this.jOK.setEnabled((Boolean)ev.getNewValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initBuildTools(ToolsPanelModel model, ArrayList<String> errs, CompilerSet cs) {
        if (this.downloadIfNeed(model, cs)) {
            return true;
        }
        this.tp = new ToolsPanel(model, "ResolveBuildTools");
        this.tp.addPropertyChangeListener(this);
        this.jOK = new JButton(NbBundle.getMessage(BuildToolsAction.class, (String)"BTN_OK"));
        this.tp.setPreferredSize(new Dimension(640, 450));
        this.tp.update(errs);
        DialogDescriptor dd = new DialogDescriptor((Object)this.constructOuterPanel(this.tp), this.getTitle(), true, new Object[]{this.jOK, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, HelpCtx.findHelp((Component)this.tp), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        try {
            dialog.setVisible(true);
        }
        catch (Throwable th) {
            if (!(th.getCause() instanceof InterruptedException)) {
                throw new RuntimeException(th);
            }
            dd.setValue(DialogDescriptor.CLOSED_OPTION);
        }
        finally {
            dialog.dispose();
        }
        if (dd.getValue() == this.jOK) {
            this.tp.applyChanges(true);
            return true;
        }
        return false;
    }

    private boolean downloadIfNeed(ToolsPanelModel model, CompilerSet cs) {
        ExecutionEnvironment env = model.getSelectedDevelopmentHost();
        if (env.isLocal()) {
            if (cs == null) {
                cs = CompilerSetManager.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getDefaultCompilerSet();
            }
            if (cs != null && cs.isUrlPointer()) {
                return DownloadUtils.showDownloadConfirmation(cs);
            }
        }
        return false;
    }

    private JPanel constructOuterPanel(JPanel innerPanel) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(16, 16, 16, 16);
        panel.add((Component)innerPanel, gridBagConstraints);
        return panel;
    }

    public void actionPerformed(ActionEvent ev) {
        this.performAction();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

