/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fileoperations.spi;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public abstract class FilesystemInterceptorProvider {
    private static FilesystemInterceptorProvider defaultProvider;
    private static final FilesystemInterceptorProvider NullProvider;

    protected FilesystemInterceptorProvider() {
    }

    public abstract FilesystemInterceptor getFilesystemInterceptor(FileSystem var1);

    public static FileProxyI toFileProxy(FileObject file, String name, String ext) {
        return new FileObjectFileProxyI(file, name, ext);
    }

    public static FileProxyI toFileProxy(FileObject file) {
        return new FileObjectFileProxyI(file);
    }

    public static FileProxyI toFileProxy(FileSystem fs, String path) {
        return new FileObjectFileProxyI(fs, path);
    }

    public static FilesystemInterceptorProvider getDefault() {
        if (defaultProvider != null) {
            return defaultProvider;
        }
        Collection lookupAll = Lookup.getDefault().lookupAll(FilesystemInterceptorProvider.class);
        if (lookupAll == null || lookupAll.isEmpty()) {
            defaultProvider = NullProvider;
        } else {
            Iterator iterator = lookupAll.iterator();
            if (lookupAll.size() == 1) {
                defaultProvider = (FilesystemInterceptorProvider)iterator.next();
            } else {
                while (iterator.hasNext()) {
                    FilesystemInterceptorProvider next = (FilesystemInterceptorProvider)iterator.next();
                    if (next.getClass().getName().indexOf("Mockup") < 0) continue;
                    defaultProvider = next;
                }
                if (defaultProvider == null) {
                    defaultProvider = (FilesystemInterceptorProvider)lookupAll.iterator().next();
                }
            }
        }
        return defaultProvider;
    }

    static {
        NullProvider = new FilesystemInterceptorProvider(){

            @Override
            public FilesystemInterceptor getFilesystemInterceptor(FileSystem fs) {
                return null;
            }
        };
    }

    private static final class FileObjectFileProxyI
    implements FileProxyI {
        private final FileSystem fs;
        private final String path;

        private FileObjectFileProxyI(FileObject fo) {
            FileSystem aFS = null;
            try {
                aFS = fo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.fs = aFS;
            this.path = fo.getPath();
        }

        private FileObjectFileProxyI(FileSystem fs, String path) {
            this.fs = fs;
            this.path = path;
        }

        private FileObjectFileProxyI(FileObject fo, String name, String ext) {
            FileSystem aFS = null;
            try {
                aFS = fo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.fs = aFS;
            String aPath = fo.getPath();
            aPath = !aPath.endsWith("/") ? aPath + '/' + name : aPath + name;
            if (ext != null && ext.length() > 0) {
                aPath = aPath + '.' + ext;
            }
            this.path = aPath;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public FileSystem getFileSystem() {
            return this.fs;
        }

        public String toString() {
            return this.path;
        }

        public int hashCode() {
            int hash = 5;
            hash = 79 * hash + (this.fs != null ? this.fs.hashCode() : 0);
            hash = 79 * hash + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileObjectFileProxyI other = (FileObjectFileProxyI)obj;
            if (!(this.fs == other.fs || this.fs != null && this.fs.equals(other.fs))) {
                return false;
            }
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }
    }

    public static interface IOHandler {
        public void handle() throws IOException;
    }

    public static interface MiscOperations {
        public void fileLocked(FileProxyI var1) throws IOException;

        public long refreshRecursively(FileProxyI var1, long var2, List<? super FileProxyI> var4);
    }

    public static interface CopyOperations {
        public IOHandler getCopyHandler(FileProxyI var1, FileProxyI var2);

        public void beforeCopy(FileProxyI var1, FileProxyI var2);

        public void copySuccess(FileProxyI var1, FileProxyI var2);
    }

    public static interface MoveOperations {
        public IOHandler getMoveHandler(FileProxyI var1, FileProxyI var2);

        public IOHandler getRenameHandler(FileProxyI var1, String var2);

        public void afterMove(FileProxyI var1, FileProxyI var2);
    }

    public static interface CreateOperations {
        public void beforeCreate(FileProxyI var1, String var2, boolean var3);

        public void createFailure(FileProxyI var1, String var2, boolean var3);

        public void createSuccess(FileProxyI var1);

        public void createdExternally(FileProxyI var1);
    }

    public static interface DeleteOperations {
        public IOHandler getDeleteHandler(FileProxyI var1);

        public void deleteSuccess(FileProxyI var1);

        public void deletedExternally(FileProxyI var1);
    }

    public static interface ChangeOperations {
        public void beforeChange(FileProxyI var1);

        public void fileChanged(FileProxyI var1);
    }

    public static interface QueryOperations {
        public boolean canWriteReadonlyFile(FileProxyI var1);

        public Object getAttribute(FileProxyI var1, String var2);
    }

    public static interface FileProxyI {
        public String getPath();

        public FileSystem getFileSystem();
    }

    public static interface FilesystemInterceptor
    extends QueryOperations,
    ChangeOperations,
    DeleteOperations,
    CreateOperations,
    MoveOperations,
    CopyOperations,
    MiscOperations {
    }
}

