/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.cncppunit.editor.filecreation;

import java.awt.Component;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.cncppunit.editor.filecreation.NewTestCppUnitPanelGUI;
import org.netbeans.modules.cnd.cncppunit.editor.filecreation.TestLibChecker;
import org.netbeans.modules.cnd.editor.filecreation.CndPanel;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.simpleunit.utils.MakefileUtils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class NewTestCppUnitPanel
extends CndPanel {
    private static final String CPPUNIT = "cppunit";
    private String baseTestName = null;
    private RequestProcessor.Task libCheckTask;
    private volatile boolean libCheckResult;

    NewTestCppUnitPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel<WizardDescriptor> bottomPanel, String baseTestName) {
        super(project, folders, bottomPanel);
        this.baseTestName = baseTestName;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new NewTestCppUnitPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.baseTestName);
            this.gui.addChangeListener((ChangeListener)((Object)this));
        }
        return this.gui;
    }

    public void stateChanged(ChangeEvent e) {
        if (e instanceof TestLibChecker.LibCheckerChangeEvent) {
            this.libCheckResult = ((TestLibChecker.LibCheckerChangeEvent)e).getResult();
            this.libCheckTask = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NewTestCppUnitPanel.this.getGui().setControlsEnabled(true);
                }
            });
        }
        super.stateChanged(e);
    }

    public HelpCtx getHelp() {
        return new HelpCtx("CreateCppUnitTestWizardP2");
    }

    public void readSettings(WizardDescriptor settings) {
        super.readSettings(settings);
        this.libCheckResult = false;
        this.getGui().setControlsEnabled(false);
        AbstractCompiler cppCompiler = TestLibChecker.getCppCompiler(this.project);
        this.libCheckTask = cppCompiler != null ? TestLibChecker.asyncCheck(CPPUNIT, cppCompiler, (ChangeListener)((Object)this)) : null;
    }

    protected void doStoreSettings(WizardDescriptor settings) {
        String table = ((CppSettings)CppSettings.findObject(CppSettings.class, (boolean)true)).getReplaceableStringsTable();
        table = table + "\nCLASSNAME=" + this.getGui().getClassName();
        table = table + "\nDEFAULT_HEADER_EXT=" + this.getGui().getHeaderExt();
        ((CppSettings)CppSettings.findObject(CppSettings.class, (boolean)true)).setReplaceableStringsTable(table);
        settings.putProperty("headerFileName", (Object)this.getGui().getHeaderFileName());
        FileObject fo = this.getHeaderFolderFromGUI();
        if (fo != null) {
            settings.putProperty("headerFolder", (Object)DataFolder.findFolder((FileObject)fo));
        }
    }

    private FileObject getHeaderFolderFromGUI() {
        FileObject headerFolder;
        FileObject rootFolder = this.getGui().getTargetGroup().getRootFolder();
        String folderName = this.getGui().getHeaderFolder();
        String newObject = this.getGui().getHeaderName();
        if (newObject.indexOf(47) > 0) {
            String path = newObject.substring(0, newObject.lastIndexOf(47));
            String string = folderName = folderName.isEmpty() ? path : folderName + '/' + path;
        }
        if ((headerFolder = rootFolder.getFileObject(folderName)) == null) {
            try {
                headerFolder = FileUtil.createFolder((FileObject)rootFolder, (String)folderName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return headerFolder;
    }

    NewTestCppUnitPanelGUI getGui() {
        return (NewTestCppUnitPanelGUI)this.gui;
    }

    public boolean isValid() {
        this.setInfoMessage(null);
        this.setErrorMessage(null);
        if (this.libCheckTask != null) {
            this.setInfoMessage(NbBundle.getMessage(NewTestCppUnitPanel.class, (String)"MSG_Checking_Library", (Object)CPPUNIT, (Object)TestLibChecker.getExecutionEnvironment(this.project)));
            return false;
        }
        if (!this.libCheckResult) {
            this.setErrorMessage(NbBundle.getMessage(NewTestCppUnitPanel.class, (String)"MSG_Missing_Library", (Object)CPPUNIT));
        }
        if (!super.isValid()) {
            return false;
        }
        if (!CndLexerUtilities.isCppIdentifier((CharSequence)this.getGui().getClassName())) {
            this.setErrorMessage(NbBundle.getMessage(NewTestCppUnitPanel.class, (String)"MSG_not_valid_classname"));
            return false;
        }
        String errorMessage = NewTestCppUnitPanel.canUseFileName((FileObject)this.getGui().getTargetGroup().getRootFolder(), (String)this.getGui().getTargetFolder(), (String)this.getGui().getSourceFileName(), (boolean)false);
        if (errorMessage == null && (errorMessage = NewTestCppUnitPanel.canUseFileName((FileObject)this.getGui().getTargetGroup().getRootFolder(), (String)this.getGui().getTargetFolder(), (String)this.getGui().getHeaderFileName(), (boolean)false)) == null) {
            errorMessage = NewTestCppUnitPanel.canUseFileName((FileObject)this.getGui().getTargetGroup().getRootFolder(), (String)this.getGui().getTargetFolder(), (String)this.getGui().getRunnerFileName(), (boolean)false);
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        }
        if (MakefileUtils.getMakefile((Project)this.project) == null) {
            this.setInfoMessage(NbBundle.getMessage(NewTestCppUnitPanel.class, (String)"MSG_Missing_Makefile"));
            return false;
        }
        return errorMessage == null;
    }

    public static FileObject getTemplateFileObject(String formType) {
        return FileUtil.getConfigFile((String)("Templates/testFiles/" + formType));
    }

    public static DataObject getTemplateDataObject(String formType) {
        FileObject fileObj = NewTestCppUnitPanel.getTemplateFileObject(formType);
        if (fileObj != null) {
            try {
                return DataObject.find((FileObject)fileObj);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

