/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Bundle;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;

final class Utils {
    Utils() {
    }

    static String getFontName(Instance instance, Heap heap) {
        Instance font2D;
        Instance font2DHandle;
        String name = Utils.getFieldString(instance, "name");
        if (name == null && (font2DHandle = (Instance)instance.getValueOfField("font2DHandle")) != null && (font2D = (Instance)font2DHandle.getValueOfField("font2D")) != null && (name = Utils.getFieldString(instance, "fullName")) == null) {
            name = Utils.getFieldString(instance, "nativeFontName");
        }
        return name;
    }

    static String getFieldString(Instance instance, String field) {
        Object _s = instance.getValueOfField(field);
        if (_s instanceof Instance) {
            Instance s = (Instance)_s;
            int offset = DetailsUtils.getIntFieldValue(s, "offset", 0);
            int count = DetailsUtils.getIntFieldValue(s, "count", -1);
            List<String> ch = DetailsUtils.getPrimitiveArrayFieldValues(s, "value");
            if (ch != null) {
                int valuesCount = count < 0 ? ch.size() - offset : Math.min(count, ch.size() - offset);
                StringBuilder value = new StringBuilder(valuesCount * 2);
                int lastValue = offset + valuesCount - 1;
                for (int i = offset; i <= lastValue; ++i) {
                    value.append(ch.get(i));
                }
                return value.toString();
            }
        }
        return null;
    }

    static abstract class View<T extends InstanceBuilder>
    extends DetailsProvider.View
    implements Scrollable {
        private static final int DASH_SIZE = 20;
        private final int margin;
        private final boolean pattern;
        private final boolean stretch;
        private Component component;
        private JPanel glassPane;

        View(Instance instance, Heap heap) {
            this(10, true, false, instance, heap);
        }

        View(int margin, boolean pattern, boolean stretch, Instance instance, Heap heap) {
            super(instance, heap);
            this.margin = margin;
            this.pattern = pattern;
            this.stretch = stretch;
        }

        protected T getBuilder(Instance instance, Heap heap) {
            return null;
        }

        protected Component getComponent(T builder) {
            return null;
        }

        protected void setupGlassPane(JPanel glassPane) {
        }

        @Override
        protected final void computeView(Instance instance, Heap heap) {
            T builder = this.getBuilder(instance, heap);
            SwingUtilities.invokeLater(new Runnable((InstanceBuilder)builder){
                final /* synthetic */ InstanceBuilder val$builder;
                {
                    this.val$builder = instanceBuilder;
                }

                @Override
                public void run() {
                    View.this.removeAll();
                    View.this.component = this.val$builder == null ? null : View.this.getComponent(this.val$builder);
                    if (View.this.component != null) {
                        View.this.component.setVisible(true);
                        if (View.this.stretch) {
                            View.this.add(View.this.component, "Center");
                        } else {
                            View.this.glassPane = new JPanel(null){

                                @Override
                                public Point getToolTipLocation(MouseEvent event) {
                                    Point p = event.getPoint();
                                    p.translate(15, 15);
                                    return p;
                                }
                            };
                            View.this.glassPane.setOpaque(false);
                            View.this.glassPane.addMouseListener(new MouseAdapter(){});
                            View.this.glassPane.addMouseMotionListener(new MouseMotionAdapter(){});
                            View.this.glassPane.addKeyListener(new KeyAdapter(){});
                            View.this.setupGlassPane(View.this.glassPane);
                            View.this.add(View.this.glassPane);
                            View.this.setLayout(null);
                            View.this.add(View.this.component);
                        }
                        if (View.this.component.getWidth() == 0 || View.this.component.getHeight() == 0) {
                            View.this.component.setSize(View.this.component.getPreferredSize());
                        }
                        Dimension d = View.this.component.getSize();
                        d.width += View.this.margin;
                        d.height += View.this.margin;
                        View.this.setPreferredSize(d);
                        View.this.setBackground(UIUtils.getProfilerResultsBackground());
                        View.this.setForeground(UIUtils.getDarker((Color)View.this.getBackground()));
                    } else {
                        View.this.component = new JLabel(Bundle.Utils_NoDetails(), 0);
                        View.this.component.setEnabled(false);
                        View.this.add(View.this.component, "Center");
                    }
                    View.this.revalidate();
                    View.this.doLayout();
                    View.this.repaint();
                }
            });
        }

        @Override
        public void doLayout() {
            if (this.getLayout() != null) {
                super.doLayout();
            } else {
                Dimension size = this.getSize();
                Dimension comp = this.component.getSize();
                int x = comp.width >= size.width ? 0 : (size.width - comp.width) / 2;
                int y = comp.height >= size.height ? 0 : (size.height - comp.height) / 2;
                this.component.move(x, y);
                this.glassPane.setBounds(this.component.getBounds());
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (!this.pattern || this.component == null) {
                super.paintComponent(g);
            } else {
                int x = 0;
                int w = this.getWidth();
                int h = this.getHeight();
                for (int y = 0; y <= h; y += 20) {
                    boolean flag;
                    boolean bl = flag = y / 20 % 2 == 0;
                    while (x <= w) {
                        g.setColor(flag ? this.getBackground() : this.getForeground());
                        g.fillRect(x, y, 20, 20);
                        x += 20;
                        flag = !flag;
                    }
                    x = 0;
                }
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            Container parent = this.getParent();
            if (parent == null || !(parent instanceof JViewport)) {
                return 50;
            }
            return (int)((float)((JViewport)parent).getHeight() * 0.95f);
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            Container parent = this.getParent();
            if (parent == null || !(parent instanceof JViewport)) {
                return false;
            }
            return this.getPreferredSize().height < ((JViewport)parent).getHeight();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            Container parent = this.getParent();
            if (parent == null || !(parent instanceof JViewport)) {
                return false;
            }
            return this.getPreferredSize().width < ((JViewport)parent).getWidth();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 20;
        }
    }

    static abstract class InstanceBuilder<T> {
        InstanceBuilder(Instance instance, Heap heap) {
        }

        protected void setupInstance(T instance) {
        }

        protected T createInstanceImpl() {
            return null;
        }

        final T createInstance() {
            T instance = this.createInstanceImpl();
            if (instance != null) {
                this.setupInstance(instance);
            }
            return instance;
        }
    }

    static final class JPopupMenuImpl
    extends JPopupMenu {
        JPopupMenuImpl() {
        }

        @Override
        public void setVisible(boolean visible) {
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public Component add(Component comp) {
            if (comp instanceof JComponent) {
                ((JComponent)comp).setOpaque(false);
            }
            return super.add(comp);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JPopupMenuImpl.this.repaint();
                }
            });
        }
    }

    static final class PlaceholderPanel
    extends JPanel {
        private static final Color LINE = UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow");
        private final JLabel label;

        PlaceholderPanel(String className) {
            super(null);
            this.putClientProperty("className", className);
            this.setOpaque(true);
            this.setBorder(BorderFactory.createLineBorder(LINE));
            this.label = new JLabel(BrowserUtils.getSimpleType(className), 0);
            this.label.setOpaque(true);
        }

        @Override
        public void doLayout() {
            Dimension s = this.getSize();
            Dimension p = this.label.getPreferredSize();
            int x = (s.width - p.width) / 2;
            int y = (s.height - p.height) / 2;
            this.label.setBounds(x, y, p.width, p.height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(LINE);
            g.drawLine(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, 0);
            Point p = this.label.getLocation();
            g.translate(p.x, p.y);
            this.label.paint(g);
            g.translate(-p.x, -p.y);
        }
    }

    static final class PlaceholderIcon
    implements Icon {
        private final int width;
        private final int height;

        PlaceholderIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.WHITE);
            g.fillRect(x, y, this.width, this.height);
            g.setColor(Color.BLACK);
            g.drawLine(x, y, x + this.width - 1, y + this.height - 1);
            g.drawLine(x, y + this.height - 1, x + this.width - 1, y);
        }
    }
}

