/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview.model;

import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.classview.model.CVUtil;
import org.netbeans.modules.cnd.classview.model.ObjectNode;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.openide.nodes.Children;

public class MemberNode
extends ObjectNode {
    private CharSequence name;

    public MemberNode(CsmMember mem) {
        super((CsmOffsetableDeclaration)mem, Children.LEAF);
        this.init(mem);
    }

    private void init(final CsmMember mem) {
        boolean isTemplate = false;
        final CharSequence old = this.name;
        this.name = mem.getName();
        if (mem.getKind() == CsmDeclaration.Kind.CLASS) {
            isTemplate = CsmKindUtilities.isTemplate((CsmObject)mem);
        } else if (CsmKindUtilities.isFunction((CsmObject)mem)) {
            CsmFunction fun = (CsmFunction)mem;
            isTemplate = CsmKindUtilities.isTemplate((CsmObject)fun);
            this.name = CVUtil.getSignature(fun);
        }
        if (isTemplate) {
            this.name = this.name + "<>";
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    if (old == null || !old.equals(MemberNode.this.name)) {
                        MemberNode.this.fireNameChange(old == null ? null : old.toString(), MemberNode.this.name == null ? null : MemberNode.this.name.toString());
                        MemberNode.this.fireDisplayNameChange(old == null ? null : old.toString(), MemberNode.this.name == null ? null : MemberNode.this.name.toString());
                        MemberNode.this.fireShortDescriptionChange(old == null ? null : old.toString(), MemberNode.this.name == null ? null : MemberNode.this.name.toString());
                    }
                    MemberNode.this.fireIconChange();
                    MemberNode.this.fireOpenedIconChange();
                } else {
                    MemberNode.this.resetIcon(CsmImageLoader.getImage((CsmObject)mem));
                    SwingUtilities.invokeLater(this);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(runnable);
        } else {
            runnable.run();
        }
    }

    public String getName() {
        return this.name.toString();
    }

    public String getDisplayName() {
        return this.name.toString();
    }

    public String getShortDescription() {
        return this.name.toString();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if (o instanceof CsmMember) {
            CsmMember cls = (CsmMember)o;
            this.setObject((CsmOffsetableDeclaration)cls);
            this.init(cls);
        } else if (o != null) {
            System.err.println("Expected CsmMember. Actually event contains " + o.toString());
        }
    }
}

