/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.base.input.InputReaderTask;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineProcessors;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.optional.ErrorLineConvertor;
import org.netbeans.modules.j2ee.weblogic9.optional.NonProxyHostsHelper;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.netbeans.modules.weblogic.common.api.WebLogicRuntime;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class ServerLogManager {
    private static final Logger LOGGER = Logger.getLogger(ServerLogManager.class.getName());
    private final WLDeploymentManager dm;
    private InputReaderTask task;

    public ServerLogManager(WLDeploymentManager dm) {
        this.dm = dm;
    }

    public synchronized void openLog() {
        InputOutput io = UISupport.getServerIO((String)this.dm.getUri());
        if (io != null) {
            io.select();
        }
        if (this.task == null) {
            WebLogicRuntime runtime = WebLogicRuntime.getInstance((WebLogicConfiguration)this.dm.getCommonConfiguration());
            OutputWriter writer = io.getOut();
            if (this.dm.isRemote() || !runtime.isProcessRunning()) {
                try {
                    writer.reset();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
            }
            if (!runtime.isProcessRunning()) {
                this.task = runtime.createLogReaderTask(LineProcessors.printing((OutputWriter)writer, (LineConvertor)new ErrorLineConvertor(), (boolean)true), (Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return NonProxyHostsHelper.getNonProxyHosts();
                    }
                });
                RequestProcessor.getDefault().post((Runnable)this.task);
            }
        }
    }

    public synchronized void stop() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }
}

