/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLProductProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.weblogic.common.api.WebLogicLayout;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class WLPluginProperties {
    private static final Logger LOGGER = Logger.getLogger(WLPluginProperties.class.getName());
    private static final String CONFIG_XML = "config/config.xml";
    public static final String SERVER_ROOT_ATTR = "serverRoot";
    public static final String DOMAIN_ROOT_ATTR = "domainRoot";
    public static final String HOST_ATTR = "host";
    public static final String PORT_ATTR = "port";
    public static final String REMOTE_ATTR = "remote";
    public static final String SECURED_ATTR = "secured";
    public static final String DEBUGGER_PORT_ATTR = "debuggerPort";
    public static final String DOMAIN_NAME = "domainName";
    public static final String REMOTE_DEBUG_ENABLED = "remoteDebug";
    public static final String DEPLOY_TARGETS = "deployTargets";
    public static final String PROXY_ENABLED = "proxy_enabled";
    public static final String VENDOR = "vendor";
    public static final String JAVA_OPTS = "java_opts";
    public static final String MEM_OPTS = "mem_opts";
    public static final String BEA_JAVA_HOME = "bea_java_home";
    public static final String SUN_JAVA_HOME = "sun_java_home";
    public static final String JAVA_HOME = "java_home";
    private static final Pattern WIN_BEA_JAVA_HOME_PATTERN = Pattern.compile("\\s*(set) BEA_JAVA_HOME\\s*=(.*)");
    private static final Pattern WIN_SUN_JAVA_HOME_PATTERN = Pattern.compile("\\s*(set) SUN_JAVA_HOME\\s*=(.*)");
    private static final Pattern WIN_JAVA_VENDOR_CHECK_PATTERN = Pattern.compile("\\s*if\\s+\"%JAVA_VENDOR%\"\\s*==\\s*\"([^\"]+)\".*");
    private static final Pattern WIN_JAVA_HOME_PATTERN = Pattern.compile("\\s*(set) JAVA_HOME\\s*=(.*)");
    private static final Pattern WIN_DEFAULT_VENDOR_PATTERN = Pattern.compile("\\s*(set) JAVA_VENDOR\\s*=(.*)");
    private static final Pattern SHELL_JAVA_VENDOR_CHECK_PATTERN = Pattern.compile("\\s*if\\s+\\[\\s+\"\\$\\{JAVA_VENDOR\\}\"\\s*=\\s*\"([^\"]+)\"\\s*\\].*");
    private static final Pattern SHELL_BEA_JAVA_HOME_PATTERN = Pattern.compile("\\s*(export)?\\s*BEA_JAVA_HOME\\s*=(.*)");
    private static final Pattern SHELL_SUN_JAVA_HOME_PATTERN = Pattern.compile("\\s*(export)?\\s*SUN_JAVA_HOME\\s*=(.*)");
    private static final Pattern SHELL_JAVA_HOME_PATTERN = Pattern.compile("\\s*(export)?\\s*JAVA_HOME\\s*=(.*)");
    private static final Pattern SHELL_DEFAULT_VENDOR_PATTERN = Pattern.compile("\\s*(export)?\\s*JAVA_VENDOR\\s*=(.*)");
    private static final String DOMAIN_LIST = "common/nodemanager/nodemanager.domains";
    private static final String DOMAIN_REGISTRY = "domain-registry.xml";
    private static final String INSTALL_ROOT_KEY = "installRoot";
    private static final String FAILED_AUTHENTICATION_REPORTED_KEY = "failedAuthenticationReported";

    private WLPluginProperties() {
    }

    public static String getLastServerRoot() {
        return WLPluginProperties.getPreferences().get(INSTALL_ROOT_KEY, "");
    }

    public static void setLastServerRoot(String serverRoot) {
        WLPluginProperties.getPreferences().put(INSTALL_ROOT_KEY, serverRoot);
    }

    public static boolean isFailedAuthenticationReported() {
        return WLPluginProperties.getPreferences().getBoolean(FAILED_AUTHENTICATION_REPORTED_KEY, true);
    }

    public static void setFailedAuthenticationReported(boolean reported) {
        WLPluginProperties.getPreferences().putBoolean(FAILED_AUTHENTICATION_REPORTED_KEY, reported);
    }

    @CheckForNull
    public static FileObject getDomainConfigFileObject(WLDeploymentManager manager) {
        String domainDir = manager.getInstanceProperties().getProperty(DOMAIN_ROOT_ATTR);
        if (domainDir == null) {
            return null;
        }
        return WLPluginProperties.getDomainConfigFileObject(new File(domainDir));
    }

    @CheckForNull
    public static FileObject getDomainConfigFileObject(File domainDir) {
        File domainPath = FileUtil.normalizeFile((File)domainDir);
        FileObject domain = FileUtil.toFileObject((File)domainPath);
        FileObject domainConfig = null;
        if (domain != null) {
            domainConfig = domain.getFileObject(CONFIG_XML);
        }
        return domainConfig;
    }

    @CheckForNull
    public static File getDomainConfigFile(InstanceProperties props) {
        String domainDir = props.getProperty(DOMAIN_ROOT_ATTR);
        if (domainDir == null) {
            return null;
        }
        return WebLogicLayout.getDomainConfigFile((File)new File(domainDir));
    }

    @CheckForNull
    public static File getDomainLibDirectory(WLDeploymentManager manager) {
        File domainLib;
        String domain = manager.getInstanceProperties().getProperty(DOMAIN_ROOT_ATTR);
        if (domain != null && (domainLib = new File(new File(domain), "lib")).exists() && domainLib.isDirectory()) {
            return domainLib;
        }
        return null;
    }

    @CheckForNull
    public static File getServerLibDirectory(WLDeploymentManager manager, boolean fallback) {
        File serverLib;
        File server = WLPluginProperties.getServerRoot(manager, fallback);
        if (server != null && (serverLib = new File(server, "server" + File.separator + "lib")).exists() && serverLib.isDirectory()) {
            return serverLib;
        }
        return null;
    }

    @CheckForNull
    public static File getServerLibDirectory(File serverFile) {
        File serverLib = new File(serverFile, "server" + File.separator + "lib");
        if (serverLib.exists() && serverLib.isDirectory()) {
            return serverLib;
        }
        return null;
    }

    @CheckForNull
    public static File getServerRoot(WLDeploymentManager manager, boolean fallback) {
        File serverFile;
        String server = manager.getInstanceProperties().getProperty(SERVER_ROOT_ATTR);
        if (fallback && server == null) {
            server = WLPluginProperties.getLastServerRoot();
        }
        if (server != null && (serverFile = new File(server)).exists() && serverFile.isDirectory()) {
            return serverFile;
        }
        return null;
    }

    @CheckForNull
    public static File getWeblogicJar(WLDeploymentManager manager) {
        String server = manager.getInstanceProperties().getProperty(SERVER_ROOT_ATTR);
        if (server != null) {
            File serverFile = new File(server);
            return WebLogicLayout.getWeblogicJar((File)serverFile);
        }
        return null;
    }

    public static String[] getRegisteredDomainPaths(String serverRoot) {
        ArrayList<String> result = new ArrayList<String>(WLPluginProperties.getDomainsFromRegistry(serverRoot));
        if (result.isEmpty()) {
            result.addAll(WLPluginProperties.getDomainsFromNodeManager(serverRoot));
        }
        return result.toArray(new String[result.size()]);
    }

    @CheckForNull
    public static String getDefaultPlatformHome() {
        Collection instFolders = JavaPlatformManager.getDefault().getDefaultPlatform().getInstallFolders();
        return instFolders.isEmpty() ? null : FileUtil.toFile((FileObject)((FileObject)instFolders.iterator().next())).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getRuntimeProperties(String domainPath) {
        Properties properties = new Properties();
        Properties javaHomeVendors = new Properties();
        String beaJavaHome = null;
        String sunJavaHome = null;
        properties.put(JAVA_HOME, javaHomeVendors);
        if (domainPath == null) {
            javaHomeVendors.put("", WLPluginProperties.getDefaultPlatformHome());
            return properties;
        }
        try {
            String setDomainEnv = domainPath + (Utilities.isWindows() ? "/bin/setDomainEnv.cmd" : "/bin/setDomainEnv.sh");
            File file = new File(setDomainEnv);
            if (!file.exists()) {
                LOGGER.log(Level.INFO, "Domain environment setup {0} is not found. Probably server configuration was changed externally", setDomainEnv);
                javaHomeVendors.put("", WLPluginProperties.getDefaultPlatformHome());
                return properties;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            try {
                String line;
                Pattern defaultVendorPattern;
                Pattern javaHomePattern;
                Pattern vendorPattern;
                Pattern sunPattern;
                Pattern beaPattern;
                String vendorName = null;
                boolean vendorsSection = false;
                boolean defaultVendorInit = false;
                if (Utilities.isWindows()) {
                    beaPattern = WIN_BEA_JAVA_HOME_PATTERN;
                    sunPattern = WIN_SUN_JAVA_HOME_PATTERN;
                    vendorPattern = WIN_JAVA_VENDOR_CHECK_PATTERN;
                    javaHomePattern = WIN_JAVA_HOME_PATTERN;
                    defaultVendorPattern = WIN_DEFAULT_VENDOR_PATTERN;
                } else {
                    beaPattern = SHELL_BEA_JAVA_HOME_PATTERN;
                    sunPattern = SHELL_SUN_JAVA_HOME_PATTERN;
                    vendorPattern = SHELL_JAVA_VENDOR_CHECK_PATTERN;
                    javaHomePattern = SHELL_JAVA_HOME_PATTERN;
                    defaultVendorPattern = SHELL_DEFAULT_VENDOR_PATTERN;
                }
                while ((line = reader.readLine()) != null) {
                    Matcher bea = beaPattern.matcher(line);
                    Matcher sun = sunPattern.matcher(line);
                    Matcher vendor = vendorPattern.matcher(line);
                    Matcher javaHomeMatcher = javaHomePattern.matcher(line);
                    Matcher defaultVendor = defaultVendorPattern.matcher(line);
                    if (vendor.matches()) {
                        vendorsSection = true;
                        vendorName = vendor.group(1).trim();
                        continue;
                    }
                    if (javaHomeMatcher.matches()) {
                        if (vendorName != null) {
                            javaHomeVendors.put(vendorName, WLPluginProperties.unquote(javaHomeMatcher.group(2)).trim());
                            continue;
                        }
                        if (!defaultVendorInit) continue;
                        javaHomeVendors.put("", WLPluginProperties.unquote(javaHomeMatcher.group(2)).trim());
                        defaultVendorInit = false;
                        continue;
                    }
                    vendorName = null;
                    if (bea.matches()) {
                        beaJavaHome = bea.group(2).trim();
                        continue;
                    }
                    if (sun.matches()) {
                        sunJavaHome = sun.group(2).trim();
                        continue;
                    }
                    if (!vendorsSection || !defaultVendor.matches()) continue;
                    defaultVendorInit = true;
                    vendorsSection = false;
                }
            }
            finally {
                reader.close();
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        if (beaJavaHome != null) {
            properties.put(BEA_JAVA_HOME, WLPluginProperties.unquote(beaJavaHome));
        }
        if (sunJavaHome != null) {
            properties.put(SUN_JAVA_HOME, WLPluginProperties.unquote(sunJavaHome));
        }
        return properties;
    }

    private static String unquote(String value) {
        if (Utilities.isWindows()) {
            return value;
        }
        String result = value;
        String quote = "\"";
        if (result.startsWith(quote)) {
            result = result.substring(1);
        }
        if (result.endsWith(quote)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(WLPluginProperties.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] getClassPath(WLDeploymentManager manager) {
        WLProductProperties prodProps;
        String mwHome;
        File serverRoot = WLPluginProperties.getServerRoot(manager, true);
        if (serverRoot == null) {
            LOGGER.log(Level.INFO, "The server root directory does not exist for {0}", manager.getUri());
            return new File[0];
        }
        File weblogicJar = WebLogicLayout.getWeblogicJar((File)serverRoot);
        if (!weblogicJar.exists()) {
            LOGGER.log(Level.INFO, "File {0} does not exist for {1}", new Object[]{weblogicJar.getAbsolutePath(), manager.getUri()});
            return new File[]{weblogicJar};
        }
        String serverModulesJar = null;
        try {
            JarFile jar = new JarFile(weblogicJar);
            try {
                Manifest manifest = jar.getManifest();
                if (manifest != null) {
                    String[] elements;
                    String classpath = manifest.getMainAttributes().getValue("Class-Path");
                    for (String element : elements = classpath.split("\\s+")) {
                        int index;
                        if (!element.contains("weblogic.server.modules")) continue;
                        File ref = new File(weblogicJar.getParentFile(), element);
                        if (!ref.exists()) {
                            LOGGER.log(Level.INFO, "Broken {0} classpath file {1} for {2}", new Object[]{weblogicJar.getAbsolutePath(), ref.getAbsolutePath(), manager.getUri()});
                        }
                        if ((index = (serverModulesJar = element).lastIndexOf("./")) < 0) continue;
                        serverModulesJar = serverModulesJar.substring(index + 1);
                    }
                }
            }
            finally {
                try {
                    jar.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, null, ex);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, null, e);
        }
        if (serverModulesJar != null && (mwHome = (prodProps = manager.getProductProperties()).getMiddlewareHome()) != null) {
            File serverModuleFile = FileUtil.normalizeFile((File)new File(new File(mwHome), serverModulesJar.replaceAll("/", Matcher.quoteReplacement(File.separator))));
            return new File[]{weblogicJar, serverModuleFile};
        }
        return new File[]{weblogicJar};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Version getServerVersion(File serverRoot) {
        File weblogicJar = WebLogicLayout.getWeblogicJar((File)serverRoot);
        if (!weblogicJar.exists()) {
            return null;
        }
        try {
            JarFile jar = new JarFile(weblogicJar);
            try {
                Manifest manifest = jar.getManifest();
                String implementationVersion = null;
                if (manifest != null) {
                    implementationVersion = manifest.getMainAttributes().getValue("Implementation-Version");
                }
                if (implementationVersion == null) return null;
                implementationVersion = implementationVersion.trim();
                Version version = Version.fromJsr277OrDottedNotationWithFallback((String)implementationVersion);
                return version;
            }
            finally {
                try {
                    jar.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINEST, null, ex);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, null, e);
        }
        return null;
    }

    @CheckForNull
    public static File getMiddlewareHome(File platformRootFile) {
        String mwHome = WLProductProperties.getMiddlewareHome(platformRootFile);
        return WLPluginProperties.getMiddlewareHome(platformRootFile, mwHome);
    }

    @CheckForNull
    public static File getMiddlewareHome(@NonNull File platformRootFile, @NullAllowed String mwHome) {
        File middleware = null;
        if (mwHome != null) {
            middleware = new File(mwHome);
        }
        if (middleware == null || !middleware.exists() || !middleware.isDirectory()) {
            middleware = platformRootFile.getParentFile();
        }
        if (middleware != null && middleware.exists() && middleware.isDirectory()) {
            return middleware;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getDomainsFromNodeManager(String serverRoot) {
        if (serverRoot == null) {
            return Collections.emptyList();
        }
        File file = new File(serverRoot + File.separator + DOMAIN_LIST.replaceAll("/", Matcher.quoteReplacement(File.separator)));
        if (!file.exists() || !file.canRead()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader lnr = null;
        try {
            String line;
            lnr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = lnr.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String path = line.split("=")[1].replaceAll("\\\\\\\\", "/").replaceAll("\\\\:", ":");
                result.add(path);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        finally {
            try {
                if (lnr != null) {
                    lnr.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getDomainsFromRegistry(String serverRoot) {
        if (serverRoot == null) {
            return Collections.emptyList();
        }
        File mwHome = WLPluginProperties.getMiddlewareHome(new File(serverRoot));
        if (mwHome == null) {
            return Collections.emptyList();
        }
        File file = new File(mwHome, DOMAIN_REGISTRY);
        if (!file.exists() || !file.canRead()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        InputStream inputStream = null;
        Document document = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element root = document.getDocumentElement();
            NodeList children = root.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                String location;
                Node attr;
                Node child = children.item(j);
                if (!"domain".equals(child.getNodeName()) || (attr = child.getAttributes().getNamedItem("location")) == null || (location = attr.getNodeValue()) == null) continue;
                result.add(location);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        catch (SAXException e) {
            LOGGER.log(Level.INFO, null, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
        return result;
    }

    private static boolean hasRequiredChildren(File candidate, Collection requiredChildren) {
        if (null == candidate) {
            return false;
        }
        String[] children = candidate.list();
        if (null == children) {
            return false;
        }
        if (null == requiredChildren) {
            return true;
        }
        for (String next : requiredChildren) {
            File test = new File(candidate.getPath() + File.separator + next);
            if (test.exists()) continue;
            return false;
        }
        return true;
    }

    public static final class JvmVendor {
        public static final JvmVendor ORACLE = new JvmVendor("Oracle", NbBundle.getMessage(JvmVendor.class, (String)"LBL_OracleJvmJRockit"));
        public static final JvmVendor SUN = new JvmVendor("Sun", NbBundle.getMessage(JvmVendor.class, (String)"LBL_OracleJvmHotSpot"));
        public static final JvmVendor DEFAULT = new JvmVendor("", NbBundle.getMessage(JvmVendor.class, (String)"LBL_OracleJvmDefault"));
        private final String name;
        private final String displayName;

        private JvmVendor(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }

        public String toPropertiesString() {
            return this.name;
        }

        public String toString() {
            return this.displayName;
        }

        public static JvmVendor fromPropertiesString(String value) {
            if (ORACLE.toPropertiesString().equals(value)) {
                return ORACLE;
            }
            if (SUN.toPropertiesString().equals(value)) {
                return SUN;
            }
            if (value == null || value.trim().length() == 0) {
                return DEFAULT;
            }
            return new JvmVendor(value, value);
        }
    }
}

