/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.util.List;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.ResourceNode;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.actions.UnregisterCookie;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class JdbcChildrenFactory
extends ChildFactory<ResourceNode>
implements RefreshModulesCookie {
    private final JdbcNodeTypes type;
    private final Retriever retriever;
    private final UnregisterFactory unregisterFactory;
    private final Lookup lookup;

    public JdbcChildrenFactory(JdbcNodeTypes type, Retriever retriever, UnregisterFactory unregisterFactory, Lookup lookup) {
        this.type = type;
        this.retriever = retriever;
        this.unregisterFactory = unregisterFactory;
        this.lookup = lookup;
    }

    @Override
    public final void refresh() {
        this.retriever.clean();
        this.refresh(false);
    }

    protected boolean createKeys(List<ResourceNode> children) {
        this.retriever.waitForCompletion();
        List<JDBCDataBean> jdbcDataBeans = this.retriever.get();
        if (jdbcDataBeans != null) {
            if (this.type == JdbcNodeTypes.POOL) {
                for (JDBCDataBean jdbcDataBean : jdbcDataBeans) {
                    String name = jdbcDataBean.getName();
                    if (jdbcDataBean.isApplication()) {
                        name = jdbcDataBean.getDeploymentName();
                    }
                    children.add(new ResourceNode(Children.LEAF, ResourceNode.ResourceNodeType.JDBC, jdbcDataBean.getName(), this.unregisterFactory != null ? this.unregisterFactory.createUnregisterForPool(name, this, this.lookup) : null));
                }
            } else if (this.type == JdbcNodeTypes.RESOURCES) {
                for (JDBCDataBean jdbcDataBean : jdbcDataBeans) {
                    String[] jndiNames = jdbcDataBean.getJndiNames();
                    boolean isApplication = jdbcDataBean.isApplication();
                    for (String name : jndiNames) {
                        ResourceNode node = new ResourceNode(Children.LEAF, ResourceNode.ResourceNodeType.JDBC, name, isApplication ? null : (this.unregisterFactory != null ? this.unregisterFactory.createUnregisterForResource(name, this, this.lookup) : null));
                        children.add(node);
                    }
                }
            }
            return true;
        }
        this.retriever.retrieve();
        return false;
    }

    protected Node createNodeForKey(ResourceNode key) {
        return key;
    }

    public static final class JDBCDataBean {
        private final String name;
        private final String[] jndiNames;
        private final String deploymentName;

        public JDBCDataBean(String poolName, String[] jndiNames) {
            this(poolName, jndiNames, null);
        }

        public JDBCDataBean(String poolName, String[] jndiNames, String deploymentName) {
            this.name = poolName;
            this.jndiNames = (String[])jndiNames.clone();
            this.deploymentName = deploymentName;
        }

        String getName() {
            return this.name;
        }

        String[] getJndiNames() {
            return this.jndiNames;
        }

        boolean isApplication() {
            return this.deploymentName != null;
        }

        String getDeploymentName() {
            return this.deploymentName;
        }
    }

    public static interface UnregisterFactory {
        public UnregisterCookie createUnregisterForPool(String var1, RefreshModulesCookie var2, Lookup var3);

        public UnregisterCookie createUnregisterForResource(String var1, RefreshModulesCookie var2, Lookup var3);
    }

    public static interface Retriever {
        public List<JDBCDataBean> get();

        public void retrieve();

        public void clean();

        public void waitForCompletion();
    }

    static enum JdbcNodeTypes {
        RESOURCES,
        POOL;

    }
}

