/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.cnd.makeproject.api.DefaultProjectOperationsImplementationExecutor;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.MoveOrRenameOperationImplementation;
import org.netbeans.spi.project.support.ProjectOperations;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DefaultProjectOperationsImplementationExecutorImpl
implements DefaultProjectOperationsImplementationExecutor {
    private static final Logger LOG = Logger.getLogger(DefaultProjectOperationsImplementationExecutorImpl.class.getName());
    private static final double NOTIFY_WORK = 0.1;
    private static final double FIND_PROJECT_WORK = 0.1;
    static final int MAX_WORK = 100;

    private static String getDisplayName(Project project) {
        return ProjectUtils.getInformation((Project)project).getDisplayName();
    }

    @Override
    public void doDeleteProject(Project project, boolean onlyMetadata, ProgressHandle handle) throws Exception {
        FileObject projectFolder = project.getProjectDirectory();
        LOG.log(Level.FINE, "delete started: {0}", DefaultProjectOperationsImplementationExecutorImpl.getDisplayName(project));
        ArrayList metadataFiles = ProjectOperations.getMetadataFiles((Project)project);
        List dataFiles = ProjectOperations.getDataFiles((Project)project);
        ArrayList allFiles = new ArrayList();
        allFiles.addAll(metadataFiles);
        allFiles.addAll(dataFiles);
        Iterator i = allFiles.iterator();
        while (i.hasNext()) {
            FileObject f = (FileObject)i.next();
            if (FileUtil.isParentOf((FileObject)projectFolder, (FileObject)f) || projectFolder.equals(f)) continue;
            i.remove();
        }
        ArrayList toDelete = onlyMetadata ? metadataFiles : allFiles;
        try {
            handle.start(toDelete.size() + 1);
            int done = 0;
            handle.progress(NbBundle.getMessage(DefaultProjectOperationsImplementationExecutorImpl.class, (String)"LBL_Progress_Cleaning_Project"));
            ProjectOperations.notifyDeleting((Project)project);
            handle.progress(++done);
            for (FileObject f : toDelete) {
                handle.progress(NbBundle.getMessage(DefaultProjectOperationsImplementationExecutorImpl.class, (String)"LBL_Progress_Deleting_File", (Object)FileUtil.getFileDisplayName((FileObject)f)));
                if (f != null && f.isValid()) {
                    f.delete();
                }
                handle.progress(++done);
            }
            projectFolder.refresh();
            if (!projectFolder.isValid()) {
                LOG.log(Level.WARNING, "invalid project folder: {0}", projectFolder);
            } else if (projectFolder.getChildren().length == 0) {
                projectFolder.delete();
            } else {
                LOG.log(Level.WARNING, "project folder {0} was not empty: {1}", new Object[]{projectFolder, Arrays.asList(projectFolder.getChildren())});
            }
            handle.finish();
            ProjectOperations.notifyDeleted((Project)project);
        }
        catch (Exception e) {
            String displayName = DefaultProjectOperationsImplementationExecutorImpl.getDisplayName(project);
            String message = NbBundle.getMessage(DefaultProjectOperationsImplementationExecutorImpl.class, (String)"LBL_Project_cannot_be_deleted.", (Object)displayName);
            Exceptions.attachLocalizedMessage((Throwable)e, (String)message);
            throw e;
        }
    }

    @Override
    public Project doCopyProject(ProgressHandle handle, Project project, String nueName, FileObject newTarget) throws Exception {
        try {
            int totalWork = 100;
            double currentWorkDone = 0.0;
            handle.progress((int)currentWorkDone);
            ProjectOperations.notifyCopying((Project)project);
            currentWorkDone = (double)totalWork * 0.1;
            handle.progress((int)currentWorkDone);
            FileObject target = newTarget.createFolder(nueName);
            FileObject projectDirectory = project.getProjectDirectory();
            ArrayList<FileObject> toCopyList = new ArrayList<FileObject>();
            for (FileObject child : projectDirectory.getChildren()) {
                if (!child.isValid()) continue;
                toCopyList.add(child);
            }
            double workPerFileAndOperation = (double)totalWork * 0.7000000000000001 / (double)toCopyList.size();
            for (FileObject toCopy : toCopyList) {
                this.doCopy(project, toCopy, target);
                int lastWorkDone = (int)currentWorkDone;
                if (lastWorkDone >= (int)(currentWorkDone += workPerFileAndOperation)) continue;
                handle.progress((int)currentWorkDone);
            }
            ProjectManager.getDefault().clearNonProjectCache();
            Project nue = ProjectManager.getDefault().findProject(target);
            assert (nue != null);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            ProjectOperations.notifyCopied((Project)project, (Project)nue, (File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)nueName);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            ProjectManager.getDefault().saveProject(nue);
            handle.progress(totalWork);
            handle.finish();
            return nue;
        }
        catch (Exception e) {
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(DefaultProjectOperationsImplementationExecutorImpl.class, (String)"ERR_Cannot_Copy", (Object)e.getLocalizedMessage()));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Project doMoveProject(ProgressHandle handle, Project project, String nueFolderName, String nueProjectName, FileObject newTarget, boolean isMove) throws Exception {
        boolean originalOK = true;
        FileObject target = null;
        try {
            int totalWork = 100;
            double currentWorkDone = 0.0;
            handle.progress((int)currentWorkDone);
            ProjectOperations.notifyMoving((Project)project);
            currentWorkDone = (double)totalWork * 0.1;
            handle.progress((int)currentWorkDone);
            FileObject projectDirectory = project.getProjectDirectory();
            LOG.log(Level.FINE, "doMoveProject 1/2: {0} @{1}", new Object[]{projectDirectory, project.hashCode()});
            if (LOG.isLoggable(Level.FINER)) {
                for (Project real : OpenProjects.getDefault().getOpenProjects()) {
                    LOG.log(Level.FINER, "  open project: {0} @{1}", new Object[]{real, real.hashCode()});
                }
            }
            double workPerFileAndOperation = (double)totalWork * 0.7000000000000001;
            FileLock lock = projectDirectory.lock();
            try {
                target = projectDirectory.move(lock, newTarget, nueFolderName, null);
            }
            finally {
                lock.releaseLock();
            }
            int lastWorkDone = (int)currentWorkDone;
            if (lastWorkDone < (int)(currentWorkDone += workPerFileAndOperation)) {
                handle.progress((int)currentWorkDone);
            }
            originalOK = false;
            ProjectManager.getDefault().clearNonProjectCache();
            Project nue = ProjectManager.getDefault().findProject(target);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            assert (nue != null);
            assert (nue != project) : "got same Project for " + projectDirectory + " and " + target;
            LOG.log(Level.FINE, "doMoveProject 2/2: {0} @{1}", new Object[]{target, nue.hashCode()});
            ProjectOperations.notifyMoved((Project)project, (Project)nue, (File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)nueProjectName);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            ProjectManager.getDefault().saveProject(nue);
            if (LOG.isLoggable(Level.FINER)) {
                for (Project real : OpenProjects.getDefault().getOpenProjects()) {
                    LOG.log(Level.FINER, "  open project: {0} @{1}", new Object[]{real, real.hashCode()});
                }
            }
            handle.progress(totalWork);
            handle.finish();
            return nue;
        }
        catch (Exception e) {
            if (originalOK) {
                return project;
            }
            ProjectManager.getDefault().clearNonProjectCache();
            if (target == null) {
                if (isMove) {
                    Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(DefaultProjectOperationsImplementationExecutorImpl.class, (String)"ERR_Cannot_Move", (Object)e.getLocalizedMessage()));
                } else {
                    Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(DefaultProjectOperationsImplementationExecutorImpl.class, (String)"ERR_Cannot_Rename", (Object)e.getLocalizedMessage()));
                }
                throw e;
            }
            Project nue = ProjectManager.getDefault().findProject(target);
            if (nue != null) {
                return nue;
            }
            if (isMove) {
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(DefaultProjectOperationsImplementationExecutorImpl.class, (String)"ERR_Cannot_Move", (Object)e.getLocalizedMessage()));
            } else {
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(DefaultProjectOperationsImplementationExecutorImpl.class, (String)"ERR_Cannot_Rename", (Object)e.getLocalizedMessage()));
            }
            throw e;
        }
    }

    @Override
    public boolean isOldStyleRename(ProgressHandle handle, Project project, String nueName) throws Exception {
        Collection operations = project.getLookup().lookupAll(MoveOperationImplementation.class);
        for (MoveOperationImplementation o : operations) {
            if (o instanceof MoveOrRenameOperationImplementation) continue;
            LOG.log(Level.WARNING, "{0} should implement MoveOrRenameOperationImplementation", o.getClass().getName());
            return true;
        }
        return false;
    }

    @Override
    public Project doRenameProject(ProgressHandle handle, Project project, String nueName) throws Exception {
        Collection operations = project.getLookup().lookupAll(MoveOperationImplementation.class);
        for (MoveOperationImplementation o : operations) {
            if (o instanceof MoveOrRenameOperationImplementation) continue;
            LOG.log(Level.WARNING, "{0} should implement MoveOrRenameOperationImplementation", o.getClass().getName());
            return this.doRenameProjectOld(handle, project, nueName, operations);
        }
        try {
            handle.switchToDeterminate(4);
            int currentWorkDone = 0;
            handle.progress(++currentWorkDone);
            for (MoveOperationImplementation o : operations) {
                ((MoveOrRenameOperationImplementation)o).notifyRenaming();
            }
            handle.progress(++currentWorkDone);
            for (MoveOperationImplementation o : operations) {
                ((MoveOrRenameOperationImplementation)o).notifyRenamed(nueName);
            }
            handle.progress(++currentWorkDone);
            ProjectManager.getDefault().saveProject(project);
            handle.progress(++currentWorkDone);
            handle.finish();
        }
        catch (Exception e) {
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(DefaultProjectOperationsImplementationExecutorImpl.class, (String)"ERR_Cannot_Rename", (Object)e.getLocalizedMessage()));
            throw e;
        }
        return null;
    }

    private void doCopy(Project original, FileObject from, FileObject toParent) throws IOException {
        if (!VisibilityQuery.getDefault().isVisible(from)) {
            return;
        }
        if (!original.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)from).getProjectDirectory())) {
            return;
        }
        if (SharabilityQuery.getSharability((FileObject)from) == SharabilityQuery.Sharability.NOT_SHARABLE) {
            return;
        }
        if (from.isFolder()) {
            FileObject copy = toParent.createFolder(from.getNameExt());
            for (FileObject kid : from.getChildren()) {
                this.doCopy(original, kid, copy);
            }
        } else {
            assert (from.isData());
            FileUtil.copyFile((FileObject)from, (FileObject)toParent, (String)from.getName(), (String)from.getExt());
        }
    }

    private Project doRenameProjectOld(ProgressHandle handle, Project project, String nueName, Collection<? extends MoveOperationImplementation> operations) throws Exception {
        boolean originalOK = true;
        Project nue = null;
        try {
            handle.switchToIndeterminate();
            handle.switchToDeterminate(5);
            int currentWorkDone = 0;
            FileObject projectDirectory = project.getProjectDirectory();
            File projectDirectoryFile = FileUtil.toFile((FileObject)project.getProjectDirectory());
            handle.progress(++currentWorkDone);
            for (MoveOperationImplementation o : operations) {
                o.notifyMoving();
            }
            handle.progress(++currentWorkDone);
            for (MoveOperationImplementation o : operations) {
                o.notifyMoved(null, projectDirectoryFile, nueName);
            }
            handle.progress(++currentWorkDone);
            ProjectManager.getDefault().clearNonProjectCache();
            nue = ProjectManager.getDefault().findProject(projectDirectory);
            assert (nue != null);
            originalOK = false;
            handle.progress(++currentWorkDone);
            operations = nue.getLookup().lookupAll(MoveOperationImplementation.class);
            for (MoveOperationImplementation o : operations) {
                o.notifyMoved(project, projectDirectoryFile, nueName);
            }
            ProjectManager.getDefault().saveProject(project);
            ProjectManager.getDefault().saveProject(nue);
            handle.progress(++currentWorkDone);
            handle.finish();
            return nue;
        }
        catch (Exception e) {
            if (originalOK) {
                return project;
            }
            assert (nue != null);
            return nue;
        }
    }
}

