/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptorProvider;
import org.openide.util.Lookup;

public class PackagerManager {
    private static final PackagerManager instance = new PackagerManager();
    private final List<PackagerDescriptor> list = new ArrayList<PackagerDescriptor>();

    public static PackagerManager getDefault() {
        return instance;
    }

    private PackagerManager() {
    }

    private void addRegisteredPackagers() {
        Set<PackagerDescriptorProvider> set = PackagerManager.getPackagerDescriptorProviders();
        for (PackagerDescriptorProvider packagerDescriptorProvider : set) {
            List<PackagerDescriptor> aList = packagerDescriptorProvider.getPackagerDescriptorProviderList();
            for (PackagerDescriptor packagerDescriptor : aList) {
                this.addPackagingDescriptor(packagerDescriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackagingDescriptor(PackagerDescriptor packagingDescriptor) {
        List<PackagerDescriptor> list = this.list;
        synchronized (list) {
            PackagerDescriptor packagerDescriptor = this.getPackager(packagingDescriptor.getName());
            if (packagerDescriptor != null) {
                return;
            }
            this.list.add(packagingDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PackagerDescriptor> getPackagerList() {
        List<PackagerDescriptor> list = this.list;
        synchronized (list) {
            return new ArrayList<PackagerDescriptor>(this.list);
        }
    }

    public PackagerDescriptor getPackager(String name) {
        for (PackagerDescriptor packagerDescriptor : this.getPackagerList()) {
            if (!packagerDescriptor.getName().equals(name)) continue;
            return packagerDescriptor;
        }
        return null;
    }

    public int getNameIndex(String name) {
        int index = 0;
        for (PackagerDescriptor packagerDescriptor : this.getPackagerList()) {
            if (packagerDescriptor.getName().equals(name)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    public String[] getDisplayNames() {
        List<PackagerDescriptor> aList = this.getPackagerList();
        String[] ret = new String[aList.size()];
        int i = 0;
        for (PackagerDescriptor packagerDescriptor : aList) {
            ret[i++] = packagerDescriptor.getDisplayName();
        }
        return ret;
    }

    public String getDisplayName(String name) {
        for (PackagerDescriptor packagerDescriptor : this.getPackagerList()) {
            if (!packagerDescriptor.getName().equals(name)) continue;
            return packagerDescriptor.getDisplayName();
        }
        return null;
    }

    public String getName(String displayName) {
        for (PackagerDescriptor packagerDescriptor : this.getPackagerList()) {
            if (!packagerDescriptor.getDisplayName().equals(displayName)) continue;
            return packagerDescriptor.getName();
        }
        return null;
    }

    private static Set<PackagerDescriptorProvider> getPackagerDescriptorProviders() {
        HashSet<PackagerDescriptorProvider> providers = new HashSet<PackagerDescriptorProvider>();
        Lookup.Template template = new Lookup.Template(PackagerDescriptorProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        for (Object caop : result.allInstances()) {
            if (!(caop instanceof PackagerDescriptorProvider)) continue;
            providers.add((PackagerDescriptorProvider)caop);
        }
        return providers;
    }

    static {
        instance.addRegisteredPackagers();
    }
}

