/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectOptionsFormat;
import org.openide.util.NbBundle;

public class CCompilerConfiguration
extends CCCCompilerConfiguration
implements Cloneable {
    public static final int STANDARD_DEFAULT = 0;
    public static final int STANDARD_C89 = 1;
    public static final int STANDARD_C99 = 2;
    public static final int STANDARD_C11 = 3;
    public static final int STANDARD_INHERITED = 4;
    private static final String[] STANDARD_NAMES = new String[]{CCompilerConfiguration.getString("STANDARD_DEFAULT"), CCompilerConfiguration.getString("STANDARD_C89"), CCompilerConfiguration.getString("STANDARD_C99"), CCompilerConfiguration.getString("STANDARD_C11"), CCompilerConfiguration.getString("STANDARD_INHERITED")};
    private static final String[] STANDARD_NAMES_ROOT = new String[]{CCompilerConfiguration.getString("STANDARD_DEFAULT"), CCompilerConfiguration.getString("STANDARD_C89"), CCompilerConfiguration.getString("STANDARD_C99"), CCompilerConfiguration.getString("STANDARD_C11")};
    private IntConfiguration cStandard;

    public CCompilerConfiguration(String baseDir, CCompilerConfiguration master, MakeConfiguration owner) {
        super(baseDir, master, owner);
        this.cStandard = master != null ? new IntConfiguration(null, 4, STANDARD_NAMES, null) : new IntConfiguration(null, 0, STANDARD_NAMES_ROOT, null);
    }

    public void fixupMasterLinks(CCompilerConfiguration compilerConfiguration) {
        super.fixupMasterLinks(compilerConfiguration);
        this.getCStandard().setMaster(compilerConfiguration.getCStandard());
    }

    public IntConfiguration getCStandard() {
        return this.cStandard;
    }

    public int getCStandardExternal() {
        switch (this.getCStandard().getValue()) {
            case 0: {
                return NativeFileItem.LanguageFlavor.DEFAULT.toExternal();
            }
            case 1: {
                return NativeFileItem.LanguageFlavor.C89.toExternal();
            }
            case 2: {
                return NativeFileItem.LanguageFlavor.C99.toExternal();
            }
            case 3: {
                return NativeFileItem.LanguageFlavor.C11.toExternal();
            }
            case 4: {
                return NativeFileItem.LanguageFlavor.UNKNOWN.toExternal();
            }
        }
        return NativeFileItem.LanguageFlavor.UNKNOWN.toExternal();
    }

    public void setCStandard(IntConfiguration cStandard) {
        this.cStandard = cStandard;
    }

    public void setCStandardExternal(int cStandard) {
        if (cStandard == NativeFileItem.LanguageFlavor.DEFAULT.toExternal()) {
            this.cStandard.setValue(0);
        } else if (cStandard == NativeFileItem.LanguageFlavor.C89.toExternal()) {
            this.cStandard.setValue(1);
        } else if (cStandard == NativeFileItem.LanguageFlavor.C99.toExternal()) {
            this.cStandard.setValue(2);
        } else if (cStandard == NativeFileItem.LanguageFlavor.C11.toExternal()) {
            this.cStandard.setValue(3);
        } else if (cStandard == NativeFileItem.LanguageFlavor.UNKNOWN.toExternal()) {
            this.cStandard.setValue(4);
        }
    }

    @Override
    public boolean getModified() {
        return super.getModified() || this.getCStandard().getModified();
    }

    public boolean isCStandardChanged() {
        return this.getCStandard().getDirty() && this.getCStandard().getPreviousValue() != this.getInheritedCStandard();
    }

    public void assign(CCompilerConfiguration conf) {
        super.assign(conf);
        this.getCStandard().assign(conf.getCStandard());
    }

    public CCompilerConfiguration clone() {
        CCompilerConfiguration clone = new CCompilerConfiguration(this.getBaseDir(), (CCompilerConfiguration)this.getMaster(), this.getOwner());
        clone.setDevelopmentMode(this.getDevelopmentMode().clone());
        clone.setWarningLevel(this.getWarningLevel().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setSixtyfourBits(this.getSixtyfourBits().clone());
        clone.setStrip(this.getStrip().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setTool(this.getTool().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setLibraryLevel(this.getLibraryLevel().clone());
        clone.setStandardsEvolution(this.getStandardsEvolution().clone());
        clone.setLanguageExt(this.getLanguageExt().clone());
        clone.setIncludeDirectories((VectorConfiguration<String>)this.getIncludeDirectories().clone());
        clone.setInheritIncludes(this.getInheritIncludes().clone());
        clone.setIncludeFiles((VectorConfiguration<String>)this.getIncludeFiles().clone());
        clone.setInheritFiles(this.getInheritFiles().clone());
        clone.setPreprocessorConfiguration((VectorConfiguration<String>)this.getPreprocessorConfiguration().clone());
        clone.setInheritPreprocessor(this.getInheritPreprocessor().clone());
        clone.setUndefinedPreprocessorConfiguration((VectorConfiguration<String>)this.getUndefinedPreprocessorConfiguration().clone());
        clone.setInheritUndefinedPreprocessor(this.getInheritUndefinedPreprocessor().clone());
        clone.setUseLinkerLibraries(this.getUseLinkerLibraries().clone());
        clone.setImportantFlags(this.getImportantFlags().clone());
        clone.setCStandard(this.getCStandard().clone());
        return clone;
    }

    @Override
    public String getOptions(AbstractCompiler compiler) {
        StringBuilder options = new StringBuilder("$(COMPILE.c) ");
        options.append(this.getAllOptions2(compiler)).append(' ');
        options.append(this.getCommandLineOptions(true));
        return MakeProjectOptionsFormat.reformatWhitespaces(options.toString());
    }

    public String getCFlagsBasic(AbstractCompiler compiler) {
        String options = "";
        options = options + compiler.getMTLevelOptions(this.getMTLevel().getValue()) + " ";
        options = options + compiler.getStandardEvaluationOptions(this.getStandardsEvolution().getValue()) + " ";
        options = options + compiler.getLanguageExtOptions(this.getLanguageExt().getValue()) + " ";
        options = options + compiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == 3) {
            options = options + compiler.getDevelopmentModeOptions(3);
        }
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    public String getCFlags(AbstractCompiler compiler) {
        String options = this.getCFlagsBasic(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        if (!(tool instanceof AbstractCompiler)) {
            return "";
        }
        AbstractCompiler compiler = (AbstractCompiler)tool;
        StringBuilder options = new StringBuilder();
        options.append(this.getCFlagsBasic(compiler)).append(" ");
        this.getMasters(true).forEach(master -> options.append(master.getCommandLineConfiguration().getValue()).append(" "));
        options.append(this.getAllOptions2(compiler)).append(" ");
        return MakeProjectOptionsFormat.reformatWhitespaces(options.toString());
    }

    public String getAllOptions2(AbstractCompiler compiler) {
        String options = "";
        if (this.getDevelopmentMode().getValue() != 3) {
            options = options + compiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        }
        options = options + compiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        options = options + compiler.getStripOption(this.getStrip().getValue()) + " ";
        options = options + this.getPreprocessorOptions(compiler.getCompilerSet());
        options = options + this.getIncludeDirectoriesOptions(compiler.getCompilerSet());
        options = options + this.getLibrariesFlags();
        options = options + compiler.getCStandardOptions(this.getInheritedCStandard());
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    public int getInheritedCStandard() {
        for (BasicCompilerConfiguration master : this.getMasters(true)) {
            if (((CCompilerConfiguration)master).getCStandard().getValue() == 4) continue;
            return ((CCompilerConfiguration)master).getCStandard().getValue();
        }
        return 2;
    }

    public String getPreprocessorOptions(CompilerSet cs) {
        ArrayList<CCompilerConfiguration> list = new ArrayList<CCompilerConfiguration>();
        for (BasicCompilerConfiguration master : this.getMasters(true)) {
            list.add((CCompilerConfiguration)master);
            if (((CCompilerConfiguration)master).getInheritPreprocessor().getValue()) continue;
            break;
        }
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(null, this.getUserMacroFlag(cs));
        StringBuilder options = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            options.append(((CCompilerConfiguration)list.get(i)).getPreprocessorConfiguration().toString(visitor)).append(' ');
        }
        return options.toString();
    }

    public String getIncludeDirectoriesOptions(CompilerSet cs) {
        ArrayList<CCompilerConfiguration> list = new ArrayList<CCompilerConfiguration>();
        for (BasicCompilerConfiguration master : this.getMasters(true)) {
            list.add((CCompilerConfiguration)master);
            if (((CCompilerConfiguration)master).getInheritIncludes().getValue()) continue;
            break;
        }
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(cs, this.getUserIncludeFlag(cs));
        StringBuilder options = new StringBuilder(this.getIncludeDirectories().toString(visitor)).append(' ');
        for (int i = list.size() - 1; i > 0; --i) {
            options.append(((CCompilerConfiguration)list.get(i)).getIncludeDirectories().toString(visitor)).append(' ');
        }
        String includeFilesOptions = this.getIncludeFilesOptions(cs);
        if (includeFilesOptions.isEmpty()) {
            return options.toString();
        }
        return options.toString() + " " + includeFilesOptions;
    }

    private String getIncludeFilesOptions(CompilerSet cs) {
        ArrayList<CCompilerConfiguration> list = new ArrayList<CCompilerConfiguration>();
        for (BasicCompilerConfiguration master : this.getMasters(true)) {
            list.add((CCompilerConfiguration)master);
            if (((CCompilerConfiguration)master).getInheritFiles().getValue()) continue;
            break;
        }
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(cs, this.getUserFileFlag(cs));
        StringBuilder options = new StringBuilder(this.getIncludeFiles().toString(visitor)).append(' ');
        for (int i = list.size() - 1; i > 0; --i) {
            options.append(((CCompilerConfiguration)list.get(i)).getIncludeFiles().toString(visitor)).append(' ');
        }
        return options.toString();
    }

    @Override
    protected ToolchainManager.CompilerDescriptor getCompilerDescriptor(CompilerSet cs) {
        return cs.getCompilerFlavor().getToolchainDescriptor().getC();
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CCompilerConfiguration.class, (String)s);
    }
}

