/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser;

import java.util.ArrayList;
import java.util.Stack;
import org.antlr.runtime.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.modelimpl.parser.FortranParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.FortranToken;
import org.netbeans.modules.cnd.modelimpl.parser.FortranTokenStream;

public class FortranLexicalPrepass {
    private FortranTokenStream tokens;
    private Stack<Token> doLabels;
    private int sourceForm;

    public FortranLexicalPrepass(FortranTokenStream tokens) {
        this.tokens = tokens;
        this.doLabels = new Stack();
    }

    public void setSourceForm(int sourceForm) {
        this.sourceForm = sourceForm;
    }

    private boolean isAssignment(int start, int end) {
        return this.tokens.getToken(start).getType() == 486 && start + 3 < end && this.tokens.getToken(start + 1).getType() == 396 && this.tokens.getToken(start + 2).getType() == 356;
    }

    private boolean isOperator(int start, int end) {
        return this.tokens.getToken(start).getType() == 368 && start + 3 < end && this.tokens.getToken(start + 1).getType() == 396 && this.tokens.getToken(start + 2).getType() == 307 && this.tokens.getToken(start + 3).getType() == 349;
    }

    private void convertToIdents(int start, int end) {
        for (int i = start; i < end; ++i) {
            Token tmpToken = this.tokens.getToken(i);
            if (tmpToken != null) {
                if (!FortranLexer.isKeyword(tmpToken) || this.isAssignment(i, end) || this.isOperator(i, end)) continue;
                tmpToken.setType(291);
                continue;
            }
            System.out.println("convertToIdents(): couldn't retrieve token");
            System.out.println("start: " + start + " end: " + end + " i: " + i);
            this.tokens.printCurrLine();
        }
    }

    public int salesScanForToken(int start, int desiredToken) {
        int tmpToken;
        int lookAhead = 0;
        if (this.tokens.currLineLA(1) == 421) {
            return -1;
        }
        lookAhead = start;
        do {
            int parenOffset;
            if ((tmpToken = this.tokens.currLineLA(++lookAhead)) == 396 || tmpToken == 448) {
                parenOffset = this.tokens.findToken(lookAhead - 1, 396);
                ++parenOffset;
                if ((lookAhead = this.matchClosingParen(start, lookAhead)) < 1) break;
                tmpToken = this.tokens.currLineLA(lookAhead);
                continue;
            }
            if (tmpToken != 385) continue;
            parenOffset = this.tokens.findToken(lookAhead - 1, 385);
            if ((lookAhead = this.matchClosingParen(lookAhead + 1, parenOffset += 2)) < 1) break;
            tmpToken = this.tokens.currLineLA(lookAhead);
        } while (tmpToken != -1 && tmpToken != 297 && tmpToken != desiredToken);
        if (tmpToken == desiredToken) {
            return lookAhead - 1;
        }
        return -1;
    }

    private boolean matchIfConstStmt(int lineStart, int lineEnd) {
        int rparenOffset = -1;
        int commaOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 320 && this.tokens.currLineLA(lineStart + 2) == 396) {
            rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 2);
            commaOffset = this.salesScanForToken(rparenOffset + 1, 433);
            if (rparenOffset == -1) {
                System.err.println("Error in IF stmt at line: " + this.tokens.getToken(0).getLine());
                return false;
            }
            if (this.tokens.currLineLA(rparenOffset + 1) == 321) {
                this.convertToIdents(lineStart + 1, rparenOffset);
                return true;
            }
            if (commaOffset != -1 && this.tokens.currLineLA(rparenOffset + 1) == 359) {
                this.convertToIdents(lineStart + 1, rparenOffset);
                this.tokens.addToken(lineStart, 383, "__T_ARITHMETIC_IF_STMT__");
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean matchElseStmt(int lineStart, int lineEnd) {
        boolean isElseIf = false;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 393) {
            if (lineEnd >= 2) {
                if (this.tokens.currLineLA(lineStart + 2) == 331) {
                    this.convertToIdents(lineStart + 2, lineEnd);
                } else {
                    isElseIf = this.matchIfConstStmt(lineStart + 1, lineEnd);
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchDataDecl(int lineStart, int lineEnd) {
        int tokenType = this.tokens.currLineLA(1);
        if (this.isIntrinsicType(tokenType) || this.isPrefixToken(tokenType) || (tokenType == 473 || tokenType == 285) && this.tokens.currLineLA(lineStart + 2) == 396) {
            if (this.isSubDecl(lineStart, lineEnd)) {
                return false;
            }
            if (this.isFuncDecl(lineStart, lineEnd)) {
                this.fixupFuncDecl(lineStart, lineEnd);
            } else {
                this.fixupDataDecl(lineStart, lineEnd);
            }
            return true;
        }
        if (tokenType == 477) {
            this.fixupFuncDecl(lineStart, lineEnd);
            return true;
        }
        return false;
    }

    private boolean matchDerivedTypeStmt(int lineStart, int lineEnd) {
        Token identToken = null;
        if (this.tokens.currLineLA(lineStart + 1) == 473 && this.tokens.currLineLA(lineStart + 2) != 396) {
            int colonOffset = this.tokens.findToken(lineStart, 360);
            if (colonOffset != -1) {
                int identOffset = colonOffset + 1;
                this.convertToIdents(identOffset, lineEnd);
            } else {
                identToken = this.tokens.getToken(lineStart + 1);
                int identOffset = lineStart + 1;
                if (FortranLexer.isKeyword(identToken)) {
                    identToken.setType(291);
                }
                if (this.tokens.currLineLA(lineStart + 3) == 396) {
                    int rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 3) - 1;
                    if (this.isIntrinsicType(this.tokens.currLineLA(lineStart + 4))) {
                        this.fixupDeclTypeSpec(lineStart + 3, lineEnd);
                    } else {
                        this.convertToIdents(lineStart + 3, lineEnd);
                    }
                    if (lineEnd - 1 > rparenOffset + 1 && FortranLexer.isKeyword(this.tokens.currLineLA(rparenOffset + 2))) {
                        this.tokens.getToken(rparenOffset + 1).setType(291);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchSub(int lineStart, int lineEnd) {
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        int bindOffset = this.tokens.findToken(lineStart, 385);
        if (bindOffset != -1) {
            this.convertToIdents(lineStart + 1, bindOffset + lineStart);
        } else {
            this.convertToIdents(lineStart + 1, lineEnd);
        }
        return true;
    }

    private boolean matchEnd(int lineStart, int lineEnd) {
        boolean matchedEnd = false;
        boolean isEndDo = false;
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 314) {
            if (lineEnd > 2) {
                identOffset = this.tokens.currLineLA(lineStart + 2) == 281 ? lineStart + 3 : (this.tokens.currLineLA(lineStart + 2) == 292 ? this.matchGenericSpec(lineStart + 2, lineEnd) : lineStart + 2);
            }
            if (this.tokens.currLineLA(lineStart + 2) == 387) {
                isEndDo = true;
            }
            matchedEnd = true;
        } else if (tokenType == 351) {
            identOffset = lineStart + 2;
            matchedEnd = true;
        } else if (tokenType == 313) {
            identOffset = this.matchGenericSpec(lineStart + 1, lineEnd);
        } else {
            if (lineEnd > 1) {
                identOffset = lineStart + 1;
            }
            matchedEnd = true;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
        }
        if (isEndDo || tokenType == 463) {
            this.fixupLabeledEndDo(lineStart, lineEnd);
        }
        return matchedEnd;
    }

    private boolean matchModule(int lineStart, int lineEnd) {
        this.convertToIdents(lineStart + 1, lineEnd);
        return true;
    }

    private boolean matchBlockData(int lineStart, int lineEnd) {
        if (lineEnd < lineStart + 2) {
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 281) {
            if (this.tokens.currLineLA(lineStart + 2) == 329) {
                if (lineEnd >= lineStart + 3 && FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 3))) {
                    this.tokens.getToken(lineStart + 2).setType(291);
                }
                return true;
            }
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 339) {
            if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2))) {
                this.tokens.getToken(lineStart + 1).setType(291);
            }
            return true;
        }
        return false;
    }

    private boolean matchUseStmt(int lineStart, int lineEnd) {
        Object onlyToken = null;
        int colonOffset = this.tokens.findToken(lineStart, 360);
        int identPos = colonOffset != -1 ? colonOffset + 1 : lineStart + 1;
        if (FortranLexer.isKeyword(this.tokens.currLineLA(identPos + 1))) {
            this.tokens.getToken(identPos).setType(291);
        }
        if (++identPos < lineEnd) {
            if (this.tokens.currLineLA(identPos + 1) == 433 && this.tokens.currLineLA(identPos + 2) == 457) {
                identPos += 3;
            }
            this.convertToIdents(identPos, lineEnd);
        }
        return true;
    }

    private boolean matchLabel(int lineStart, int lineEnd) {
        return this.tokens.currLineLA(1) == 359;
    }

    private boolean matchIdentColon(int lineStart, int lineEnd) {
        int secondToken = this.tokens.currLineLA(lineStart + 2);
        if (secondToken == 453) {
            if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 1))) {
                this.tokens.getToken(lineStart).setType(291);
            }
            return true;
        }
        return false;
    }

    private boolean matchProcStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        if (lineEnd < lineStart + 2) {
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 411 && this.tokens.currLineLA(lineStart + 2) != 396) {
            int colonOffset = -1;
            colonOffset = this.tokens.findToken(lineStart + 1, 360);
            identOffset = colonOffset != -1 ? colonOffset + 1 : lineStart + 1;
        } else if (this.tokens.currLineLA(lineStart + 1) == 400 && this.tokens.currLineLA(lineStart + 2) == 411) {
            if (lineEnd < lineStart + 4) {
                return false;
            }
            identOffset = lineStart + 2;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            return true;
        }
        return false;
    }

    private boolean matchProcDeclStmt(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 411) {
            int lParenOffset = lineStart + 1;
            int rParenOffset = this.matchClosingParen(lineStart, lParenOffset + 1);
            int colonOffset = this.tokens.findToken(rParenOffset + 1, 360);
            if (colonOffset != -1) {
                this.convertToIdents(colonOffset + 1, lineEnd);
            } else {
                this.convertToIdents(rParenOffset + 1, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchAttrStmt(int lineStart, int lineEnd) {
        int identOffset;
        block7: {
            block11: {
                int firstToken;
                block10: {
                    block9: {
                        int rParenOffset;
                        block8: {
                            identOffset = -1;
                            firstToken = this.tokens.currLineLA(lineStart + 1);
                            if (firstToken != 350) break block8;
                            int lParenOffset = this.tokens.findToken(lineStart + 1, 396);
                            identOffset = this.matchClosingParen(lineStart, lParenOffset + 1);
                            break block7;
                        }
                        if (firstToken != 385) break block9;
                        identOffset = rParenOffset = this.matchClosingParen(lineStart, lineStart + 2);
                        break block7;
                    }
                    if (firstToken != 469) break block10;
                    int lParenOffset = this.tokens.findToken(lineStart + 1, 396);
                    if (lParenOffset != -1) {
                        identOffset = lParenOffset;
                        lineEnd = this.matchClosingParen(lineStart, lParenOffset + 1);
                    }
                    break block7;
                }
                if (firstToken != 319) break block11;
                int lparenOffset = -1;
                int rparenOffset = -1;
                if (this.tokens.currLineLA(lineStart + 2) == 428) break block7;
                boolean nothingChanges = false;
                do {
                    if ((lparenOffset = this.tokens.findToken(lineStart, 396)) != -1) {
                        rparenOffset = this.matchClosingParen(lineStart, lparenOffset + 1);
                        for (int i = lparenOffset; i < rparenOffset; ++i) {
                            if (!FortranLexer.isKeyword(this.tokens.currLineLA(i + 1)) || this.tokens.currLineLA(i + 1) == 308 || this.tokens.currLineLA(i + 1) == 482) continue;
                            this.tokens.getToken(i).setType(291);
                        }
                        if (this.tokens.currLineLA(rparenOffset + 1) == 396) {
                            rparenOffset = this.matchClosingParen(lineStart, rparenOffset + 1);
                        }
                        lineStart = rparenOffset;
                        nothingChanges = false;
                        continue;
                    }
                    if (nothingChanges) break block7;
                    nothingChanges = true;
                } while (lineStart < lineEnd && this.tokens.currLineLA(lineStart + 1) != 297);
                break block7;
                {
                }
            }
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            return true;
        }
        return false;
    }

    private int matchClosingParen(int lineStart, int offset) {
        int tmpTokenType;
        int lookAhead = 0;
        int nestingLevel = 0;
        lookAhead = offset;
        nestingLevel = 1;
        do {
            if ((tmpTokenType = this.tokens.currLineLA(++lookAhead)) == 396 || tmpTokenType == 448) {
                ++nestingLevel;
                continue;
            }
            if (tmpTokenType != 349 && tmpTokenType != 395) continue;
            --nestingLevel;
        } while ((tmpTokenType != 297 && tmpTokenType != -1 || nestingLevel == 0) && (nestingLevel != 0 || tmpTokenType != 349 && tmpTokenType != 395 && tmpTokenType != 297 && tmpTokenType != -1));
        if (tmpTokenType == 349 || tmpTokenType == 395) {
            return lookAhead;
        }
        return -1;
    }

    private int fixupDeclTypeSpec(int lineStart, int lineEnd) {
        int kindOffsetEnd = -1;
        if (this.tokens.currLineLA(lineStart + 1) == 473 || this.tokens.currLineLA(lineStart + 1) == 285) {
            int rparenOffset = -1;
            if (this.tokens.currLineLA(lineStart + 2) != 396) {
                System.err.println("Derived type or Class declaration error!");
            }
            rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            this.convertToIdents(lineStart + 1, rparenOffset);
            return rparenOffset - 1;
        }
        if (this.tokens.currLineLA(lineStart + 2) == 396) {
            int kindTokenOffset = -1;
            int lenTokenOffset = -1;
            kindOffsetEnd = this.matchClosingParen(lineStart, this.tokens.findToken(lineStart, 396) + 1);
            kindTokenOffset = this.tokens.findToken(lineStart + 1, 308);
            lenTokenOffset = this.tokens.findToken(lineStart + 1, 482);
            this.convertToIdents(lineStart + 1, kindOffsetEnd);
            if (kindTokenOffset != -1 && kindTokenOffset < kindOffsetEnd && this.tokens.currLineLA(kindTokenOffset + 2) == 356) {
                this.tokens.getToken(kindTokenOffset).setType(308);
            }
            if (lenTokenOffset != -1 && lenTokenOffset < kindOffsetEnd && this.tokens.currLineLA(lenTokenOffset + 2) == 356) {
                this.tokens.getToken(lenTokenOffset).setType(482);
            }
            return kindOffsetEnd - 1;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 399) {
            ++lineStart;
        }
        return lineStart;
    }

    private void fixupDataDecl(int lineStart, int lineEnd) {
        int identOffset = this.tokens.findToken(lineStart = this.fixupDeclTypeSpec(lineStart, lineEnd), 360);
        identOffset = identOffset != -1 ? ++identOffset : lineStart + 1;
        this.convertToIdents(identOffset, lineEnd);
    }

    private void fixupFuncDecl(int lineStart, int lineEnd) {
        int newLineStart = 0;
        Token resultToken = null;
        Token bindToken = null;
        newLineStart = this.fixupDeclTypeSpec(lineStart, lineEnd);
        if (newLineStart != lineStart) {
            lineStart = newLineStart + 1;
        }
        int identOffset = this.tokens.findToken(lineStart, 477) + 1;
        int resultOffset = this.salesScanForToken(lineStart, 434);
        int bindOffset = this.salesScanForToken(lineStart, 385);
        if (resultOffset != -1) {
            resultToken = this.tokens.getToken(resultOffset);
        }
        if (bindOffset != -1) {
            bindToken = this.tokens.getToken(bindOffset);
        }
        this.convertToIdents(identOffset, lineEnd);
        if (resultToken != null) {
            resultToken.setType(434);
        }
        if (bindToken != null) {
            bindToken.setType(385);
        }
    }

    private boolean isIntrinsicType(int type) {
        return type == 403 || type == 409 || type == 399 || type == 317 || type == 454 || type == 379 || type == 436;
    }

    private int skipTypeSpec(int lineStart) {
        int rparenOffset = -1;
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (this.isIntrinsicType(firstToken) || firstToken == 473) {
            if (firstToken == 399) {
                ++lineStart;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 315 && this.tokens.currLineLA(lineStart + 3) == 359) {
                lineStart += 2;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 396) {
                rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            }
            lineStart = rparenOffset != -1 ? rparenOffset : ++lineStart;
            return lineStart;
        }
        return lineStart;
    }

    private int skipPrefix(int lineStart) {
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        lineStart = this.skipTypeSpec(lineStart);
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        return lineStart;
    }

    private boolean isPrefixToken(int token) {
        return token == 415 || token == 378 || token == 336;
    }

    private boolean isFuncDecl(int lineStart, int lineEnd) {
        return this.tokens.currLineLA((lineStart = this.skipPrefix(lineStart)) + 1) == 477 && (this.tokens.currLineLA(lineStart + 2) == 291 || FortranLexer.isKeyword(this.tokens.currLineLA(3)));
    }

    private boolean isSubDecl(int lineStart, int lineEnd) {
        return this.tokens.currLineLA((lineStart = this.skipPrefix(lineStart)) + 1) == 303 && (this.tokens.currLineLA(lineStart + 2) == 291 || FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2)));
    }

    private boolean isValidDataEditDesc(String line, int lineIndex) {
        char secondChar = '\u0000';
        char firstChar = Character.toLowerCase(line.charAt(lineIndex));
        if (lineIndex < line.length() - 1) {
            secondChar = Character.toLowerCase(line.charAt(lineIndex + 1));
        }
        return firstChar == 'i' || firstChar == 'b' && secondChar != 'n' && secondChar != 'z' || firstChar == 'o' || firstChar == 'z' || firstChar == 'f' || firstChar == 'g' || firstChar == 'l' || firstChar == 'a' || firstChar == 'd' && (secondChar == 't' || this.isDigit(secondChar)) || firstChar == 'e' && (secondChar == 'n' || secondChar == 's' || this.isDigit(secondChar));
    }

    private int findFormatItemEnd(String line, int lineIndex) {
        char currChar;
        int lineLength = line.length();
        do {
            currChar = line.charAt(lineIndex);
        } while (++lineIndex < lineLength && currChar != ',' && currChar != ')' && currChar != '/' && currChar != ':');
        return lineIndex - 1;
    }

    private int matchVList(String line, int lineIndex) {
        int tmpLineIndex = lineIndex + 2;
        int lineLength = line.length();
        if (line.charAt(tmpLineIndex) == '\'' || line.charAt(tmpLineIndex) == '\"') {
            ++tmpLineIndex;
            while (line.charAt(tmpLineIndex) != '\'' && line.charAt(tmpLineIndex) != '\"' && tmpLineIndex < lineLength) {
                ++tmpLineIndex;
            }
        }
        if (tmpLineIndex == lineLength) {
            return lineIndex;
        }
        if (line.charAt(tmpLineIndex) == '\'' || line.charAt(tmpLineIndex) == '\"') {
            ++tmpLineIndex;
        }
        if (line.charAt(tmpLineIndex) == '(') {
            ++tmpLineIndex;
            while (tmpLineIndex < lineLength && Character.isDigit(line.charAt(tmpLineIndex))) {
                ++tmpLineIndex;
            }
            if (tmpLineIndex == lineLength) {
                return lineIndex;
            }
            if (line.charAt(tmpLineIndex) == ')') {
                return ++tmpLineIndex;
            }
            System.err.println("Error: Unable to match v-list in data-edit-desc!");
            return lineIndex;
        }
        return lineIndex;
    }

    private int getDataEditDesc(String line, int lineIndex, int lineEnd) {
        while (lineIndex < lineEnd && this.isDigit(line.charAt(lineIndex))) {
            ++lineIndex;
        }
        if (this.isValidDataEditDesc(line, lineIndex)) {
            if (Character.toLowerCase(line.charAt(lineIndex)) == 'd' && Character.toLowerCase(line.charAt(lineIndex + 1)) == 't') {
                lineIndex = this.matchVList(line, lineIndex);
            }
            return this.findFormatItemEnd(line, lineIndex);
        }
        return -1;
    }

    private boolean isDigit(char tmpChar) {
        return tmpChar >= '0' && tmpChar <= '9';
    }

    private boolean isLetter(char tmpChar) {
        return (tmpChar = Character.toLowerCase(tmpChar)) >= 'a' && tmpChar <= 'z';
    }

    private boolean isValidControlEditDesc(String line, int lineIndex) {
        char secondChar = '\u0000';
        char firstChar = Character.toLowerCase(line.charAt(lineIndex));
        if (lineIndex < line.length() - 1) {
            secondChar = Character.toLowerCase(line.charAt(lineIndex + 1));
        }
        if (firstChar == ':' || firstChar == '/' || firstChar == 'p' || firstChar == 't' || firstChar == 's' || firstChar == 'b' || firstChar == 'r' || firstChar == 'd' || firstChar == 'x') {
            if (firstChar == 's') {
                if (secondChar != 's' && secondChar != 'p' && Character.isLetterOrDigit(secondChar)) {
                    return false;
                }
                if (firstChar == 't' && !this.isDigit(secondChar) && secondChar != 'l' && secondChar != 'r') {
                    return false;
                }
                if (firstChar == 'b' && secondChar != 'n' && secondChar != 'z') {
                    return false;
                }
                if (firstChar == 'r' && secondChar != 'u' && secondChar != 'd' && secondChar != 'z' && secondChar != 'n' && secondChar != 'c' && secondChar != 'p') {
                    return false;
                }
                if (firstChar == 'd' && secondChar != 'c' && secondChar != 'p') {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private int getControlEditDesc(String line, int lineIndex, int lineLength) {
        while (lineIndex < lineLength && line.charAt(lineIndex) >= '0' && line.charAt(lineIndex) <= '9') {
            ++lineIndex;
        }
        if (this.isValidControlEditDesc(line, lineIndex)) {
            return this.findFormatItemEnd(line, lineIndex);
        }
        return -1;
    }

    private int getCharString(String line, int lineIndex, char quoteChar) {
        char nextChar;
        if ((nextChar = line.charAt(++lineIndex)) == '\'' || nextChar == '\"') {
            return this.getCharString(line, lineIndex, nextChar);
        }
        while ((nextChar = line.charAt(++lineIndex)) != '\'' && nextChar != '\"') {
        }
        return lineIndex;
    }

    private int getCharStringEditDesc(String line, int lineIndex, int lineLength) {
        int startIndex = lineIndex;
        while (lineIndex < lineLength && this.isDigit(line.charAt(lineIndex))) {
            ++lineIndex;
        }
        char quoteChar = Character.toLowerCase(line.charAt(lineIndex));
        if (quoteChar == 'h' && startIndex != lineIndex) {
            return Math.min(lineLength, lineIndex + Integer.parseInt(line.substring(startIndex, lineIndex)));
        }
        if (quoteChar != '\'' && quoteChar != '\"') {
            return -1;
        }
        lineIndex = this.getCharString(line, lineIndex, quoteChar);
        return this.findFormatItemEnd(line, lineIndex + 1);
    }

    private int parseFormatString(String line, int lineIndex, int lineNum, int charPos) {
        int descIndex = 0;
        boolean foundClosingParen = false;
        int lineLength = line.length();
        while (lineIndex < lineLength - 1 && !foundClosingParen) {
            descIndex = this.getCharStringEditDesc(line, lineIndex, lineLength);
            if (descIndex == -1) {
                descIndex = this.getDataEditDesc(line, lineIndex, lineLength);
                if (descIndex == -1) {
                    descIndex = this.getControlEditDesc(line, lineIndex, lineLength);
                    if (descIndex != -1 && (descIndex - lineIndex > 0 || line.charAt(descIndex) != '/')) {
                        this.tokens.addToken(this.tokens.createToken(304, line.substring(lineIndex, descIndex), lineNum, charPos));
                        charPos += line.substring(lineIndex, descIndex).length();
                    }
                } else {
                    this.tokens.addToken(this.tokens.createToken(373, line.substring(lineIndex, descIndex), lineNum, charPos));
                    charPos += line.substring(lineIndex, descIndex).length();
                }
            } else {
                this.tokens.addToken(this.tokens.createToken(311, line.substring(lineIndex, descIndex), lineNum, charPos));
                charPos += line.substring(lineIndex, descIndex).length();
            }
            if (descIndex != -1 || descIndex == -1 && !this.isDigit(line.charAt(lineIndex)) && line.charAt(lineIndex) != '(') {
                String termString = null;
                if (descIndex == -1) {
                    descIndex = lineIndex;
                }
                if (descIndex == line.length()) {
                    descIndex = line.length() - 1;
                }
                if (line.charAt(descIndex) == ',') {
                    termString = new String(",");
                    this.tokens.addToken(this.tokens.createToken(433, ",", lineNum, charPos));
                } else if (line.charAt(descIndex) == ')') {
                    this.tokens.addToken(this.tokens.createToken(349, ")", lineNum, charPos));
                } else {
                    termString = line.charAt(descIndex) == ':' ? new String(":") : (line.charAt(descIndex) == '/' ? new String("/") : null);
                    if (termString != null) {
                        this.tokens.addToken(this.tokens.createToken(304, termString, lineNum, charPos));
                    }
                }
                lineIndex = descIndex + 1;
            } else {
                int startIndex = lineIndex;
                while (lineIndex < lineLength && this.isDigit(line.charAt(lineIndex))) {
                    ++lineIndex;
                    ++charPos;
                }
                if (startIndex != lineIndex) {
                    this.tokens.addToken(this.tokens.createToken(359, line.substring(startIndex, lineIndex), lineNum, charPos - (lineIndex - startIndex)));
                }
                if (line.charAt(lineIndex) == '(') {
                    this.tokens.addToken(this.tokens.createToken(396, "(", lineNum, charPos));
                    descIndex = this.parseFormatString(line, ++lineIndex, lineNum, ++charPos);
                    if (descIndex == -1) {
                        System.err.println("Could not parse the format string: " + line);
                        return -1;
                    }
                    lineIndex = descIndex + 1;
                } else {
                    return -1;
                }
            }
            ++charPos;
        }
        if (lineIndex < lineLength && line.charAt(lineIndex) == ')') {
            this.tokens.addToken(this.tokens.createToken(349, ")", lineNum, charPos));
            ++lineIndex;
        }
        return lineIndex;
    }

    private int fixupFormatStmt(int lineStart, int lineEnd) {
        int lineIndex = 0;
        int i = 0;
        int lineLength = 0;
        int lineNum = 0;
        int charPos = 0;
        ArrayList<Token> origLine = new ArrayList<Token>();
        lineNum = this.tokens.getToken(lineStart).getLine();
        charPos = this.tokens.getToken(++lineStart).getCharPositionInLine();
        if (this.tokens.currLineLA(lineStart + 1) != 396) {
            return -1;
        }
        String line = this.tokens.lineToString(lineStart, lineEnd);
        origLine.addAll(this.tokens.getTokensList());
        this.tokens.clearTokensList();
        for (i = 0; i < lineStart; ++i) {
            this.tokens.addToken((Token)origLine.get(i));
        }
        lineIndex = 0;
        lineLength = line.length();
        lineIndex = this.parseFormatString(line, lineIndex, lineNum, charPos);
        this.tokens.addToken(this.tokens.createToken(297, "\n", lineNum, charPos + lineIndex));
        if (lineIndex == -1) {
            System.err.println("Error in format statement " + line + " at line " + lineNum);
            this.tokens.clearTokensList();
            for (i = 0; i < lineEnd; ++i) {
                this.tokens.addToken((Token)origLine.get(i));
            }
        }
        return lineIndex;
    }

    private boolean matchIOStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 301) {
            if (this.tokens.currLineLA(lineStart + 2) == 356) {
                return false;
            }
            identOffset = lineStart + 1;
        } else if (this.tokens.currLineLA(lineStart + 2) == 396) {
            identOffset = lineStart + 2;
            if (tokenType == 444) {
                int rparenOffset = -1;
                rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 2);
                if (rparenOffset != -1 && rparenOffset < lineEnd - 1 && this.tokens.currLineLA(rparenOffset + 1) != 297) {
                    this.tokens.addToken(lineStart, 374, "__T_INQUIRE_STMT_2__");
                    ++identOffset;
                }
            }
        } else if ((tokenType == 442 || tokenType == 382) && this.tokens.currLineLA(lineStart + 2) != 356) {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (tokenType == 425) {
                this.fixupFormatStmt(lineStart, lineEnd);
            }
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 359) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchProgramStmt(int lineStart, int lineEnd) {
        if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2))) {
            this.tokens.getToken(lineStart + 1).setType(291);
        }
        return true;
    }

    private boolean labelsMatch(String label1, String label2) {
        return Integer.parseInt(label1) == Integer.parseInt(label2);
    }

    private void fixupLabeledEndDo(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(1) != 359) {
            return;
        }
        if (!this.doLabels.empty()) {
            String doLabelString = this.doLabels.peek().getText();
            Token firstToken = this.tokens.getToken(0);
            int endType = this.tokens.currLineLA(lineStart + 1);
            String labeledDoText = new String("LABELED_DO_TERM");
            if (this.labelsMatch(doLabelString, firstToken.getText())) {
                this.tokens.addToken(1, 408, labeledDoText);
                this.doLabels.pop();
                while (!this.doLabels.empty() && this.labelsMatch(this.doLabels.peek().getText(), firstToken.getText())) {
                    if (!(this.tokens.appendToken(359, new String(firstToken.getText())) && this.tokens.appendToken(408, labeledDoText) && this.tokens.appendToken(483, new String("CONTINUE")) && this.tokens.appendToken(297, null))) {
                        System.err.println("Couldn't add tokens!");
                        break;
                    }
                    this.doLabels.pop();
                }
            }
        }
    }

    private boolean matchActionStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 298) {
            if (this.tokens.currLineLA(lineStart + 2) != 369) {
                return false;
            }
            identOffset = lineStart + 2;
        } else if (tokenType == 402) {
            int colonOffset = -1;
            colonOffset = this.tokens.findToken(lineStart + 1, 360);
            if (colonOffset != -1) {
                this.tokens.addToken(lineStart, 302, "__T_ALLOCATE_STMT_1__");
                ++lineStart;
                identOffset = colonOffset + 2;
            } else {
                identOffset = lineStart + 1;
            }
        } else {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 359 && tokenType != 323) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchSingleTokenStmt(int lineStart, int lineEnd) {
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 459 || firstToken == 405 || firstToken == 429 || firstToken == 331 || firstToken == 467 || firstToken == 439 || firstToken == 343 || firstToken == 358 || firstToken == 341 || firstToken == 318 || firstToken == 285 && this.tokens.currLineLA(lineStart + 2) != 426 || firstToken == 292 || firstToken == 407 || firstToken == 346 || firstToken == 329) {
            if (firstToken == 343 || firstToken == 318 && this.tokens.currLineLA(lineStart + 2) == 426) {
                this.convertToIdents(lineStart + 2, lineEnd);
            } else if (firstToken == 292) {
                int identOffset = this.matchGenericSpec(lineStart + 1, lineEnd);
                if (identOffset != -1) {
                    this.convertToIdents(identOffset, lineEnd);
                }
            } else if (firstToken == 407) {
                if (lineStart + 3 < lineEnd) {
                    if (this.tokens.currLineLA(lineStart + 3) == 396) {
                        int resultLA = this.matchClosingParen(lineStart + 3, lineStart + 3);
                        this.convertToIdents(lineStart + 1, resultLA - 1);
                        if (this.tokens.currLineLA(resultLA) == 434) {
                            this.convertToIdents(resultLA, lineEnd);
                        }
                    }
                } else {
                    this.convertToIdents(lineStart + 1, lineEnd);
                }
            } else {
                this.convertToIdents(lineStart + 1, lineEnd);
            }
            if (firstToken == 331) {
                this.tokens.addToken(lineStart, 466, "__T_WHERE_CONSTRUCT_STMT__");
            } else if (firstToken == 439) {
                this.tokens.addToken(lineStart, 384, "__T_FORALL_CONSTRUCT_STMT__");
            }
            return true;
        }
        return false;
    }

    private boolean matchDoStmt(int lineStart, int lineEnd) {
        int whileOffset = -1;
        if (this.tokens.currLineLA(lineStart + 2) == 297) {
            return true;
        }
        if (this.tokens.currLineLA(lineStart + 2) == 359) {
            this.doLabels.push((Token)new FortranToken(this.tokens.getToken(lineStart + 1)));
        }
        if (this.tokens.currLineLA(lineStart + 3) == 297) {
            return true;
        }
        whileOffset = this.tokens.findToken(lineStart + 1, 443);
        int equalsOffset = this.salesScanForToken(lineStart + 1, 356);
        int identOffset = equalsOffset != -1 ? lineStart + 1 : whileOffset + 1;
        this.convertToIdents(identOffset, lineEnd);
        return true;
    }

    private boolean matchOneLineStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int rparenOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 331 || tokenType == 320 || tokenType == 439) {
            if (this.tokens.currLineLA(lineStart + 2) == 396) {
                identOffset = lineStart + 2;
                rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
                if (rparenOffset == -1) {
                    rparenOffset = lineEnd;
                }
                this.convertToIdents(identOffset, rparenOffset);
                if (!this.matchLine(rparenOffset, lineEnd)) {
                    this.matchAssignStmt(rparenOffset, lineEnd);
                }
                if (tokenType == 331) {
                    this.tokens.addToken(lineStart, 388, "__T_WHERE_STMT__");
                } else if (tokenType == 320) {
                    this.tokens.addToken(lineStart, 394, "__T_IF_STMT__");
                } else {
                    this.tokens.addToken(lineStart, 446, "__T_FORALL_STMT__");
                }
                if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 359) {
                    this.fixupLabeledEndDo(lineStart, lineEnd);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private int matchDataRef(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 291 || FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 1))) {
            if (this.tokens.currLineLA(lineStart + 2) == 396) {
                int tmpLineStart = this.matchClosingParen(lineStart, lineStart + 2);
                lineStart = tmpLineStart - 1;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 300) {
                return this.matchDataRef(lineStart + 2, lineEnd);
            }
            return lineStart;
        }
        return lineStart;
    }

    private boolean matchAssignStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int assignType = 0;
        if (lineEnd < lineStart + 3) {
            return false;
        }
        int newLineStart = this.matchDataRef(lineStart, lineEnd);
        if (this.tokens.currLineLA(newLineStart + 2) == 356 || this.tokens.currLineLA(newLineStart + 2) == 478) {
            identOffset = lineStart;
            assignType = this.tokens.currLineLA(newLineStart + 2);
        } else if (this.tokens.currLineLA(newLineStart + 2) == 396) {
            int rparenOffset = -1;
            rparenOffset = this.matchClosingParen(newLineStart, newLineStart + 2);
            if (this.tokens.currLineLA(rparenOffset + 1) == 356 || this.tokens.currLineLA(rparenOffset + 1) == 478) {
                identOffset = lineStart;
                assignType = this.tokens.currLineLA(rparenOffset + 1);
            }
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (assignType == 356) {
                this.tokens.addToken(lineStart, 352, "__T_ASSIGNMENT_STMT__");
            } else if (assignType == 478) {
                this.tokens.addToken(lineStart, 472, "__T_PTR_ASSIGNMENT_STMT__");
            }
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 359) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private int matchGenericSpec(int lineStart, int lineEnd) {
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 368 || firstToken == 486) {
            return lineStart + 1;
        }
        if (firstToken == 401 || firstToken == 326) {
            if (this.tokens.currLineLA(lineStart + 2) != 396) {
                return -1;
            }
            int rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            return rparenOffset + 1;
        }
        return lineStart;
    }

    private boolean matchGenericBinding(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 335) {
            int colonOffset = this.salesScanForToken(lineStart + 1, 360);
            if (colonOffset == -1) {
                return false;
            }
            int nextToken = this.tokens.currLineLA(colonOffset + 2);
            if (nextToken == 368 || nextToken == 486) {
                this.convertToIdents(colonOffset + 2, lineEnd);
            } else if (nextToken == 401 || nextToken == 326) {
                int nextTokenLA = colonOffset + 2;
                if (this.tokens.currLineLA(nextTokenLA + 1) != 396) {
                    return false;
                }
                int rparenOffset = this.matchClosingParen(lineStart, nextTokenLA + 1);
                this.convertToIdents(rparenOffset + 1, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchLine(int lineStart, int lineEnd) {
        if (this.matchDataDecl(lineStart, lineEnd)) {
            return true;
        }
        if (this.matchDerivedTypeStmt(lineStart, lineEnd)) {
            return true;
        }
        switch (this.tokens.currLineLA(lineStart + 1)) {
            case 303: 
            case 336: 
            case 378: 
            case 415: {
                return this.matchSub(lineStart, lineEnd);
            }
            case 289: 
            case 313: 
            case 314: 
            case 324: 
            case 332: 
            case 351: 
            case 355: 
            case 370: 
            case 386: 
            case 391: 
            case 414: 
            case 423: 
            case 435: 
            case 463: 
            case 464: 
            case 465: 
            case 479: {
                return this.matchEnd(lineStart, lineEnd);
            }
            case 411: {
                if (this.matchProcStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchProcDeclStmt(lineStart, lineEnd);
            }
            case 400: {
                if (this.matchProcStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchModule(lineStart, lineEnd);
            }
            case 281: 
            case 339: {
                return this.matchBlockData(lineStart, lineEnd);
            }
            case 347: {
                return this.matchUseStmt(lineStart, lineEnd);
            }
            case 390: {
                return this.matchProgramStmt(lineStart, lineEnd);
            }
            case 293: 
            case 296: 
            case 298: 
            case 309: 
            case 323: 
            case 366: 
            case 381: 
            case 392: 
            case 402: 
            case 410: 
            case 475: 
            case 483: 
            case 487: {
                return this.matchActionStmt(lineStart, lineEnd);
            }
            case 320: {
                if (this.matchIfConstStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchOneLineStmt(lineStart, lineEnd);
            }
            case 393: {
                if (this.matchElseStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchSingleTokenStmt(lineStart, lineEnd);
            }
            case 387: {
                return this.matchDoStmt(lineStart, lineEnd);
            }
            case 280: 
            case 301: 
            case 326: 
            case 364: 
            case 382: 
            case 401: 
            case 425: 
            case 442: 
            case 444: {
                return this.matchIOStmt(lineStart, lineEnd);
            }
            case 305: 
            case 312: 
            case 316: 
            case 319: 
            case 322: 
            case 350: 
            case 385: 
            case 389: 
            case 398: 
            case 418: 
            case 432: 
            case 437: 
            case 440: 
            case 449: 
            case 450: 
            case 458: 
            case 462: 
            case 469: 
            case 470: {
                return this.matchAttrStmt(lineStart, lineEnd);
            }
        }
        return this.matchSingleTokenStmt(lineStart, lineEnd);
    }

    private void fixupFixedFormatLine(int lineStart, int lineEnd, boolean startsWithKeyword) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        if (startsWithKeyword) {
            Token token;
            do {
                System.out.println("fixed-format line must start with keyword");
                this.tokens.printPackedList();
                buffer = buffer.append(this.tokens.getToken(lineStart + i).getText());
                TokenStream ts = APTTokenStreamBuilder.buildTokenStream((String)buffer.toString().toUpperCase(), (String)"Fortran Language");
                ts = new APTCommentsFilter(ts);
                ts = APTLanguageSupport.getInstance().getFilter("Fortran Language").getFilteredStream(ts);
                FortranParserEx.MyTokenSource myLexer = new FortranParserEx.MyTokenSource(ts);
                token = myLexer.nextToken();
            } while (lineStart + ++i < lineEnd && !FortranLexer.isKeyword(token.getType()));
            if (lineStart + i == lineEnd) {
                System.err.println("Error: Expected keyword on line: " + token.getLine());
            } else {
                int j = 0;
                for (j = lineStart; j < lineStart + i; ++j) {
                    Token tmpToken = this.tokens.getToken(j);
                    tmpToken.setChannel(99);
                    this.tokens.set(j, tmpToken);
                }
                this.tokens.add(j, token);
            }
        } else {
            System.out.println("fixed-format line must NOT start with keyword");
        }
    }

    private int scanForRealConsts(int lineStart, int lineEnd) {
        for (int i = lineStart; i < lineEnd; ++i) {
            if (this.tokens.currLineLA(i + 1) == 422) {
                this.tokens.getToken(i).setType(420);
                continue;
            }
            if (this.tokens.currLineLA(i + 1) != 359 || i + 2 >= lineEnd || this.tokens.currLineLA(i + 2) != 406 && this.tokens.currLineLA(i + 2) != 422) continue;
            StringBuffer newTokenText = new StringBuffer();
            int line = this.tokens.getToken(i).getLine();
            int col = this.tokens.getToken(i).getCharPositionInLine();
            newTokenText.append(this.tokens.getToken(i).getText());
            newTokenText.append(this.tokens.getToken(i + 1).getText());
            if (this.sourceForm != 2 && col + this.tokens.getToken(i).getText().length() != this.tokens.getToken(i + 1).getCharPositionInLine()) {
                System.err.println("Error: Whitespace within real constant at {line:col}: " + line + ":" + (col + 1));
            }
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.add(i, this.tokens.createToken(420, newTokenText.toString(), line, col));
            --lineEnd;
        }
        return lineEnd;
    }

    /*
     * WARNING - void declaration
     */
    private int scanForRelationalOp(int lineStart, int lineEnd) {
        for (int i = lineStart; i < lineEnd; ++i) {
            void var4_4;
            int type;
            if (i + 2 >= lineEnd) {
                return lineEnd;
            }
            if (this.tokens.currLineLA(i + 1) != 406 || this.tokens.currLineLA(i + 2) != 291 || this.tokens.currLineLA(i + 3) != 406) continue;
            int line = this.tokens.getToken(i).getLine();
            int col = this.tokens.getToken(i).getCharPositionInLine();
            String text = this.tokens.getToken(i + 1).getText();
            if (text.compareToIgnoreCase("EQ") == 0) {
                type = 371;
            } else if (text.compareToIgnoreCase("NE") == 0) {
                type = 417;
            } else if (text.compareToIgnoreCase("GT") == 0) {
                type = 290;
            } else if (text.compareToIgnoreCase("GE") == 0) {
                type = 282;
            } else if (text.compareToIgnoreCase("LT") == 0) {
                type = 476;
            } else {
                if (text.compareToIgnoreCase("LE") != 0) continue;
                type = 481;
            }
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.add(i, this.tokens.createToken((int)var4_4, "." + text + ".", line, col));
            lineEnd -= 2;
        }
        return lineEnd;
    }

    public void performPrepass() {
        int tokensStart;
        int commaIndex = -1;
        int equalsIndex = -1;
        int lineLength = 0;
        int newLineLength = 0;
        Token eof = null;
        if (this.sourceForm == 2) {
            tokensStart = this.tokens.mark();
            this.tokens.fixupFixedFormat();
            this.tokens.rewind(tokensStart);
        }
        if ((tokensStart = this.tokens.mark()) != -1) {
            this.tokens.seek(-1);
            tokensStart = -1;
        }
        while (this.tokens.LA(1) != -1) {
            commaIndex = -1;
            equalsIndex = -1;
            int lineStart = 0;
            int rawLineStart = this.tokens.mark();
            this.tokens.setCurrLine(rawLineStart);
            lineLength = this.tokens.getCurrLineLength();
            int rawLineEnd = this.tokens.findTokenInSuper(rawLineStart, 297);
            if (rawLineEnd == -1) {
                rawLineEnd = this.tokens.getRawLineLength();
            }
            rawLineEnd += rawLineStart;
            if (this.tokens.currLineLA(1) == 295) {
                ++lineStart;
            }
            if (this.matchLabel(lineStart, lineLength)) {
                ++lineStart;
            }
            if (this.matchIdentColon(lineStart, lineLength)) {
                lineStart += 2;
            }
            if ((newLineLength = this.scanForRealConsts(lineStart, lineLength)) != lineLength) {
                lineLength = newLineLength;
            }
            if (this.sourceForm == 2 && (newLineLength = this.scanForRelationalOp(lineStart, lineLength)) != lineLength) {
                lineLength = newLineLength;
            }
            if ((commaIndex = this.salesScanForToken(lineStart, 433)) != -1) {
                this.matchLine(lineStart, lineLength);
            } else {
                equalsIndex = this.salesScanForToken(lineStart, 356);
                if (equalsIndex == -1) {
                    equalsIndex = this.salesScanForToken(lineStart, 478);
                }
                if (equalsIndex != -1) {
                    if (!(this.matchOneLineStmt(lineStart, lineLength) || this.matchProcStmt(lineStart, lineLength) || this.matchAssignStmt(lineStart, lineLength) || this.matchDataDecl(lineStart, lineLength) || this.matchGenericBinding(lineStart, lineLength))) {
                        System.err.println("Couldn't match line!");
                    }
                } else if (!this.matchLine(lineStart, lineLength)) {
                    this.matchOneLineStmt(lineStart, lineLength);
                }
            }
            for (int i = rawLineStart; i < rawLineEnd; ++i) {
                this.tokens.consume();
            }
            this.tokens.finalizeLine();
        }
        eof = this.tokens.LT(1);
        eof.setText("EOF");
        this.tokens.addTokenToNewList(eof);
        this.tokens.rewind(tokensStart);
    }

    private static class FortranLexer {
        public static final int EOF = -1;
        public static final int NULL_TREE_LOOKAHEAD = 3;
        public static final int ELLIPSIS = 4;
        public static final int DOT = 5;
        public static final int ASSIGNEQUAL = 6;
        public static final int COLON = 7;
        public static final int COMMA = 8;
        public static final int QUESTIONMARK = 9;
        public static final int SEMICOLON = 10;
        public static final int POINTERTO = 11;
        public static final int LPAREN = 12;
        public static final int RPAREN = 13;
        public static final int LSQUARE = 14;
        public static final int RSQUARE = 15;
        public static final int LCURLY = 16;
        public static final int RCURLY = 17;
        public static final int EQUAL = 18;
        public static final int NOTEQUAL = 19;
        public static final int LESSTHANOREQUALTO = 20;
        public static final int LESSTHAN = 21;
        public static final int GREATERTHANOREQUALTO = 22;
        public static final int GREATERTHAN = 23;
        public static final int DIVIDE = 24;
        public static final int DIVIDEEQUAL = 25;
        public static final int PLUS = 26;
        public static final int PLUSEQUAL = 27;
        public static final int PLUSPLUS = 28;
        public static final int MINUS = 29;
        public static final int MINUSEQUAL = 30;
        public static final int MINUSMINUS = 31;
        public static final int STAR = 32;
        public static final int TIMESEQUAL = 33;
        public static final int MOD = 34;
        public static final int MODEQUAL = 35;
        public static final int SHIFTRIGHT = 36;
        public static final int SHIFTRIGHTEQUAL = 37;
        public static final int SHIFTLEFT = 38;
        public static final int SHIFTLEFTEQUAL = 39;
        public static final int AND = 40;
        public static final int NOT = 41;
        public static final int OR = 42;
        public static final int AMPERSAND = 43;
        public static final int BITWISEANDEQUAL = 44;
        public static final int TILDE = 45;
        public static final int BITWISEOR = 46;
        public static final int BITWISEOREQUAL = 47;
        public static final int BITWISEXOR = 48;
        public static final int BITWISEXOREQUAL = 49;
        public static final int POINTERTOMBR = 50;
        public static final int DOTMBR = 51;
        public static final int SCOPE = 52;
        public static final int AT = 53;
        public static final int DOLLAR = 54;
        public static final int BACK_SLASH = 55;
        public static final int DEFINED = 56;
        public static final int DBL_SHARP = 57;
        public static final int SHARP = 58;
        public static final int FUN_LIKE_MACRO_LPAREN = 59;
        public static final int LAST_CONST_TEXT_TOKEN = 62;
        public static final int FLOATONE = 63;
        public static final int FLOATTWO = 64;
        public static final int HEXADECIMALINT = 65;
        public static final int OCTALINT = 66;
        public static final int DECIMALINT = 67;
        public static final int Whitespace = 68;
        public static final int EndOfLine = 69;
        public static final int Skip = 70;
        public static final int PreProcComment = 71;
        public static final int PPLiterals = 72;
        public static final int Space = 73;
        public static final int PreProcBlockComment = 74;
        public static final int PreProcLineComment = 75;
        public static final int Comment = 76;
        public static final int CPPComment = 77;
        public static final int CHAR_LITERAL = 78;
        public static final int STRING_LITERAL = 79;
        public static final int InterStringWhitespace = 80;
        public static final int StringPart = 81;
        public static final int Escape = 82;
        public static final int Digit = 83;
        public static final int Decimal = 84;
        public static final int LongSuffix = 85;
        public static final int UnsignedSuffix = 86;
        public static final int FloatSuffix = 87;
        public static final int Exponent = 88;
        public static final int Vocabulary = 89;
        public static final int NUMBER = 90;
        public static final int IDENT = 91;
        public static final int BINARYINT = 92;
        public static final int INCLUDE_STRING = 93;
        public static final int SYS_INCLUDE_STRING = 94;
        public static final int END_PREPROC_DIRECTIVE = 61;
        public static final int INCLUDE = 95;
        public static final int INCLUDE_NEXT = 96;
        public static final int DEFINE = 97;
        public static final int UNDEF = 98;
        public static final int IFDEF = 99;
        public static final int IFNDEF = 100;
        public static final int IF = 101;
        public static final int ELIF = 102;
        public static final int ELSE = 103;
        public static final int ENDIF = 104;
        public static final int PRAGMA = 105;
        public static final int LINE = 106;
        public static final int ERROR = 107;
        public static final int PREPROC_DIRECTIVE = 108;
        public static final int LITERAL_OPERATOR = 110;
        public static final int LITERAL_alignof = 111;
        public static final int LITERAL___alignof__ = 113;
        public static final int LITERAL_typeof = 114;
        public static final int LITERAL___typeof__ = 115;
        public static final int LITERAL___typeof = 116;
        public static final int LITERAL_template = 117;
        public static final int LITERAL_typedef = 118;
        public static final int LITERAL_enum = 119;
        public static final int LITERAL_namespace = 120;
        public static final int LITERAL_extern = 121;
        public static final int LITERAL_inline = 122;
        public static final int LITERAL__inline = 123;
        public static final int LITERAL___inline__ = 124;
        public static final int LITERAL___inline = 125;
        public static final int LITERAL_virtual = 126;
        public static final int LITERAL_explicit = 127;
        public static final int LITERAL_friend = 128;
        public static final int LITERAL__stdcall = 129;
        public static final int LITERAL___stdcall = 130;
        public static final int LITERAL_typename = 131;
        public static final int LITERAL_auto = 132;
        public static final int LITERAL_register = 133;
        public static final int LITERAL_static = 134;
        public static final int LITERAL_mutable = 135;
        public static final int LITERAL_const = 136;
        public static final int LITERAL___const__ = 137;
        public static final int LITERAL___const = 138;
        public static final int LITERAL_const_cast = 139;
        public static final int LITERAL_volatile = 140;
        public static final int LITERAL___volatile__ = 141;
        public static final int LITERAL___volatile = 142;
        public static final int LITERAL_char = 143;
        public static final int LITERAL_wchar_t = 144;
        public static final int LITERAL_bool = 145;
        public static final int LITERAL_short = 146;
        public static final int LITERAL_int = 147;
        public static final int LITERAL_long = 148;
        public static final int LITERAL_signed = 149;
        public static final int LITERAL___signed__ = 150;
        public static final int LITERAL___signed = 151;
        public static final int LITERAL_unsigned = 152;
        public static final int LITERAL___unsigned__ = 153;
        public static final int LITERAL_float = 154;
        public static final int LITERAL_double = 155;
        public static final int LITERAL_void = 156;
        public static final int LITERAL__declspec = 157;
        public static final int LITERAL___declspec = 158;
        public static final int LITERAL_class = 159;
        public static final int LITERAL_struct = 160;
        public static final int LITERAL_union = 161;
        public static final int LITERAL_this = 162;
        public static final int LITERAL_true = 163;
        public static final int LITERAL_false = 164;
        public static final int LITERAL_public = 165;
        public static final int LITERAL_protected = 166;
        public static final int LITERAL_private = 167;
        public static final int LITERAL_throw = 168;
        public static final int LITERAL_case = 169;
        public static final int LITERAL_default = 170;
        public static final int LITERAL_if = 171;
        public static final int LITERAL_else = 172;
        public static final int LITERAL_switch = 173;
        public static final int LITERAL_while = 174;
        public static final int LITERAL_do = 175;
        public static final int LITERAL_for = 176;
        public static final int LITERAL_goto = 177;
        public static final int LITERAL_continue = 178;
        public static final int LITERAL_break = 179;
        public static final int LITERAL_return = 180;
        public static final int LITERAL_try = 181;
        public static final int LITERAL_catch = 182;
        public static final int LITERAL_using = 183;
        public static final int LITERAL_export = 184;
        public static final int LITERAL_asm = 185;
        public static final int LITERAL__asm = 186;
        public static final int LITERAL___asm__ = 187;
        public static final int LITERAL___asm = 188;
        public static final int LITERAL_sizeof = 190;
        public static final int LITERAL_dynamic_cast = 191;
        public static final int LITERAL_static_cast = 192;
        public static final int LITERAL_reinterpret_cast = 193;
        public static final int LITERAL_new = 194;
        public static final int LITERAL__cdecl = 195;
        public static final int LITERAL___cdecl = 196;
        public static final int LITERAL__near = 197;
        public static final int LITERAL___near = 198;
        public static final int LITERAL__far = 199;
        public static final int LITERAL___far = 200;
        public static final int LITERAL___interrupt = 201;
        public static final int LITERAL_pascal = 202;
        public static final int LITERAL__pascal = 203;
        public static final int LITERAL___pascal = 204;
        public static final int LITERAL_delete = 205;
        public static final int LITERAL__int64 = 206;
        public static final int LITERAL___int64 = 207;
        public static final int LITERAL___w64 = 208;
        public static final int LITERAL___extension__ = 209;
        public static final int LITERAL___attribute__ = 210;
        public static final int LITERAL_restrict = 211;
        public static final int LITERAL___restrict = 212;
        public static final int LITERAL___complex__ = 213;
        public static final int LITERAL___imag = 214;
        public static final int LITERAL___real = 215;
        public static final int LITERAL___global = 216;
        public static final int LITERAL__Complex = 218;
        public static final int LITERAL___thread = 219;
        public static final int LITERAL___attribute = 220;
        public static final int LITERAL__Imaginary = 221;
        public static final int T_CLOSE = 280;
        public static final int T_BLOCK = 281;
        public static final int T_GE = 282;
        public static final int T_CONTAINS = 283;
        public static final int T_ABSTRACT = 284;
        public static final int T_CLASS = 285;
        public static final int T_NOPASS = 286;
        public static final int T_UNFORMATTED = 287;
        public static final int T_LESSTHAN = 288;
        public static final int T_ENDSUBROUTINE = 289;
        public static final int T_GT = 290;
        public static final int T_IDENT = 291;
        public static final int T_INTERFACE = 292;
        public static final int T_RETURN = 293;
        public static final int T_XYZ = 294;
        public static final int T_EOF = 295;
        public static final int T_CALL = 296;
        public static final int T_EOS = 297;
        public static final int T_GO = 298;
        public static final int T_AND = 299;
        public static final int T_PERCENT = 300;
        public static final int T_PRINT = 301;
        public static final int T_ALLOCATE_STMT_1 = 302;
        public static final int T_SUBROUTINE = 303;
        public static final int T_CONTROL_EDIT_DESC = 304;
        public static final int T_ENUMERATOR = 305;
        public static final int Alphanumeric_Character = 306;
        public static final int T_DEFINED_OP = 307;
        public static final int T_KIND = 308;
        public static final int T_STOP = 309;
        public static final int T_GREATERTHAN_EQ = 310;
        public static final int T_CHAR_STRING_EDIT_DESC = 311;
        public static final int T_ALLOCATABLE = 312;
        public static final int T_ENDINTERFACE = 313;
        public static final int T_END = 314;
        public static final int T_ASTERISK = 315;
        public static final int T_PRIVATE = 316;
        public static final int T_DOUBLEPRECISION = 317;
        public static final int T_CASE = 318;
        public static final int T_IMPLICIT = 319;
        public static final int T_IF = 320;
        public static final int T_THEN = 321;
        public static final int T_DIMENSION = 322;
        public static final int T_GOTO = 323;
        public static final int T_ENDMODULE = 324;
        public static final int T_IN = 325;
        public static final int T_WRITE = 326;
        public static final int T_FORMATTED = 327;
        public static final int WS = 328;
        public static final int T_DATA = 329;
        public static final int T_FALSE = 330;
        public static final int T_WHERE = 331;
        public static final int T_ENDIF = 332;
        public static final int T_SLASH = 333;
        public static final int SQ_Rep_Char = 334;
        public static final int T_GENERIC = 335;
        public static final int T_RECURSIVE = 336;
        public static final int DQ_Rep_Char = 337;
        public static final int T_ELSEIF = 338;
        public static final int T_BLOCKDATA = 339;
        public static final int OCTAL_CONSTANT = 340;
        public static final int T_SELECTTYPE = 341;
        public static final int T_MINUS = 342;
        public static final int T_SELECT = 343;
        public static final int T_FINAL = 344;
        public static final int T_UNDERSCORE = 345;
        public static final int T_IMPORT = 346;
        public static final int T_USE = 347;
        public static final int T_FILE = 348;
        public static final int T_RPAREN = 349;
        public static final int T_INTENT = 350;
        public static final int T_ENDBLOCK = 351;
        public static final int T_ASSIGNMENT_STMT = 352;
        public static final int T_PAUSE = 353;
        public static final int T_BACKSPACE = 354;
        public static final int T_ENDFILE = 355;
        public static final int T_EQUALS = 356;
        public static final int T_NON_INTRINSIC = 357;
        public static final int T_SELECTCASE = 358;
        public static final int T_DIGIT_STRING = 359;
        public static final int T_COLON_COLON = 360;
        public static final int T_NON_OVERRIDABLE = 361;
        public static final int Special_Character = 362;
        public static final int T_INCLUDE = 363;
        public static final int T_OPEN = 364;
        public static final int T_POWER = 365;
        public static final int T_ASSOCIATE = 366;
        public static final int T_CHAR_CONSTANT = 367;
        public static final int T_OPERATOR = 368;
        public static final int T_TO = 369;
        public static final int T_ENDASSOCIATE = 370;
        public static final int T_EQ = 371;
        public static final int T_GREATERTHAN = 372;
        public static final int T_DATA_EDIT_DESC = 373;
        public static final int T_INQUIRE_STMT_2 = 374;
        public static final int T_EQV = 375;
        public static final int HEX_CONSTANT = 376;
        public static final int Digit_String = 377;
        public static final int T_ELEMENTAL = 378;
        public static final int T_CHARACTER = 379;
        public static final int PREPROCESS_LINE = 380;
        public static final int T_NULLIFY = 381;
        public static final int T_REWIND = 382;
        public static final int T_ARITHMETIC_IF_STMT = 383;
        public static final int T_FORALL_CONSTRUCT_STMT = 384;
        public static final int T_BIND = 385;
        public static final int T_ENDFORALL = 386;
        public static final int T_DO = 387;
        public static final int T_WHERE_STMT = 388;
        public static final int T_POINTER = 389;
        public static final int T_PROGRAM = 390;
        public static final int T_ENDTYPE = 391;
        public static final int T_WAIT = 392;
        public static final int T_ELSE = 393;
        public static final int T_IF_STMT = 394;
        public static final int T_RBRACKET = 395;
        public static final int T_LPAREN = 396;
        public static final int T_EXTENDS = 397;
        public static final int T_OPTIONAL = 398;
        public static final int T_DOUBLE = 399;
        public static final int T_MODULE = 400;
        public static final int T_READ = 401;
        public static final int T_ALLOCATE = 402;
        public static final int T_INTEGER = 403;
        public static final int T_OR = 404;
        public static final int T_EQUIVALENCE = 405;
        public static final int T_PERIOD = 406;
        public static final int T_ENTRY = 407;
        public static final int T_LABEL_DO_TERMINAL = 408;
        public static final int T_REAL = 409;
        public static final int T_CYCLE = 410;
        public static final int T_PROCEDURE = 411;
        public static final int T_EQ_EQ = 412;
        public static final int T_SLASH_EQ = 413;
        public static final int T_ENDSELECT = 414;
        public static final int T_PURE = 415;
        public static final int T_TRUE = 416;
        public static final int T_NE = 417;
        public static final int T_INTRINSIC = 418;
        public static final int T_PASS = 419;
        public static final int T_REAL_CONSTANT = 420;
        public static final int LINE_COMMENT = 421;
        public static final int T_PERIOD_EXPONENT = 422;
        public static final int T_ENDWHERE = 423;
        public static final int MISC_CHAR = 424;
        public static final int T_FORMAT = 425;
        public static final int T_DEFAULT = 426;
        public static final int T_SLASH_SLASH = 427;
        public static final int T_NONE = 428;
        public static final int T_NAMELIST = 429;
        public static final int T_SEQUENCE = 430;
        public static final int T_PRECISION = 431;
        public static final int T_ASYNCHRONOUS = 432;
        public static final int T_COMMA = 433;
        public static final int T_RESULT = 434;
        public static final int T_ENDBLOCKDATA = 435;
        public static final int T_LOGICAL = 436;
        public static final int T_VALUE = 437;
        public static final int Letter = 438;
        public static final int T_FORALL = 439;
        public static final int T_SAVE = 440;
        public static final int T_HOLLERITH = 441;
        public static final int T_FLUSH = 442;
        public static final int T_WHILE = 443;
        public static final int T_INQUIRE = 444;
        public static final int T_DEFERRED = 445;
        public static final int T_FORALL_STMT = 446;
        public static final int T_ASSIGN = 447;
        public static final int T_LBRACKET = 448;
        public static final int T_EXTERNAL = 449;
        public static final int T_VOLATILE = 450;
        public static final int T_OUT = 451;
        public static final int CONTINUE_CHAR = 452;
        public static final int T_COLON = 453;
        public static final int T_COMPLEX = 454;
        public static final int T_PLUS = 455;
        public static final int T_STMT_FUNCTION = 456;
        public static final int T_ONLY = 457;
        public static final int T_PROTECTED = 458;
        public static final int T_COMMON = 459;
        public static final int T_INOUT = 460;
        public static final int T_NEQV = 461;
        public static final int T_PUBLIC = 462;
        public static final int T_ENDDO = 463;
        public static final int T_ENDPROGRAM = 464;
        public static final int T_ENDFUNCTION = 465;
        public static final int T_WHERE_CONSTRUCT_STMT = 466;
        public static final int T_ELSEWHERE = 467;
        public static final int T_ENUM = 468;
        public static final int T_PARAMETER = 469;
        public static final int T_TARGET = 470;
        public static final int T_DOUBLECOMPLEX = 471;
        public static final int T_PTR_ASSIGNMENT_STMT = 472;
        public static final int T_TYPE = 473;
        public static final int T_LESSTHAN_EQ = 474;
        public static final int T_DEALLOCATE = 475;
        public static final int T_LT = 476;
        public static final int T_FUNCTION = 477;
        public static final int T_EQ_GT = 478;
        public static final int T_ENDENUM = 479;
        public static final int BINARY_CONSTANT = 480;
        public static final int T_LE = 481;
        public static final int T_LEN = 482;
        public static final int T_CONTINUE = 483;
        public static final int T_NOT = 484;
        public static final int Rep_Char = 485;
        public static final int T_ASSIGNMENT = 486;
        public static final int T_EXIT = 487;
        public static final int FORTRAN_COMMENT = 488;
        public static final int FIRST_ASSIGN = 489;
        public static final int FIRST_DIVIDE = 490;
        public static final int FIRST_STAR = 491;
        public static final int FIRST_MOD = 492;
        public static final int FIRST_NOT = 493;
        public static final int FIRST_AMPERSAND = 494;
        public static final int COMMENT = 495;
        public static final int CPP_COMMENT = 496;
        public static final int FIRST_OR = 497;
        public static final int FIRST_BITWISEXOR = 498;
        public static final int FIRST_COLON = 499;
        public static final int FIRST_LESS = 500;
        public static final int FIRST_GREATER = 501;
        public static final int FIRST_MINUS = 502;
        public static final int FIRST_PLUS = 503;
        public static final int FIRST_QUOTATION = 504;
        public static final int H_char_sequence = 505;
        public static final int Q_char_sequence = 506;
        public static final int DirectiveBody = 507;
        public static final int CHAR_LITERAL_BODY = 508;
        public static final int STRING_LITERAL_BODY = 509;
        public static final int ID_LIKE = 513;
        public static final int ID_DEFINED = 514;
        public static final int Identifier = 515;
        public static final int PostPPKwdChar = 516;
        public static final int PostInclChar = 517;
        public static final int PostIfChar = 518;
        public static final int LAST_LEXER_FAKE_RULE = 519;

        private FortranLexer() {
        }

        public static boolean isKeyword(Token tmpToken) {
            return FortranLexer.isKeyword(tmpToken.getType());
        }

        public static boolean isKeyword(int tokenType) {
            switch (tokenType) {
                case 280: 
                case 281: 
                case 283: 
                case 284: 
                case 285: 
                case 286: 
                case 287: 
                case 289: 
                case 292: 
                case 293: 
                case 296: 
                case 298: 
                case 301: 
                case 303: 
                case 305: 
                case 308: 
                case 309: 
                case 312: 
                case 313: 
                case 314: 
                case 316: 
                case 317: 
                case 318: 
                case 319: 
                case 320: 
                case 321: 
                case 322: 
                case 323: 
                case 324: 
                case 325: 
                case 326: 
                case 327: 
                case 329: 
                case 331: 
                case 332: 
                case 335: 
                case 336: 
                case 338: 
                case 339: 
                case 341: 
                case 343: 
                case 344: 
                case 346: 
                case 347: 
                case 348: 
                case 350: 
                case 351: 
                case 353: 
                case 354: 
                case 355: 
                case 357: 
                case 358: 
                case 361: 
                case 364: 
                case 366: 
                case 368: 
                case 369: 
                case 370: 
                case 378: 
                case 379: 
                case 381: 
                case 382: 
                case 386: 
                case 387: 
                case 389: 
                case 390: 
                case 391: 
                case 392: 
                case 393: 
                case 397: 
                case 398: 
                case 399: 
                case 400: 
                case 401: 
                case 402: 
                case 403: 
                case 405: 
                case 407: 
                case 409: 
                case 410: 
                case 411: 
                case 414: 
                case 415: 
                case 418: 
                case 419: 
                case 423: 
                case 425: 
                case 426: 
                case 428: 
                case 429: 
                case 430: 
                case 431: 
                case 432: 
                case 434: 
                case 435: 
                case 436: 
                case 437: 
                case 439: 
                case 440: 
                case 442: 
                case 443: 
                case 444: 
                case 445: 
                case 447: 
                case 449: 
                case 450: 
                case 451: 
                case 454: 
                case 457: 
                case 458: 
                case 459: 
                case 460: 
                case 462: 
                case 463: 
                case 464: 
                case 465: 
                case 467: 
                case 468: 
                case 469: 
                case 470: 
                case 471: 
                case 473: 
                case 475: 
                case 477: 
                case 479: 
                case 482: 
                case 483: 
                case 486: 
                case 487: {
                    return true;
                }
            }
            return false;
        }
    }
}

