/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectFileNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

abstract class OffsetableKey
extends ProjectFileNameBasedKey
implements Comparable<OffsetableKey> {
    private final int startOffset;
    private int endOffset = -2147483647;
    private int hashCode;
    private final CharSequence name;

    protected OffsetableKey(CsmOffsetable obj, CharSequence name) {
        this((FileImpl)obj.getContainingFile(), obj.getStartOffset(), obj.getEndOffset(), name);
    }

    protected OffsetableKey(FileImpl containingFile, int startOffset, CharSequence name) {
        this(containingFile, startOffset, -2147483647, name);
    }

    protected OffsetableKey(FileImpl containingFile, int startOffset, int endOffset, CharSequence name) {
        super(containingFile);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.name = NameCache.getManager().getString(name);
    }

    protected OffsetableKey(KeyDataPresentation presentation) {
        super(presentation);
        this.startOffset = presentation.getStartPresentation();
        this.endOffset = presentation.getEndPresentation();
        this.name = NameCache.getManager().getString(presentation.getNamePresentation());
    }

    abstract char getKind();

    CharSequence getName() {
        if (this.name != null && 0 < this.name.length() && this.isDigit(this.name.charAt(0))) {
            return CharSequences.empty();
        }
        return this.name;
    }

    private boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    int getStartOffset() {
        return this.startOffset;
    }

    final int getEndOffset() {
        return this.endOffset;
    }

    final void cacheEndOffset(int endOffset) {
        assert (this.endOffset == -2147483647 || this.endOffset == endOffset) : "end offset is set already to " + this.endOffset;
        this.endOffset = endOffset;
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        aStream.writeInt(this.startOffset);
        aStream.writeInt(this.endOffset);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, aStream);
    }

    protected OffsetableKey(RepositoryDataInput aStream) throws IOException {
        super(aStream);
        this.startOffset = aStream.readInt();
        this.endOffset = aStream.readInt();
        this.name = PersistentUtils.readUTF(aStream, NameCache.getManager());
        assert (CharSequences.isCompact((CharSequence)this.name));
    }

    @Override
    public String toString() {
        return this.name + "[" + this.getKind() + " " + this.getStartOffset() + "-" + (this.getEndOffset() == -2147483647 ? "U" : Integer.valueOf(this.getEndOffset())) + "] {" + this.getFileNameSafe() + "; " + this.getProjectName() + "}";
    }

    @Override
    public boolean equals(int thisUnitID, Key object, int objectUnitID) {
        if (!super.equals(thisUnitID, object, objectUnitID)) {
            return false;
        }
        OffsetableKey other = (OffsetableKey)object;
        assert (CharSequences.isCompact((CharSequence)this.name));
        assert (CharSequences.isCompact((CharSequence)other.name));
        return this.startOffset == other.startOffset && (this.endOffset == other.endOffset || this.endOffset == -2147483647 || other.endOffset == -2147483647) && this.getHandler() == other.getHandler() && this.name.equals(other.name);
    }

    @Override
    public int hashCode(int unitID) {
        return 59 * this.name.hashCode() + 19 * this.startOffset + super.hashCode(unitID);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.hashCode(this.getUnitId());
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(OffsetableKey other) {
        int ofs2;
        if (this == other) {
            return 0;
        }
        assert (this.getKind() == other.getKind());
        assert (this.getUnitId() == other.getUnitId());
        assert (this.fileNameIndex == other.fileNameIndex);
        int ofs1 = this.getStartOffset();
        if (ofs1 == (ofs2 = other.getStartOffset())) {
            return 0;
        }
        return ofs1 - ofs2;
    }

    @Override
    public int getDepth() {
        return super.getDepth() + 2;
    }

    @Override
    public CharSequence getAt(int level) {
        int superDepth = super.getDepth();
        if (level < superDepth) {
            return super.getAt(level);
        }
        switch (level - superDepth) {
            case 0: {
                return new String(new char[]{this.getKind()});
            }
            case 1: {
                return this.name;
            }
        }
        throw new IllegalArgumentException("not supported level" + level);
    }

    @Override
    public int getSecondaryDepth() {
        return 2;
    }

    @Override
    public int getSecondaryAt(int level) {
        switch (level) {
            case 0: {
                return this.startOffset;
            }
            case 1: {
                return this.endOffset;
            }
        }
        throw new IllegalArgumentException("not supported level" + level);
    }

    @Override
    public final int getStartPresentation() {
        return this.startOffset;
    }

    @Override
    public final int getEndPresentation() {
        return this.endOffset;
    }

    @Override
    public final CharSequence getNamePresentation() {
        return this.name;
    }
}

