/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.configurations;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.NbBundle;

public class MacroExpandedEditorPanel
extends JPanel
implements PropertyChangeListener {
    private final PropertyEditorSupport editor;
    private final Map<String, String> macros;
    private JTextArea commandTextArea;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel previewLabel;
    private JTextArea previewTextArea;

    public MacroExpandedEditorPanel(PropertyEditorSupport editor, PropertyEnv env, Map<String, String> macros) {
        this.editor = editor;
        this.macros = macros;
        this.initComponents();
        this.commandTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MacroExpandedEditorPanel.this.updatePreview();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MacroExpandedEditorPanel.this.updatePreview();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MacroExpandedEditorPanel.this.updatePreview();
            }
        });
        this.commandTextArea.setText(editor.getAsText());
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void updatePreview() {
        String text = this.commandTextArea.getText();
        for (Map.Entry<String, String> entry : this.macros.entrySet()) {
            text = text.replace(entry.getKey(), entry.getValue());
        }
        this.previewTextArea.setText(text);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.commandTextArea = new JTextArea();
        this.previewLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.previewTextArea = new JTextArea();
        this.setPreferredSize(new Dimension(400, 400));
        this.setLayout(new GridBagLayout());
        this.commandTextArea.setColumns(20);
        this.commandTextArea.setLineWrap(true);
        this.commandTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.commandTextArea);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(MacroExpandedEditorPanel.class, (String)"MacroExpandedEditorPanel.previewLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.previewLabel, gridBagConstraints);
        this.previewTextArea.setEditable(false);
        this.previewTextArea.setColumns(20);
        this.previewTextArea.setLineWrap(true);
        this.previewTextArea.setRows(5);
        this.previewTextArea.setFocusable(false);
        this.jScrollPane2.setViewportView(this.previewTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.commandTextArea.getText());
        }
    }
}

