/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.ui.wizard.WizardConstants;
import org.netbeans.modules.cnd.makeproject.api.wizards.PreBuildSupport;
import org.netbeans.modules.cnd.makeproject.ui.wizards.BuildActionsPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PreBuildActionDescriptorPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PreBuildActionPanel
extends JPanel
implements HelpCtx.Provider {
    private static final int VERIFY_DELAY = 300;
    private final DocumentListener documentListener;
    private final AtomicBoolean listenersDisabled = new AtomicBoolean(true);
    private final PreBuildActionDescriptorPanel controller;
    private final RefreshRunnable refreshRunnable;
    private static final RequestProcessor RP = new RequestProcessor("MakefileOrConfigure Validator", 1);
    private final RequestProcessor.Task refreshSourceFolderTask;
    private WizardDescriptor settings;
    private ButtonGroup buttonGroup1;
    private JLabel commandLabel;
    private JScrollPane commandScrollPane;
    private JTextArea commandTextArea;
    private JLabel configureArgumentsLabel;
    private JTextField configureArgumentsTextField;
    private JButton configureBrowseButton;
    private JLabel configureNameLabel;
    private JTextField configureNameTextField;
    private JLabel configureRunFolderLabel;
    private JTextField configureRunFolderTextField;
    private JLabel customCommandLabel;
    private JRadioButton customCommandRadioButton;
    private JTextField customCommandTextField;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JRadioButton predefinedCommandRadioButton;
    private JCheckBox runConfigureCheckBox;
    private JButton runInFolderBrowseButton;
    private JComboBox scriptTypeComboBox;
    private JLabel scriptTypeLabel;

    PreBuildActionPanel(PreBuildActionDescriptorPanel buildActionsDescriptorPanel) {
        this.initComponents();
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.controller = buildActionsDescriptorPanel;
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PreBuildActionPanel.this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PreBuildActionPanel.this.update(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PreBuildActionPanel.this.update(e);
            }
        };
        ScriptTypeItem.items.forEach(item -> this.scriptTypeComboBox.addItem(item));
        this.runConfigureCheckBox.requestFocus();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PreBuildActionPanel.class, (String)"MakefileOrConfigureName_AD"));
        this.addDocumentLiseners();
        this.refreshRunnable = new RefreshRunnable();
        this.refreshSourceFolderTask = RP.create((Runnable)this.refreshRunnable);
    }

    private void addDocumentLiseners() {
        this.configureRunFolderTextField.getDocument().addDocumentListener(this.documentListener);
        this.customCommandTextField.getDocument().addDocumentListener(this.documentListener);
        this.configureNameTextField.getDocument().addDocumentListener(this.documentListener);
        this.configureArgumentsTextField.getDocument().addDocumentListener(this.documentListener);
        this.listenersDisabled.set(false);
    }

    private void removeDocumentLiseners() {
        this.listenersDisabled.set(true);
        this.configureRunFolderTextField.getDocument().removeDocumentListener(this.documentListener);
        this.customCommandTextField.getDocument().removeDocumentListener(this.documentListener);
        this.configureNameTextField.getDocument().removeDocumentListener(this.documentListener);
        this.configureArgumentsTextField.getDocument().removeDocumentListener(this.documentListener);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NewMakeWizardP11");
    }

    private void update(DocumentEvent e) {
        String source = null;
        if (e != null) {
            if (e.getDocument().equals(this.configureNameTextField.getDocument())) {
                source = "script";
            } else if (e.getDocument().equals(this.configureArgumentsTextField.getDocument())) {
                source = "arguments";
            } else if (e.getDocument().equals(this.configureRunFolderTextField.getDocument())) {
                source = "folder";
            } else if (e.getDocument().equals(this.configureRunFolderTextField.getDocument())) {
                source = "folder";
            }
        }
        this.update(source);
    }

    private void update(String source) {
        this.refreshSourceFolderTask.cancel();
        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PreBuildActionPanel.class, (String)"SelectModeError0"));
        this.controller.stateChanged(null);
        this.refreshRunnable.start(this.settings, source);
        this.refreshSourceFolderTask.schedule(300);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(WizardDescriptor wizardDescriptor) {
        this.settings = wizardDescriptor;
        String hostUID = WizardConstants.PROPERTY_HOST_UID.get(wizardDescriptor);
        ExecutionEnvironment ee = null;
        if (hostUID != null) {
            ee = ExecutionEnvironmentFactory.fromUniqueID((String)hostUID);
        }
        CompilerSet cs = null;
        if (ee != null) {
            cs = WizardConstants.PROPERTY_TOOLCHAIN.get(wizardDescriptor);
        }
        try {
            this.removeDocumentLiseners();
            String path = WizardConstants.PROPERTY_SIMPLE_MODE_FOLDER.get(wizardDescriptor);
            if (path != null) {
                FileSystem fileSystem;
                PreBuildSupport.PreBuildArtifact configureScript;
                ExecutionEnvironment env = WizardConstants.PROPERTY_REMOTE_FILE_SYSTEM_ENV.get(wizardDescriptor);
                if (env == null) {
                    env = ExecutionEnvironmentFactory.getLocal();
                }
                if ((configureScript = PreBuildSupport.findArtifactInFolder((FileObject)(fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)env)).findResource(path), (ExecutionEnvironment)env, (CompilerSet)cs)) != null) {
                    this.runConfigureCheckBox.setSelected(true);
                    this.configureRunFolderTextField.setText(path);
                    this.predefinedCommandRadioButton.setSelected(true);
                    this.configureNameTextField.setText(configureScript.getScript().getPath());
                    for (ScriptTypeItem item : ScriptTypeItem.items) {
                        if (!item.isSupported(configureScript)) continue;
                        this.scriptTypeComboBox.setSelectedItem(item);
                        break;
                    }
                    String configureArguments = configureScript.getArguments(ee, cs, "");
                    this.configureArgumentsTextField.setText(configureArguments);
                    String commandLine = configureScript.getCommandLine(configureArguments, path);
                    this.commandTextArea.setText(PreBuildSupport.expandMacros((String)commandLine, (CompilerSet)cs, null));
                } else {
                    this.runConfigureCheckBox.setSelected(false);
                    this.configureRunFolderTextField.setText(path);
                    this.customCommandRadioButton.setSelected(true);
                }
            }
            this.enableControls();
        }
        finally {
            this.addDocumentLiseners();
        }
        this.update((DocumentEvent)null);
    }

    void store(WizardDescriptor wizardDescriptor) {
        WizardConstants.PROPERTY_RUN_CONFIGURE.put(wizardDescriptor, this.runConfigureCheckBox.isSelected());
        WizardConstants.PROPERTY_CONFIGURE_RUN_FOLDER.put(wizardDescriptor, this.configureRunFolderTextField.getText());
        if (this.customCommandRadioButton.isSelected()) {
            WizardConstants.PROPERTY_CONFIGURE_COMMAND.put(wizardDescriptor, this.customCommandTextField.getText());
            WizardConstants.PROPERTY_CONFIGURE_SCRIPT_PATH.put(wizardDescriptor, null);
            WizardConstants.PROPERTY_CONFIGURE_SCRIPT_ARGS.put(wizardDescriptor, null);
        } else if (this.predefinedCommandRadioButton.isSelected()) {
            PreBuildSupport.PreBuildArtifact configureScript;
            WizardConstants.PROPERTY_CONFIGURE_COMMAND.put(wizardDescriptor, null);
            FileObject file = NewProjectWizardUtils.getFileObject(this.configureNameTextField.getText(), this.controller.getWizardDescriptor());
            if (file != null && file.isValid() && (configureScript = PreBuildSupport.scriptToArtifact((FileObject)file)) != null) {
                String arguments = this.configureArgumentsTextField.getText();
                WizardConstants.PROPERTY_CONFIGURE_COMMAND.put(wizardDescriptor, configureScript.getCommandLine(arguments, this.configureRunFolderTextField.getText()));
            }
            WizardConstants.PROPERTY_CONFIGURE_SCRIPT_PATH.put(wizardDescriptor, this.configureNameTextField.getText());
            WizardConstants.PROPERTY_CONFIGURE_SCRIPT_ARGS.put(wizardDescriptor, this.configureArgumentsTextField.getText());
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.runConfigureCheckBox = new JCheckBox();
        this.configureRunFolderLabel = new JLabel();
        this.configureRunFolderTextField = new JTextField();
        this.runInFolderBrowseButton = new JButton();
        this.customCommandRadioButton = new JRadioButton();
        this.customCommandLabel = new JLabel();
        this.customCommandTextField = new JTextField();
        this.predefinedCommandRadioButton = new JRadioButton();
        this.scriptTypeLabel = new JLabel();
        this.scriptTypeComboBox = new JComboBox();
        this.configureNameLabel = new JLabel();
        this.configureNameTextField = new JTextField();
        this.configureBrowseButton = new JButton();
        this.configureArgumentsLabel = new JLabel();
        this.configureArgumentsTextField = new JTextField();
        this.commandLabel = new JLabel();
        this.commandScrollPane = new JScrollPane();
        this.commandTextArea = new JTextArea();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.setPreferredSize(new Dimension(450, 350));
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.runConfigureCheckBox, (String)bundle.getString("RUN_CONFIGURE_CHECKBOX"));
        this.runConfigureCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreBuildActionPanel.this.runConfigureCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.runConfigureCheckBox, gridBagConstraints);
        this.configureRunFolderLabel.setLabelFor(this.configureRunFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.configureRunFolderLabel, (String)NbBundle.getMessage(PreBuildActionPanel.class, (String)"RunInFolderLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.configureRunFolderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.configureRunFolderTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.runInFolderBrowseButton, (String)NbBundle.getMessage(PreBuildActionPanel.class, (String)"RunInFolderBrowse"));
        this.runInFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreBuildActionPanel.this.runInFolderBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.runInFolderBrowseButton, gridBagConstraints);
        this.buttonGroup1.add(this.customCommandRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.customCommandRadioButton, (String)NbBundle.getMessage(PreBuildActionPanel.class, (String)"CustomCommandRadioButton"));
        this.customCommandRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreBuildActionPanel.this.customCommandRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.customCommandRadioButton, gridBagConstraints);
        this.customCommandLabel.setLabelFor(this.customCommandTextField);
        Mnemonics.setLocalizedText((JLabel)this.customCommandLabel, (String)NbBundle.getMessage(PreBuildActionPanel.class, (String)"CustomCommandLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.customCommandLabel, gridBagConstraints);
        this.customCommandTextField.setToolTipText(NbBundle.getMessage(PreBuildActionPanel.class, (String)"customCommandTextField_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.customCommandTextField, gridBagConstraints);
        this.buttonGroup1.add(this.predefinedCommandRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.predefinedCommandRadioButton, (String)NbBundle.getMessage(PreBuildActionPanel.class, (String)"PredefinedCommandRadioButton"));
        this.predefinedCommandRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreBuildActionPanel.this.predefinedCommandRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.predefinedCommandRadioButton, gridBagConstraints);
        this.scriptTypeLabel.setLabelFor(this.scriptTypeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.scriptTypeLabel, (String)NbBundle.getMessage(PreBuildActionPanel.class, (String)"ScriptType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.scriptTypeLabel, gridBagConstraints);
        this.scriptTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PreBuildActionPanel.this.scriptTypeComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.scriptTypeComboBox, gridBagConstraints);
        this.configureNameLabel.setLabelFor(this.configureNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.configureNameLabel, (String)bundle.getString("CONFIGURE_NAME_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.configureNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.configureNameTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.configureBrowseButton, (String)bundle.getString("CONFIGURE_BROWSE_BUTTON"));
        this.configureBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreBuildActionPanel.this.configureBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.configureBrowseButton, gridBagConstraints);
        this.configureArgumentsLabel.setLabelFor(this.configureArgumentsTextField);
        Mnemonics.setLocalizedText((JLabel)this.configureArgumentsLabel, (String)bundle.getString("CONFIGURE_ARGUMENT_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 16, 0, 0);
        this.add((Component)this.configureArgumentsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.configureArgumentsTextField, gridBagConstraints);
        this.commandLabel.setLabelFor(this.commandTextArea);
        Mnemonics.setLocalizedText((JLabel)this.commandLabel, (String)NbBundle.getMessage(PreBuildActionPanel.class, (String)"PreviewLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.commandLabel, gridBagConstraints);
        this.commandTextArea.setColumns(20);
        this.commandTextArea.setLineWrap(true);
        this.commandTextArea.setRows(4);
        this.commandScrollPane.setViewportView(this.commandTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.commandScrollPane, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setText(bundle.getString("MakefileOrConfigureInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        this.instructionsTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PreBuildActionPanel.class, (String)"CONFIGURE_HELP"));
        this.instructionsTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PreBuildActionPanel.class, (String)"CONFIGURE_HELP_AD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
    }

    private void configureBrowseButtonActionPerformed(ActionEvent evt) {
        String seed = this.configureNameTextField.getText();
        if (seed.isEmpty()) {
            String root = WizardConstants.PROPERTY_SIMPLE_MODE_FOLDER.get(this.controller.getWizardDescriptor());
            seed = root != null && !root.isEmpty() ? root : (FileChooser.getCurrentChooserFile() != null ? FileChooser.getCurrentChooserFile().getPath() : System.getProperty("user.home"));
        }
        ScriptTypeItem selectedItem = (ScriptTypeItem)this.scriptTypeComboBox.getSelectedItem();
        JFileChooser fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), selectedItem.getFileChooserTitle(), NbBundle.getMessage(PreBuildActionPanel.class, (String)"MAKEFILE_CHOOSER_BUTTON_TXT"), 0, selectedItem.getFileFilter(), seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = CndPathUtilities.normalizeSlashes((String)path);
        this.configureNameTextField.setText(path);
        this.update(new DocumentEvent(){

            @Override
            public int getOffset() {
                return 0;
            }

            @Override
            public int getLength() {
                return PreBuildActionPanel.this.configureNameTextField.getText().length();
            }

            @Override
            public Document getDocument() {
                return PreBuildActionPanel.this.configureNameTextField.getDocument();
            }

            @Override
            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.CHANGE;
            }

            @Override
            public DocumentEvent.ElementChange getChange(Element elem) {
                return null;
            }
        });
    }

    private void runConfigureCheckBoxActionPerformed(ActionEvent evt) {
        this.enableControls();
        this.update((String)null);
    }

    private void customCommandRadioButtonActionPerformed(ActionEvent evt) {
        this.enableControls();
        this.update("type");
    }

    private void predefinedCommandRadioButtonActionPerformed(ActionEvent evt) {
        this.enableControls();
        this.update("type");
    }

    private void runInFolderBrowseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser;
        int ret;
        String seed = this.configureRunFolderTextField.getText();
        if (seed.isEmpty()) {
            String root = WizardConstants.PROPERTY_SIMPLE_MODE_FOLDER.get(this.controller.getWizardDescriptor());
            seed = root != null && !root.isEmpty() ? root : (FileChooser.getCurrentChooserFile() != null ? FileChooser.getCurrentChooserFile().getPath() : System.getProperty("user.home"));
        }
        if ((ret = (fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), NbBundle.getMessage(PreBuildActionPanel.class, (String)"SelectRunInFolder"), NbBundle.getMessage(PreBuildActionPanel.class, (String)"MAKEFILE_CHOOSER_BUTTON_TXT"), 1, null, seed, false)).showOpenDialog(this)) == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = CndPathUtilities.normalizeSlashes((String)path);
        this.configureRunFolderTextField.setText(path);
        this.update(new DocumentEvent(){

            @Override
            public int getOffset() {
                return 0;
            }

            @Override
            public int getLength() {
                return PreBuildActionPanel.this.configureRunFolderTextField.getText().length();
            }

            @Override
            public Document getDocument() {
                return PreBuildActionPanel.this.configureRunFolderTextField.getDocument();
            }

            @Override
            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.CHANGE;
            }

            @Override
            public DocumentEvent.ElementChange getChange(Element elem) {
                return null;
            }
        });
    }

    private void scriptTypeComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1 && !this.listenersDisabled.get()) {
            this.update("provider");
        }
    }

    private void enableControls() {
        this.runConfigureCheckBox.setEnabled(true);
        boolean selected = this.runConfigureCheckBox.isSelected();
        this.configureRunFolderLabel.setEnabled(selected);
        this.configureRunFolderTextField.setEnabled(selected);
        this.customCommandRadioButton.setEnabled(selected);
        boolean custom = this.customCommandRadioButton.isSelected();
        this.customCommandLabel.setEnabled(selected && custom);
        this.customCommandTextField.setEnabled(selected && custom);
        this.predefinedCommandRadioButton.setEnabled(selected);
        boolean predefined = this.predefinedCommandRadioButton.isSelected();
        this.scriptTypeLabel.setEnabled(selected && predefined);
        this.scriptTypeComboBox.setEnabled(selected && predefined);
        this.configureNameLabel.setEnabled(selected && predefined);
        this.configureNameTextField.setEnabled(selected && predefined);
        this.configureBrowseButton.setEnabled(selected && predefined);
        this.configureArgumentsLabel.setEnabled(selected && predefined);
        this.configureArgumentsTextField.setEnabled(selected && predefined);
        this.commandLabel.setEnabled(selected);
        this.commandTextArea.setEnabled(selected);
        this.commandTextArea.setEditable(false);
    }

    private static final class ScriptTypeItem {
        static final List<ScriptTypeItem> items = new ArrayList<ScriptTypeItem>();
        private final PreBuildSupport.PreBuildArtifactProvider provider;

        private ScriptTypeItem(PreBuildSupport.PreBuildArtifactProvider provider) {
            this.provider = provider;
        }

        public String getFileChooserTitle() {
            return this.provider.getFileChooserTitle();
        }

        FileFilter[] getFileFilter() {
            return this.provider.getFileFilter();
        }

        public String toString() {
            return this.provider.getDisplayName();
        }

        private boolean isSupported(PreBuildSupport.PreBuildArtifact script) {
            return this.provider.isSupported(script);
        }

        static {
            PreBuildSupport.getPreBuildProviders().forEach(provider -> items.add(new ScriptTypeItem((PreBuildSupport.PreBuildArtifactProvider)provider)));
        }
    }

    private class RefreshRunnable
    implements Runnable {
        private final AtomicInteger generation = new AtomicInteger(0);
        private WizardDescriptor settings;
        private String changedField;

        private void start(WizardDescriptor settings, String changedField) {
            this.settings = settings;
            this.changedField = changedField;
            this.generation.incrementAndGet();
        }

        @Override
        public void run() {
            int startCount = this.generation.get();
            String newConfigureNameTextField = null;
            String newConfigureArgumentsTextField = null;
            String newConfigureRunFolderTextField = null;
            String newCommandText = null;
            if (PreBuildActionPanel.this.runConfigureCheckBox.isSelected()) {
                String hostUID = WizardConstants.PROPERTY_HOST_UID.get(this.settings);
                ExecutionEnvironment ee = null;
                if (hostUID != null) {
                    ee = ExecutionEnvironmentFactory.fromUniqueID((String)hostUID);
                }
                CompilerSet cs = null;
                if (ee != null) {
                    cs = WizardConstants.PROPERTY_TOOLCHAIN.get(this.settings);
                }
                if (PreBuildActionPanel.this.predefinedCommandRadioButton.isSelected()) {
                    String msg;
                    if ("provider".equals(this.changedField)) {
                        ScriptTypeItem item = (ScriptTypeItem)PreBuildActionPanel.this.scriptTypeComboBox.getSelectedItem();
                        FileObject folder = NewProjectWizardUtils.getFileObject(PreBuildActionPanel.this.configureRunFolderTextField.getText(), PreBuildActionPanel.this.controller.getWizardDescriptor());
                        PreBuildSupport.PreBuildArtifact otherArtifact = item.provider.findScriptInFolder(folder, ee, cs);
                        if (otherArtifact == null) {
                            FileObject root = NewProjectWizardUtils.getFileObject(WizardConstants.PROPERTY_SIMPLE_MODE_FOLDER.get(PreBuildActionPanel.this.controller.getWizardDescriptor()), PreBuildActionPanel.this.controller.getWizardDescriptor());
                            otherArtifact = item.provider.findScriptInFolder(root, ee, cs);
                            if (otherArtifact == null) {
                                String msg2 = NbBundle.getMessage(BuildActionsPanel.class, (String)"NOTFOUNDCONFIGUREFILE", (Object)item.provider.getDisplayName(), (Object)(cs == null ? "" : cs.getName()));
                                PreBuildActionPanel.this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg2);
                                return;
                            }
                        }
                        newConfigureNameTextField = otherArtifact.getScript().getPath();
                    } else {
                        newConfigureNameTextField = PreBuildActionPanel.this.configureNameTextField.getText();
                    }
                    if (newConfigureNameTextField.isEmpty()) {
                        msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"NOCONFIGUREFILE");
                        PreBuildActionPanel.this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
                        return;
                    }
                    if (!CndPathUtilities.isPathAbsolute((CharSequence)newConfigureNameTextField)) {
                        msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"CONFIGUREFILEDOESNOTEXIST");
                        PreBuildActionPanel.this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
                        return;
                    }
                    FileObject file = NewProjectWizardUtils.getFileObject(newConfigureNameTextField, PreBuildActionPanel.this.controller.getWizardDescriptor());
                    if (file == null || !file.isValid() || file.isFolder()) {
                        String msg3 = NbBundle.getMessage(BuildActionsPanel.class, (String)"CONFIGUREFILEDOESNOTEXIST");
                        PreBuildActionPanel.this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg3);
                        return;
                    }
                    PreBuildSupport.PreBuildArtifact configureScript = PreBuildSupport.scriptToArtifact((FileObject)file);
                    if (configureScript == null) {
                        String msg4 = NbBundle.getMessage(BuildActionsPanel.class, (String)"UndefinedScriptMessage");
                        PreBuildActionPanel.this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg4);
                        return;
                    }
                    String message = configureScript.validate(ee, cs);
                    if (message != null) {
                        PreBuildActionPanel.this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)message);
                        return;
                    }
                    if ("script".equals(this.changedField) || "provider".equals(this.changedField)) {
                        FileObject parent;
                        if (PreBuildActionPanel.this.configureRunFolderTextField.getText().isEmpty() && (parent = file.getParent()) != null) {
                            newConfigureRunFolderTextField = parent.getPath();
                        }
                        newConfigureArgumentsTextField = configureScript.getArguments(ee, cs, "");
                    }
                    if ("script".equals(this.changedField) || "folder".equals(this.changedField) || "arguments".equals(this.changedField) || "type".equals(this.changedField) || "provider".equals(this.changedField)) {
                        String commandLine = configureScript.getCommandLine(newConfigureArgumentsTextField == null ? PreBuildActionPanel.this.configureArgumentsTextField.getText() : newConfigureArgumentsTextField, newConfigureRunFolderTextField == null ? PreBuildActionPanel.this.configureRunFolderTextField.getText() : newConfigureRunFolderTextField);
                        newCommandText = PreBuildSupport.expandMacros((String)commandLine, (CompilerSet)cs, null);
                    }
                } else if (PreBuildActionPanel.this.customCommandRadioButton.isSelected()) {
                    if (PreBuildActionPanel.this.customCommandTextField.getText().trim().isEmpty()) {
                        SwingUtilities.invokeLater(() -> PreBuildActionPanel.this.commandTextArea.setText(""));
                        String msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"CUSTOM_COMMAND_EMPTY");
                        PreBuildActionPanel.this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
                        return;
                    }
                    newCommandText = PreBuildSupport.expandMacros((String)PreBuildActionPanel.this.customCommandTextField.getText().trim(), (CompilerSet)cs, null);
                }
            }
            if (startCount < this.generation.get()) {
                return;
            }
            String finalConfigureNameTextField = newConfigureNameTextField;
            String finalConfigureArgumentsTextField = newConfigureArgumentsTextField;
            String finalConfigureRunFolderTextField = newConfigureRunFolderTextField;
            String finalCommandText = newCommandText;
            SwingUtilities.invokeLater(() -> {
                if (startCount < this.generation.get()) {
                    return;
                }
                PreBuildActionPanel.this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)"");
                try {
                    PreBuildActionPanel.this.removeDocumentLiseners();
                    if (finalConfigureRunFolderTextField != null && !PreBuildActionPanel.this.configureRunFolderTextField.getText().equals(finalConfigureArgumentsTextField)) {
                        PreBuildActionPanel.this.configureRunFolderTextField.setText(finalConfigureRunFolderTextField);
                    }
                    if (finalConfigureNameTextField != null && !PreBuildActionPanel.this.configureNameTextField.getText().equals(finalConfigureNameTextField)) {
                        PreBuildActionPanel.this.configureNameTextField.setText(finalConfigureNameTextField);
                    }
                    if (finalConfigureArgumentsTextField != null && !PreBuildActionPanel.this.configureArgumentsTextField.getText().equals(finalConfigureArgumentsTextField)) {
                        PreBuildActionPanel.this.configureArgumentsTextField.setText(finalConfigureArgumentsTextField);
                    }
                    if (finalCommandText != null && !PreBuildActionPanel.this.commandTextArea.getText().equals(finalCommandText)) {
                        PreBuildActionPanel.this.commandTextArea.setText(finalCommandText);
                    }
                }
                finally {
                    PreBuildActionPanel.this.addDocumentLiseners();
                }
                PreBuildActionPanel.this.controller.stateChanged(null);
            });
        }
    }
}

