/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class LambdaFunctionDeclaration
extends Expression {
    private final boolean isReference;
    private final boolean isStatic;
    private final List<FormalParameter> formalParameters = new ArrayList<FormalParameter>();
    @NullAllowed
    private final Expression returnType;
    private final List<Expression> lexicalVariables = new ArrayList<Expression>();
    private final Block body;

    public LambdaFunctionDeclaration(int start, int end, List formalParameters, Expression returnType, List lexicalVars, Block body, boolean isReference, boolean isStatic) {
        super(start, end);
        if (formalParameters == null) {
            throw new IllegalArgumentException();
        }
        this.isReference = isReference;
        this.isStatic = isStatic;
        this.formalParameters.addAll(formalParameters);
        this.returnType = returnType;
        if (lexicalVars != null) {
            this.lexicalVariables.addAll(lexicalVars);
        }
        this.body = body;
    }

    public Block getBody() {
        return this.body;
    }

    public List<FormalParameter> getFormalParameters() {
        return this.formalParameters;
    }

    @CheckForNull
    public Expression getReturnType() {
        return this.returnType;
    }

    public List<Expression> getLexicalVariables() {
        return this.lexicalVariables;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sbParams = new StringBuilder();
        for (FormalParameter formalParameter : this.getFormalParameters()) {
            sbParams.append(formalParameter).append(",");
        }
        StringBuilder sbLex = new StringBuilder();
        for (Expression expression : this.getLexicalVariables()) {
            sbLex.append(expression).append(",");
        }
        return (this.isStatic() ? "static " : " ") + "function" + (this.isReference() ? " & " : "") + "(" + sbParams.toString() + ")" + (this.getReturnType() != null ? ": " + this.getReturnType() : "") + (sbLex.length() > 0 ? " use (" + sbLex.toString() + ")" : "") + this.getBody();
    }
}

