/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.makefile.utils.IpeFileSystemView;
import org.netbeans.modules.cnd.makefile.wizard.MakefileData;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.utils.ui.CndUIUtilities;

public class CompilerPathPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = 1334257510688903149L;
    private JTextField c;
    private JTextField cpp;
    private JTextField f95;
    private JTextField asm;
    private boolean initialized;
    private JFileChooser fc;
    private File chooserDir;

    public CompilerPathPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = this.getString("LBL_CompilerPathPanel");
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle);
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints grid = new GridBagConstraints();
        grid.fill = 2;
        JLabel pathLabel = new JLabel(this.getString("LBL_CompilerPaths"));
        grid.anchor = 18;
        grid.gridx = 0;
        grid.gridy = 0;
        grid.gridwidth = 0;
        this.add(pathLabel, grid, -1);
        this.c = this.createLine(1, this.getString("LBL_C"), this.getString("MNEM_C"));
        this.cpp = this.createLine(2, this.getString("LBL_Cpp"), this.getString("MNEM_Cpp"));
        this.f95 = this.createLine(4, this.getString("LBL_F95"), this.getString("MNEM_F95"));
        this.asm = this.createLine(5, this.getString("LBL_Asm"), this.getString("MNEM_Asm"));
        this.c.addFocusListener(this);
        this.cpp.addFocusListener(this);
        this.f95.addFocusListener(this);
        this.asm.addFocusListener(this);
        grid.gridx = 0;
        grid.gridy = 7;
        grid.gridwidth = 0;
        grid.gridheight = 0;
        grid.weightx = 1.0;
        grid.weighty = 1.0;
        this.add((Component)new JLabel(""), grid);
    }

    private JTextField createLine(int lnum, String label, String mnemonic) {
        GridBagConstraints grid = new GridBagConstraints();
        grid.gridy = lnum;
        JLabel nueLabel = new JLabel(label);
        nueLabel.setDisplayedMnemonic(mnemonic.charAt(0));
        grid.anchor = 17;
        grid.gridx = 0;
        grid.gridwidth = 1;
        grid.insets = lnum == 1 ? new Insets(5, 0, 0, 0) : new Insets(11, 0, 0, 0);
        this.add((Component)nueLabel, grid);
        JTextField nueText = new JTextField();
        nueLabel.setLabelFor(nueText);
        grid.anchor = 17;
        grid.gridx = 1;
        grid.gridwidth = -1;
        grid.fill = 2;
        grid.weightx = 1.0;
        grid.insets = new Insets(11, 12, 0, 0);
        this.add((Component)nueText, grid);
        JButton chooser = new JButton(this.getString("BTN_Chooser"));
        String mnem = "MNEM_Chooser" + lnum;
        chooser.setMnemonic(this.getString(mnem).charAt(0));
        grid.anchor = 17;
        grid.gridx = 2;
        grid.gridwidth = 1;
        grid.fill = 0;
        grid.weightx = 0.0;
        grid.insets = new Insets(11, 5, 0, 0);
        this.add((Component)chooser, grid);
        this.createChooser(nueText, chooser);
        return nueText;
    }

    protected void createChooser(final JTextField text, JButton chooser) {
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (CompilerPathPanel.this.fc == null) {
                    CompilerPathPanel.this.fc = new JFileChooser();
                    CompilerPathPanel.this.fc.setApproveButtonText(CompilerPathPanel.this.getString("BTN_Approve"));
                    CompilerPathPanel.this.fc.setFileSystemView(new IpeFileSystemView(CompilerPathPanel.this.fc.getFileSystemView()));
                    CompilerPathPanel.this.fc.setDialogTitle(CompilerPathPanel.this.getString("DLG_FILE_CHOOSER_TITLE"));
                }
                if (CompilerPathPanel.this.chooserDir == null) {
                    CompilerPathPanel.this.chooserDir = new File(CompilerPathPanel.this.getMakefileData().getBaseDirectory());
                }
                CompilerPathPanel.this.fc.setCurrentDirectory(CompilerPathPanel.this.chooserDir);
                int returnVal = CompilerPathPanel.this.fc.showDialog(CompilerPathPanel.this, null);
                if (returnVal == 0) {
                    CompilerPathPanel.this.chooserDir = CompilerPathPanel.this.fc.getCurrentDirectory();
                    text.setText(CompilerPathPanel.this.fc.getSelectedFile().getAbsolutePath());
                }
            }
        });
    }

    @Override
    public void addNotify() {
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        MakefileData md = this.getMakefileData();
        this.c.setText(md.getCCompiler(md.getToolset()));
        this.cpp.setText(md.getCppCompiler(md.getToolset()));
        this.f95.setText(md.getFCompiler(md.getToolset()));
        this.asm.setText(md.getAsmPath());
        super.addNotify();
        this.c.selectAll();
        CndUIUtilities.requestFocus((Component)this.c);
    }

    @Override
    public void removeNotify() {
        Container o;
        super.removeNotify();
        if (this.fc != null && this.fc.isShowing() && (o = this.fc.getTopLevelAncestor()) != null && o instanceof JDialog) {
            ((JDialog)o).dispose();
        }
        MakefileData md = this.getMakefileData();
        if (this.c.getText().length() > 0) {
            md.setCCompiler(md.getToolset(), this.c.getText());
        }
        if (this.cpp.getText().length() > 0) {
            md.setCppCompiler(md.getToolset(), this.cpp.getText());
        }
        if (this.f95.getText().length() > 0) {
            md.setFCompiler(md.getToolset(), this.f95.getText());
        }
        if (this.asm.getText().length() > 0) {
            md.setAsmPath(this.asm.getText());
        }
    }

    @Override
    public void focusGained(FocusEvent evt) {
    }

    @Override
    public void focusLost(FocusEvent evt) {
        ((JTextField)evt.getComponent()).setSelectionEnd(0);
    }
}

