/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPutAttributesRequestMarshaller
implements Marshaller<Request<BatchPutAttributesRequest>, BatchPutAttributesRequest> {
    @Override
    public Request<BatchPutAttributesRequest> marshall(BatchPutAttributesRequest batchPutAttributesRequest) {
        DefaultRequest<BatchPutAttributesRequest> request = new DefaultRequest<BatchPutAttributesRequest>(batchPutAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "BatchPutAttributes");
        request.addParameter("Version", "2009-04-15");
        if (batchPutAttributesRequest != null && batchPutAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(batchPutAttributesRequest.getDomainName()));
        }
        if (batchPutAttributesRequest != null) {
            List<ReplaceableItem> itemsList = batchPutAttributesRequest.getItems();
            int itemsListIndex = 1;
            for (ReplaceableItem itemsListValue : itemsList) {
                if (itemsListValue != null && itemsListValue.getName() != null) {
                    request.addParameter("Item." + itemsListIndex + ".ItemName", StringUtils.fromString(itemsListValue.getName()));
                }
                if (itemsListValue != null) {
                    List<ReplaceableAttribute> attributesList = itemsListValue.getAttributes();
                    int attributesListIndex = 1;
                    for (ReplaceableAttribute attributesListValue : attributesList) {
                        if (attributesListValue != null && attributesListValue.getName() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Name", StringUtils.fromString(attributesListValue.getName()));
                        }
                        if (attributesListValue != null && attributesListValue.getValue() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Value", StringUtils.fromString(attributesListValue.getValue()));
                        }
                        if (attributesListValue != null && attributesListValue.isReplace() != null) {
                            request.addParameter("Item." + itemsListIndex + ".Attribute." + attributesListIndex + ".Replace", StringUtils.fromBoolean(attributesListValue.isReplace()));
                        }
                        ++attributesListIndex;
                    }
                }
                ++itemsListIndex;
            }
        }
        return request;
    }
}

