/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.javaee.wildfly.ide.ui.DomainComboModel;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginProperties;
import org.netbeans.modules.javaee.wildfly.ide.ui.WildflyPluginUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AddServerPropertiesVisualPanel
extends JPanel {
    private final Set listeners = new HashSet();
    private JComboBox domainField;
    private JTextField domainPathField;
    private JLabel domainLabel;
    private JLabel domainPathLabel;
    private JLabel label1;
    private JPanel panel1;
    private JLabel hostLabel;
    private JTextField hostField;
    private JLabel portLabel;
    private JTextField portField;
    private JLabel managementPortLabel;
    private JTextField managementPortField;
    private JLabel userLabel;
    private JTextField userField;
    private JLabel passwordLabel;
    private JPasswordField passwordField;
    private JComboBox serverType;

    public AddServerPropertiesVisualPanel() {
        this.init();
        this.setName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"TITLE_ServerProperties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    private void somethingChanged() {
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeEvent() {
        Iterator it;
        Set set = this.listeners;
        synchronized (set) {
            it = new HashSet(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public boolean isLocalServer() {
        return "Local".equals(this.serverType.getSelectedItem());
    }

    public String getHost() {
        return this.hostField.getText().trim();
    }

    public String getPort() {
        return this.portField.getText().trim();
    }

    public String getManagementPort() {
        return this.managementPortField.getText().trim();
    }

    public String getUser() {
        return this.userField.getText();
    }

    public String getPassword() {
        return new String(this.passwordField.getPassword());
    }

    public String getDomainPath() {
        return this.domainPathField.getText();
    }

    public String getDomain() {
        return (String)this.domainField.getSelectedItem();
    }

    private void domainChanged() {
        DomainComboModel model = (DomainComboModel)this.domainField.getModel();
        String path = model.getCurrentPath();
        this.domainPathField.setText(path);
        this.portField.setText(WildflyPluginUtils.getHTTPConnectorPort(path));
        this.managementPortField.setText(WildflyPluginUtils.getManagementConnectorPort(path));
        this.fireChangeEvent();
    }

    void installLocationChanged() {
        File domainDir;
        DomainComboModel domainModel = (DomainComboModel)this.domainField.getModel();
        String serverLocation = WildflyPluginProperties.getInstance().getInstallLocation();
        domainModel.setDomains(WildflyPluginUtils.getRegisteredDomains(serverLocation));
        String configLocation = WildflyPluginProperties.getInstance().getConfigLocation();
        File folder = new File(configLocation).getParentFile();
        if (folder != null) {
            folder = folder.getParentFile();
        }
        if ((domainDir = folder) != null) {
            if (domainModel.hasDomain(domainDir.getName())) {
                domainModel.setSelectedItem(domainDir.getName());
            } else {
                domainModel.addDomain(domainDir.getName(), domainDir.getAbsolutePath());
            }
        } else {
            domainModel.setSelectedItem(null);
        }
        this.domainChanged();
    }

    private void serverTypeChanged() {
        if (this.isLocalServer()) {
            this.domainLabel.setVisible(true);
            this.domainField.setVisible(true);
            this.domainPathLabel.setVisible(true);
            this.domainPathField.setVisible(true);
            this.hostField.setEditable(true);
        } else {
            this.domainLabel.setVisible(false);
            this.domainField.setVisible(false);
            this.domainPathLabel.setVisible(false);
            this.domainPathField.setVisible(false);
            this.hostField.setEditable(true);
        }
        this.somethingChanged();
    }

    private void init() {
        this.label1 = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"TXT_PROPERTY_TEXT"));
        this.serverType = new JComboBox<String>(new String[]{"Local", "Remote"});
        this.serverType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddServerPropertiesVisualPanel.this.serverTypeChanged();
            }
        });
        this.domainPathLabel = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_DomainPath"));
        this.domainPathField = new JTextField();
        this.domainPathField.setColumns(20);
        this.domainPathField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_DomainPath"));
        this.domainPathField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_DomainPath"));
        this.panel1 = new JPanel();
        this.domainLabel = new JLabel();
        String serverLocation = WildflyPluginProperties.getInstance().getInstallLocation();
        this.domainField = new JComboBox(new DomainComboModel(WildflyPluginUtils.getRegisteredDomains(serverLocation)));
        this.domainField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Domain"));
        this.domainField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Domain"));
        this.domainField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddServerPropertiesVisualPanel.this.domainChanged();
            }
        });
        this.domainLabel.setLabelFor(this.domainField);
        Mnemonics.setLocalizedText((JLabel)this.domainLabel, (String)NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Domain"));
        this.hostLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Host"));
        this.hostField = new JTextField();
        this.hostField.setColumns(20);
        this.hostField.setEditable(true);
        this.hostField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Host"));
        this.hostField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Host"));
        this.hostField.addKeyListener(new SomeChangesListener());
        this.hostLabel.setLabelFor(this.hostField);
        this.portLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Port"));
        this.portField = new JTextField();
        this.portField.setColumns(20);
        this.portField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Port"));
        this.portField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Port"));
        this.portField.addKeyListener(new SomeChangesListener());
        this.portLabel.setLabelFor(this.portField);
        this.managementPortLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.managementPortLabel, (String)NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Management_Port"));
        this.managementPortField = new JTextField();
        this.managementPortField.setColumns(20);
        this.managementPortField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Management_Port"));
        this.managementPortField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Management_Port"));
        this.managementPortField.addKeyListener(new SomeChangesListener());
        this.managementPortLabel.setLabelFor(this.managementPortField);
        this.userLabel = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_User"));
        this.userField = new JTextField();
        this.userField.addKeyListener(new SomeChangesListener());
        this.passwordLabel = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_Password"));
        this.passwordField = new JPasswordField();
        this.passwordField.addKeyListener(new SomeChangesListener());
        this.setLayout(new GridBagLayout());
        this.setFocusable(false);
        this.setMinimumSize(new Dimension(280, 217));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.label1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.serverType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.domainLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.domainField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.add((Component)this.domainPathLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.domainPathField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.hostLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.hostField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.portLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.portField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.managementPortLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.managementPortField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.userLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.userField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.passwordLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.passwordField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.domainPathField.setEnabled(false);
        this.userField.setVisible(false);
        this.userLabel.setVisible(false);
        this.passwordField.setVisible(false);
        this.passwordLabel.setVisible(false);
        this.serverType.setVisible(false);
        this.add((Component)this.panel1, gridBagConstraints);
        this.hostField.setText("localhost");
        this.portField.setText(WildflyPluginUtils.getHTTPConnectorPort(this.domainPathField.getText()));
        this.domainChanged();
    }

    private String browseDomainLocation() {
        String insLocation = null;
        JFileChooser chooser = this.getJFileChooser();
        int returnValue = chooser.showDialog(this, NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_ChooseButton"));
        if (returnValue == 0) {
            insLocation = chooser.getSelectedFile().getAbsolutePath();
        }
        return insLocation;
    }

    private JFileChooser getJFileChooser() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("LBL_Chooser_Name");
        chooser.setDialogType(2);
        chooser.setFileSelectionMode(1);
        chooser.setApproveButtonMnemonic("Choose_Button_Mnemonic".charAt(0));
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new dirFilter());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setApproveButtonToolTipText("LBL_Chooser_Name");
        chooser.getAccessibleContext().setAccessibleName("LBL_Chooser_Name");
        chooser.getAccessibleContext().setAccessibleDescription("LBL_Chooser_Name");
        return chooser;
    }

    private static class dirFilter
    extends FileFilter {
        private dirFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.exists() && f.canRead() && f.isDirectory();
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"LBL_DirType");
        }
    }

    class SomeChangesListener
    implements KeyListener {
        SomeChangesListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            AddServerPropertiesVisualPanel.this.somethingChanged();
        }
    }
}

