/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import org.clang.basic.FileID;
import org.clang.basic.LineEntry;
import org.clang.basic.SrcMgr;
import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdMapIntType;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMapEntryUInt;
import org.llvm.adt.aliases.StringMapUInt;

public class LineTableInfo
implements Destructors.ClassWithDestructor {
    private StringMapUInt FilenameIDs = new StringMapUInt(0);
    private std.vector<StringMapEntryUInt> FilenamesByID = new std.vector((Object)null);
    private std.mapIntType<std.vector<LineEntry>> LineEntries = new std.mapIntType((Object)new std.vector((Object)new LineEntry()));

    public void clear() {
        this.FilenameIDs.clear();
        this.FilenamesByID.clear();
        this.LineEntries.clear();
    }

    public void $destroy() {
        this.LineEntries.$destroy();
        this.FilenamesByID.$destroy();
        this.FilenameIDs.$destroy();
    }

    public int getLineTableFilenameID(StringRef Name) {
        StringMapEntryUInt Entry2 = this.FilenameIDs.GetOrCreateValue(Name, -1);
        if (Entry2.getValue() != -1) {
            return Entry2.getValue();
        }
        Entry2.setValue(this.FilenamesByID.size());
        this.FilenamesByID.push_back((Object)Entry2);
        return this.FilenamesByID.size() - 1;
    }

    public char.ptr getFilename(int ID2) {
        assert (ID2 < this.FilenamesByID.size()) : "Invalid FilenameID";
        return ((StringMapEntryUInt)this.FilenamesByID.$at(ID2)).getKeyData();
    }

    public int getNumFilenames() {
        return this.FilenamesByID.size();
    }

    public void AddLineNote(FileID FID, int Offset, int LineNo, int FilenameID) {
        this.AddLineNote(FID.ID, Offset, LineNo, FilenameID);
    }

    public void AddLineNote(int FID, int Offset, int LineNo, int FilenameID) {
        std.vector Entries = (std.vector)this.LineEntries.$at(Integer.valueOf(FID));
        assert (Entries.empty() || ((LineEntry)Entries.back()).FileOffset < Offset) : "Adding line entries out of order!";
        SrcMgr.CharacteristicKind Kind2 = SrcMgr.CharacteristicKind.C_User;
        int IncludeOffset = 0;
        if (!Entries.empty()) {
            if (FilenameID == -1) {
                FilenameID = ((LineEntry)Entries.back()).FilenameID;
            }
            Kind2 = ((LineEntry)Entries.back()).FileKind;
            IncludeOffset = ((LineEntry)Entries.back()).IncludeOffset;
        }
        Entries.push_back((Object)LineEntry.get(Offset, LineNo, FilenameID, Kind2, IncludeOffset));
    }

    public void AddLineNote(FileID FID, int Offset, int LineNo, int FilenameID, int EntryExit, SrcMgr.CharacteristicKind FileKind) {
        this.AddLineNote(FID.ID, Offset, LineNo, FilenameID, EntryExit, FileKind);
    }

    public void AddLineNote(int FID, int Offset, int LineNo, int FilenameID, int EntryExit, SrcMgr.CharacteristicKind FileKind) {
        assert (FilenameID != -1) : "Unspecified filename should use other accessor";
        std.vector Entries = (std.vector)this.LineEntries.$at(Integer.valueOf(FID));
        assert (Entries.empty() || ((LineEntry)Entries.back()).FileOffset < Offset) : "Adding line entries out of order!";
        int IncludeOffset = 0;
        if (EntryExit == 0) {
            IncludeOffset = Entries.empty() ? 0 : ((LineEntry)Entries.back()).IncludeOffset;
        } else if (EntryExit == 1) {
            IncludeOffset = Offset - 1;
        } else if (EntryExit == 2) {
            assert (!Entries.empty() && ((LineEntry)Entries.back()).IncludeOffset != 0) : "PPDirectives should have caught case when popping empty include stack";
            IncludeOffset = 0;
            LineEntry PrevEntry = this.FindNearestLineEntry(FID, ((LineEntry)Entries.back()).IncludeOffset);
            if (PrevEntry != null) {
                IncludeOffset = PrevEntry.IncludeOffset;
            }
        }
        Entries.push_back((Object)LineEntry.get(Offset, LineNo, FilenameID, FileKind, IncludeOffset));
    }

    public LineEntry FindNearestLineEntry(FileID FID, int Offset) {
        return this.FindNearestLineEntry(FID.ID, Offset);
    }

    public LineEntry FindNearestLineEntry(int FID, int Offset) {
        std.vector Entries = (std.vector)this.LineEntries.$at(Integer.valueOf(FID));
        assert (!Entries.empty()) : "No #line entries for this FID after all!";
        if (((LineEntry)Entries.back()).FileOffset <= Offset) {
            return (LineEntry)Entries.back();
        }
        StdVector.iterator I = (StdVector.iterator)std.upper_bound((type.iterator)Entries.begin(), (type.iterator)Entries.end(), (Object)Offset);
        if (std.$eq___normal_iterator((StdVector.iterator)I, (StdVector.iterator)Entries.begin())) {
            return null;
        }
        return (LineEntry)I.$preDec().$star();
    }

    public StdMapIntType.iterator<std.vector<LineEntry>> begin() {
        return this.LineEntries.begin();
    }

    public StdMapIntType.iterator<std.vector<LineEntry>> end() {
        return this.LineEntries.end();
    }

    public void AddEntry(FileID FID, std.vector<LineEntry> Entries) {
        this.AddEntry(FID.ID, Entries);
    }

    public void AddEntry(int FID, std.vector<LineEntry> Entries) {
        ((std.vector)this.LineEntries.$at(Integer.valueOf(FID))).$assign(Entries);
    }
}

