/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.vfs.File;
import org.clang.basic.vfs.Status;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.sys.Process;
import org.llvm.support.sys.TimeValue;
import org.llvm.support.sys.fs;

public class RealFile
extends File
implements Destructors.ClassWithDestructor {
    private int FD;
    private Status S;
    private std.string RealName;

    RealFile(int FD, StringRef NewName, StringRef NewRealPathName) {
        this.FD = FD;
        this.S = new Status(NewName, new fs.UniqueID(), new TimeValue(), 0, 0, 0L, fs.file_type.status_error, 0);
        this.RealName = NewRealPathName.str();
        assert (FD >= 0) : "Invalid or inactive file descriptor";
    }

    @Override
    public void $destroy() {
        this.close();
        this.RealName.$destroy();
        this.S.$destroy();
        super.$destroy();
    }

    @Override
    public ErrorOr<Status> status() {
        assert (this.FD != -1) : "cannot stat closed file";
        if (!this.S.isStatusKnown()) {
            fs.file_status RealStatus = new fs.file_status();
            std_errors.error_code EC = fs.status((int)this.FD, (fs.file_status)RealStatus);
            if (EC.$bool()) {
                return new ErrorOr(new std_errors.error_code(EC));
            }
            this.S.$assignMove(Status.copyWithNewName(RealStatus, this.S.getName()));
        }
        return new ErrorOr(JavaDifferentiators.JD$Convertible.INSTANCE, (Object)this.S);
    }

    @Override
    public ErrorOr<std.string> getName() {
        return new ErrorOr(JavaDifferentiators.JD$Convertible.INSTANCE, (Object)(this.RealName.empty() ? this.S.getName().str() : new std.string(this.RealName)));
    }

    @Override
    public ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> getBuffer(Twine Name, long FileSize, boolean RequiresNullTerminator, boolean IsVolatile) {
        assert (this.FD != -1) : "cannot get buffer for closed file";
        return MemoryBuffer.getOpenFile((int)this.FD, (Twine)Name, (long)FileSize, (boolean)RequiresNullTerminator, (boolean)IsVolatile);
    }

    @Override
    public std_errors.error_code close() {
        std_errors.error_code EC = Process.SafelyCloseFileDescriptor((int)this.FD);
        this.FD = -1;
        return EC;
    }

    @Override
    public String toString() {
        return "FD=" + this.FD + ", S=" + this.S + ", RealName=" + this.RealName + super.toString();
    }
}

