/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.impl.structure.APTBaseNode;
import org.netbeans.modules.cnd.apt.impl.structure.APTNodeBuilder;
import org.netbeans.modules.cnd.apt.impl.structure.APTTokenBasedNode;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTTokenAbstact;
import org.netbeans.modules.cnd.apt.support.APTTokenStream;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.apt.utils.ListBasedTokenStream;
import org.netbeans.modules.cnd.apt.utils.TokenBasedTokenStream;
import org.netbeans.modules.cnd.utils.CndPathUtilities;

public abstract class APTIncludeBaseNode
extends APTTokenBasedNode
implements APTNodeBuilder,
Serializable {
    private static final long serialVersionUID = -2311241687965334550L;
    private APTToken includeFileToken = EMPTY_INCLUDE;
    private int endOffset = 0;
    private static final MultiTokenInclude EMPTY_INCLUDE = new MultiTokenInclude(null);

    APTIncludeBaseNode(APTIncludeBaseNode orig) {
        super(orig);
        this.includeFileToken = orig.includeFileToken;
    }

    protected APTIncludeBaseNode() {
    }

    protected APTIncludeBaseNode(APTToken token) {
        super(token);
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public APT getFirstChild() {
        return null;
    }

    @Override
    public void setFirstChild(APT child) {
        assert (false) : "include doesn't support children";
    }

    @Override
    public boolean accept(APTFile curFile, APTToken token) {
        int ttype = token.getType();
        if (APTUtils.isEndDirectiveToken(ttype)) {
            this.endOffset = token.getOffset();
            return false;
        }
        switch (ttype) {
            case 93: 
            case 94: {
                if (this.includeFileToken == EMPTY_INCLUDE) {
                    this.includeFileToken = token;
                    break;
                }
                ((MultiTokenInclude)this.includeFileToken).addToken(token);
                break;
            }
            case 488: 
            case 495: 
            case 496: {
                break;
            }
            default: {
                if (this.includeFileToken == EMPTY_INCLUDE) {
                    this.includeFileToken = new MultiTokenInclude(token);
                    break;
                }
                if (this.isSimpleIncludeToken()) {
                    this.includeFileToken = new MultiTokenInclude(this.includeFileToken);
                }
                ((MultiTokenInclude)this.includeFileToken).addToken(token);
            }
        }
        return true;
    }

    @Override
    public APTBaseNode getNode() {
        return this;
    }

    @Override
    public String getText() {
        String ret = super.getText();
        ret = this.isSimpleIncludeToken() ? ret + " INCLUDE{" + (this.isSystem(null) ? "<S> " : "<U> ") + this.getInclude() + "}" : (this.includeFileToken == EMPTY_INCLUDE ? ret + " INCLUDE{ **EMPTY** }" : ret + " INCLUDE{ <M> " + this.getInclude() + "}");
        return ret;
    }

    public TokenStream getInclude() {
        if (this.isSimpleIncludeToken()) {
            return new TokenBasedTokenStream(this.includeFileToken);
        }
        if (this.includeFileToken == EMPTY_INCLUDE) {
            return APTUtils.EMPTY_STREAM;
        }
        return new ListBasedTokenStream(((MultiTokenInclude)this.includeFileToken).getTokenList());
    }

    public String getFileName(APTMacroCallback callback) {
        String out;
        block2: {
            CharSequence file;
            block3: {
                file = this.getIncludeString(callback);
                out = "";
                if (file == null || file.length() <= 2) break block2;
                if (file.charAt(0) != '<') break block3;
                for (int i = 2; i < file.length(); ++i) {
                    if (file.charAt(i) != '>') continue;
                    out = file.subSequence(1, i).toString();
                    break block2;
                }
                break block2;
            }
            if (file.charAt(0) != '\"') break block2;
            for (int i = 2; i < file.length(); ++i) {
                if (file.charAt(i) != '\"') continue;
                out = file.subSequence(1, i).toString();
                break;
            }
        }
        return CndPathUtilities.normalizeUnixPath((String)out);
    }

    public boolean isSystem(APTMacroCallback callback) {
        CharSequence file = this.getIncludeString(callback);
        return file.length() > 0 ? file.charAt(0) == '<' : false;
    }

    private CharSequence getIncludeString(APTMacroCallback callback) {
        assert (this.includeFileToken != null);
        CharSequence file = !this.isSimpleIncludeToken() ? APTIncludeBaseNode.stringize(((MultiTokenInclude)this.includeFileToken).getTokenList(), callback) : this.includeFileToken.getTextID();
        return file;
    }

    private boolean isSimpleIncludeToken() {
        assert (this.includeFileToken != null);
        return this.includeFileToken.getType() == 93 || this.includeFileToken.getType() == 94;
    }

    private static CharSequence stringize(List<APTToken> tokens, APTMacroCallback callback) {
        APTTokenStream expanded = callback != null ? new APTExpandedStream(new ListBasedTokenStream(tokens), callback) : new ListBasedTokenStream(tokens);
        return APTUtils.stringize(expanded, true);
    }

    private static final class MultiTokenInclude
    extends APTTokenAbstact {
        private final List<APTToken> origTokens;

        public MultiTokenInclude(APTToken token) {
            if (token != null) {
                this.origTokens = new ArrayList<APTToken>(1);
                this.origTokens.add(token);
            } else {
                this.origTokens = Collections.emptyList();
            }
        }

        public void addToken(APTToken token) {
            assert (this.origTokens != null);
            this.origTokens.add(token);
        }

        @Override
        public String getText() {
            if (this.origTokens.size() > 0) {
                return APTIncludeBaseNode.stringize(this.getTokenList(), null).toString();
            }
            return "{no include information}";
        }

        public List<APTToken> getTokenList() {
            return this.origTokens;
        }
    }
}

