/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTMacroCache;
import org.netbeans.modules.cnd.apt.impl.support.APTSystemMacroMap;
import org.netbeans.modules.cnd.apt.impl.support.SnapshotHolderCache;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankSystemMacroMap;
import org.netbeans.modules.cnd.apt.support.APTIncludePathStorage;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.api.PPMacroMap;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public final class APTSystemStorage {
    private final Map<String, PPMacroMap> allMacroMaps = new HashMap<String, PPMacroMap>();
    private final APTIncludePathStorage includesStorage = new APTIncludePathStorage();
    private static final String baseNewName = "#SYSTEM MACRO MAP# ";
    private static final APTSystemStorage instance = new APTSystemStorage();

    private APTSystemStorage() {
    }

    public static APTSystemStorage getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PPMacroMap getMacroMap(String configID, List<String> sysMacros) {
        Map<String, PPMacroMap> map = this.allMacroMaps;
        synchronized (map) {
            PPMacroMap map2 = this.allMacroMaps.get(configID);
            if (map2 == null) {
                map2 = APTTraceFlags.USE_CLANK ? new ClankSystemMacroMap(sysMacros) : new APTSystemMacroMap(sysMacros);
                this.allMacroMaps.put(configID, map2);
                if (APTUtils.LOG.isLoggable(Level.FINE)) {
                    APTUtils.LOG.log(Level.FINE, "new system macro map was added\n {0}", new Object[]{map2});
                }
            }
            return map2;
        }
    }

    public List<IncludeDirEntry> getIncludes(CharSequence configID, List<IncludePath> sysIncludes) {
        return this.includesStorage.get(configID, sysIncludes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeImpl() {
        Map<String, PPMacroMap> map = this.allMacroMaps;
        synchronized (map) {
            this.allMacroMaps.clear();
        }
        this.includesStorage.dispose();
    }

    public static void dispose() {
        instance.disposeImpl();
        APTMacroCache.getManager().dispose();
        SnapshotHolderCache.getManager().dispose();
        IncludeDirEntry.disposeCache();
    }
}

