/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.completion;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.FieldSignature;
import org.netbeans.modules.groovy.editor.api.completion.MethodSignature;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionContext;
import org.netbeans.modules.groovy.editor.api.completion.util.ContextHelper;
import org.netbeans.modules.groovy.editor.spi.completion.CompletionProvider;
import org.openide.filesystems.FileObject;

public class DomainCompletionProvider
implements CompletionProvider {
    private static final Logger LOGGER = Logger.getLogger(DomainCompletionProvider.class.getName());
    private static final Map<MethodSignature, String> INSTANCE_METHODS = new HashMap<MethodSignature, String>();
    private static final Map<MethodSignature, String> STATIC_METHODS = new HashMap<MethodSignature, String>();
    private static final String[] NO_PARAMETERS = new String[0];
    private static final String FIND_BY_METHOD = "findBy";
    private static final String FIND_ALL_BY_METHOD = "findAllBy";
    private static final String COUNT_BY_METHOD = "countBy";
    private static final String LIST_ORDER_BY_METHOD = "listOrderBy";
    private static final Set<String> QUERY_OPERATOR = new HashSet<String>();
    private static final Set<String> QUERY_COMPARATOR = new HashSet<String>();

    public Map<FieldSignature, CompletionItem> getFields(CompletionContext context) {
        return Collections.emptyMap();
    }

    public Map<FieldSignature, CompletionItem> getStaticFields(CompletionContext context) {
        return Collections.emptyMap();
    }

    public Map<MethodSignature, CompletionItem> getMethods(CompletionContext context) {
        HashMap<MethodSignature, CompletionItem> result = new HashMap<MethodSignature, CompletionItem>();
        if (this.isInDomain(context)) {
            result.putAll(this.getQueryMethods(context));
            result.putAll(this.getOrderMethods(context));
            for (Map.Entry<MethodSignature, String> entry : INSTANCE_METHODS.entrySet()) {
                result.put(entry.getKey(), CompletionItem.forDynamicMethod((int)context.getAnchor(), (String)entry.getKey().getName(), (String[])entry.getKey().getParameters(), (String)entry.getValue(), (boolean)false));
            }
        }
        return result;
    }

    public Map<MethodSignature, CompletionItem> getStaticMethods(CompletionContext context) {
        HashMap<MethodSignature, CompletionItem> result = new HashMap<MethodSignature, CompletionItem>();
        if (this.isInDomain(context)) {
            for (Map.Entry<MethodSignature, String> entry : STATIC_METHODS.entrySet()) {
                result.put(entry.getKey(), CompletionItem.forDynamicMethod((int)context.getAnchor(), (String)entry.getKey().getName(), (String[])entry.getKey().getParameters(), (String)entry.getValue(), (boolean)false));
            }
        }
        return result;
    }

    Map<MethodSignature, CompletionItem> getOrderMethods(CompletionContext context) {
        HashMap<MethodSignature, CompletionItem> result = new HashMap<MethodSignature, CompletionItem>();
        if (LIST_ORDER_BY_METHOD.startsWith(context.getPrefix()) || context.getPrefix().startsWith(LIST_ORDER_BY_METHOD)) {
            for (String property : ContextHelper.getProperties((CompletionContext)context)) {
                String name = LIST_ORDER_BY_METHOD + this.capitalise(property);
                result.put(new MethodSignature(name, NO_PARAMETERS), CompletionItem.forDynamicMethod((int)context.getAnchor(), (String)name, (String[])NO_PARAMETERS, (String)"java.util.List", (boolean)false));
                result.put(new MethodSignature(name, new String[]{"java.util.Map"}), CompletionItem.forDynamicMethod((int)context.getAnchor(), (String)name, (String[])new String[]{"java.util.Map"}, (String)"java.util.List", (boolean)false));
            }
        }
        return result;
    }

    Map<MethodSignature, CompletionItem> getQueryMethods(CompletionContext context) {
        List properties = ContextHelper.getProperties((CompletionContext)context);
        if (properties.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<MethodSignature, CompletionItem> result = new HashMap<MethodSignature, CompletionItem>();
        Matcher matcher = this.getQueryMethodPattern(properties).matcher(context.getPrefix());
        if (matcher.matches()) {
            boolean noContinuation;
            String prefix = matcher.group(13);
            if (prefix == null) {
                prefix = "";
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                int count = matcher.groupCount();
                for (int i = 1; i <= count; ++i) {
                    LOGGER.log(Level.FINE, "Group {0} {1}", new Object[]{i, matcher.group(i)});
                }
            }
            String name = context.getPrefix().substring(0, context.getPrefix().length() - prefix.length());
            HashMap<String, Integer> names = new HashMap<String, Integer>();
            HashSet<String> forbidden = new HashSet<String>();
            int paramCount = this.getUsedComparators(context, forbidden);
            boolean bl = noContinuation = matcher.group(7) != null && matcher.group(8) != null;
            if (matcher.group(10) != null) {
                if (!noContinuation) {
                    names.putAll(this.getSuffixForOperator(name, properties, prefix, paramCount));
                }
            } else if (matcher.group(9) != null) {
                names.putAll(this.getSuffixForComparator(name, context, prefix, matcher.group(9), forbidden, paramCount));
                if (!noContinuation) {
                    names.putAll(this.getSuffixForOperator(name, properties, prefix, paramCount));
                }
            } else if (matcher.group(7) != null) {
                names.putAll(this.getSuffixForProperty(name, properties, prefix, paramCount));
            } else if (!noContinuation) {
                names.putAll(this.getSuffixForProperty(name, properties, prefix, paramCount));
            }
            for (Map.Entry entry : names.entrySet()) {
                this.addQueryEntries(result, context, matcher.group(1), ((String)entry.getKey()).substring(matcher.group(1).length()), (Integer)entry.getValue(), !noContinuation);
            }
            if ("".equals(prefix) && !matcher.group(1).equals(context.getPrefix())) {
                this.addQueryEntries(result, context, matcher.group(1), name.substring(matcher.group(1).length()), paramCount, false);
            }
        }
        if (!matcher.matches() || context.getPrefix().equals(matcher.group(1))) {
            for (String property : properties) {
                String tail = this.capitalise(property);
                this.addQueryEntries(result, context, FIND_ALL_BY_METHOD, tail, 1, true);
                this.addQueryEntries(result, context, FIND_BY_METHOD, tail, 1, true);
                this.addQueryEntries(result, context, COUNT_BY_METHOD, tail, 1, true);
            }
        }
        return result;
    }

    private Map<String, Integer> getSuffixForOperator(String prefix, List<String> properties, String tail, int paramCount) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String property : properties) {
            for (String operator : QUERY_OPERATOR) {
                String suffix = operator + this.capitalise(property);
                if (!suffix.startsWith(tail)) continue;
                result.put(prefix + suffix, paramCount + 1);
            }
        }
        return result;
    }

    private Map<String, Integer> getSuffixForComparator(String prefix, CompletionContext context, String tail, String property, Set<String> forbidden, int paramCount) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String operator : QUERY_COMPARATOR) {
            int realCount = paramCount;
            String suffix = operator;
            if (!suffix.startsWith(tail) || forbidden.contains(property + suffix)) continue;
            if ("Between".equals(operator)) {
                ++realCount;
            } else if ("IsNotNull".equals(operator) || "IsNull".equals(operator)) {
                --realCount;
            }
            result.put(prefix + suffix, realCount);
        }
        return result;
    }

    private Map<String, Integer> getSuffixForProperty(String prefix, List<String> properties, String tail, int paramCount) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String property : properties) {
            String suffix = this.capitalise(property);
            if (!suffix.startsWith(tail)) continue;
            result.put(prefix + suffix, paramCount + 1);
        }
        return result;
    }

    private Pattern getQueryMethodPattern(List<String> properties) {
        StringBuilder builder = new StringBuilder("(findBy|findAllBy|countBy)");
        builder.append("(");
        StringBuilder propertyBuilder = new StringBuilder();
        propertyBuilder.append("(");
        for (String property : properties) {
            propertyBuilder.append(Pattern.quote(this.capitalise(property)));
            propertyBuilder.append('|');
        }
        propertyBuilder.setLength(propertyBuilder.length() - 1);
        propertyBuilder.append(")");
        builder.append((CharSequence)propertyBuilder);
        builder.append("(LessThan(Equals)?|GreaterThan(Equals)?|Like|ILike|Equal|NotEqual|Between|IsNotNull|IsNull)?");
        builder.append("(And|Or)");
        builder.append(")?");
        builder.append("(");
        builder.append((CharSequence)propertyBuilder);
        builder.append("(LessThan(Equals)?|GreaterThan(Equals)?|Like|ILike|Equal|NotEqual|Between|IsNotNull|IsNull)?");
        builder.append(")?");
        builder.append("(.*)");
        LOGGER.log(Level.FINE, "Method pattern is {0}", builder.toString());
        return Pattern.compile(builder.toString());
    }

    private int getUsedComparators(CompletionContext context, Set<String> result) {
        Matcher matcher = Pattern.compile("(findBy|findAllBy|countBy)(.*)").matcher(context.getPrefix());
        if (!matcher.matches()) {
            return 0;
        }
        String[] parts = matcher.group(2).split("(And|Or)");
        int paramCount = 0;
        Pattern pattern = Pattern.compile("(.*)(LessThan(Equals)?|GreaterThan(Equals)?|Like|ILike|Equal|NotEqual|Between|IsNotNull|IsNull)?");
        for (String part : parts) {
            Matcher singleMatcher = pattern.matcher(part);
            if (!singleMatcher.matches()) continue;
            String comparator = singleMatcher.group(2);
            if ("Between".equals(comparator)) {
                paramCount += 2;
                continue;
            }
            if (!"IsNotNull".equals(comparator) && !"IsNull".equals(comparator)) {
                ++paramCount;
                continue;
            }
            if (comparator != null) continue;
            ++paramCount;
        }
        return paramCount;
    }

    private void addQueryEntries(Map<MethodSignature, CompletionItem> result, CompletionContext context, String prefix, String tail, int params, boolean prefixedMethod) {
        String returnType = "java.lang.Object";
        if (FIND_ALL_BY_METHOD.equals(prefix)) {
            returnType = "java.util.List";
        } else if (COUNT_BY_METHOD.equals(prefix)) {
            returnType = "int";
        }
        String name = prefix + tail;
        Object[] shortParams = new String[params];
        Arrays.fill(shortParams, "java.lang.Object");
        result.put(new MethodSignature(name, (String[])shortParams), CompletionItem.forDynamicMethod((int)context.getAnchor(), (String)name, (String[])shortParams, (String)returnType, (boolean)false));
        Object[] longParams = new String[params + 1];
        Arrays.fill(longParams, "java.lang.Object");
        longParams[params] = "java.util.Map";
        result.put(new MethodSignature(name, (String[])longParams), CompletionItem.forDynamicMethod((int)context.getAnchor(), (String)name, (String[])longParams, (String)returnType, (boolean)false));
        if (prefixedMethod) {
            result.put(new MethodSignature(name + "_", new String[0]), CompletionItem.forDynamicMethod((int)context.getAnchor(), (String)name, (String[])new String[0], (String)returnType, (boolean)true));
        }
    }

    private boolean isInDomain(CompletionContext context) {
        if (context.getSourceFile() == null || context.getTypeName() == null) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)context.getSourceFile());
        if (project == null) {
            return false;
        }
        FileObject grailsDir = project.getProjectDirectory().getFileObject("grails-app");
        if (grailsDir == null || !grailsDir.isFolder()) {
            return false;
        }
        String typeName = context.getTypeName().replace('.', '/');
        FileObject fo = grailsDir.getFileObject("domain/" + typeName + ".groovy");
        return fo != null && fo.isData();
    }

    private String capitalise(String property) {
        String[] parts;
        StringBuilder builder = new StringBuilder();
        for (String part : parts = property.split("[^\\w\\d]")) {
            builder.append(part.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(part.substring(1));
        }
        return builder.toString();
    }

    static {
        Collections.addAll(QUERY_OPERATOR, "And", "Or");
        Collections.addAll(QUERY_COMPARATOR, "LessThan", "LessThanEquals", "GreaterThan", "GreaterThanEquals", "Like", "ILike", "Equal", "NotEqual", "Between", "IsNotNull", "IsNull");
        INSTANCE_METHODS.put(new MethodSignature("attach", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("clearErrors", NO_PARAMETERS), "org.springframework.validation.Errors");
        INSTANCE_METHODS.put(new MethodSignature("delete", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("delete", new String[]{"java.util.Map"}), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("discard", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("hasErrors", NO_PARAMETERS), "java.lang.Boolean");
        INSTANCE_METHODS.put(new MethodSignature("ident", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("lock", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("merge", new String[]{"java.lang.Object"}), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("merge", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("refresh", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("save", new String[]{"java.lang.Boolean"}), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("save", new String[]{"java.util.Map"}), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("save", NO_PARAMETERS), "java.lang.Object");
        INSTANCE_METHODS.put(new MethodSignature("validate", NO_PARAMETERS), "java.lang.Boolean");
        INSTANCE_METHODS.put(new MethodSignature("isAttached", NO_PARAMETERS), "java.lang.Boolean");
        STATIC_METHODS.put(new MethodSignature("count", NO_PARAMETERS), "int");
        STATIC_METHODS.put(new MethodSignature("createCriteria", NO_PARAMETERS), "grails.orm.HibernateCriteriaBuilder");
        STATIC_METHODS.put(new MethodSignature("executeQuery", new String[]{"java.lang.String"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("executeQuery", new String[]{"java.lang.String", "java.util.Collection"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("executeQuery", new String[]{"java.lang.String", "java.util.Collection", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("executeQuery", new String[]{"java.lang.String", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("executeQuery", new String[]{"java.lang.String", "java.util.Map", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("executeUpdate", new String[]{"java.lang.String"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("executeUpdate", new String[]{"java.lang.String", "java.util.Collection"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("exists", NO_PARAMETERS), "java.lang.Boolean");
        STATIC_METHODS.put(new MethodSignature("find", new String[]{"java.lang.String"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("find", new String[]{"java.lang.String", "java.util.Collection"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("find", new String[]{"java.lang.String", "java.util.Map"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("find", new String[]{"java.lang.Object"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("findAll", NO_PARAMETERS), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.String"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.String", "java.util.Collection"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.String", "java.util.Collection", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.String", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.String", "java.util.Map", "java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findAll", new String[]{"java.lang.Object"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("findWhere", new String[]{"java.util.Map"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("findAllWhere", new String[]{"java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("get", new String[]{"java.lang.Object"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("getAll", NO_PARAMETERS), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("getAll", new String[]{"java.util.List"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("list", NO_PARAMETERS), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("list", new String[]{"java.util.Map"}), "java.util.List");
        STATIC_METHODS.put(new MethodSignature("withCriteria", new String[]{"groovy.lang.Closure"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("withCriteria", new String[]{"java.util.Map", "groovy.lang.Closure"}), "java.lang.Object");
        STATIC_METHODS.put(new MethodSignature("withTransaction", new String[]{"groovy.lang.Closure"}), "java.lang.Object");
    }
}

