/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;

public class JHIndexer
extends MatchingTask {
    private Path classpath;
    private File db;
    private File basedir;
    private String locale;
    private List<BrandedFileSet> brandings = new LinkedList<BrandedFileSet>();

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setDb(File db) {
        this.db = db;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void addBrandedFileSet(BrandedFileSet s) {
        this.brandings.add(s);
    }

    @Deprecated
    public void setJhall(File f) {
        this.log("The 'jhall' attribute to <jhindexer> is deprecated. Use a nested <classpath> instead.", 1);
        this.createClasspath().setLocation(f);
    }

    public void setClassPath(Path cp) {
        this.classpath = cp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        if (this.classpath == null) {
            throw new BuildException("Must specify the classpath attribute to find jhall.jar or jsearch.jar");
        }
        if (this.db == null) {
            throw new BuildException("Must specify the db attribute");
        }
        if (this.basedir == null) {
            throw new BuildException("Must specify the basedir attribute");
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.basedir);
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        if (this.basedir.exists() && this.db.exists()) {
            long lastModified = Long.MIN_VALUE;
            DirectoryScanner output = new DirectoryScanner();
            output.setBasedir(this.db);
            output.scan();
            String[] outfiles = output.getIncludedFiles();
            if (outfiles.length > 0) {
                for (int i = 0; i < outfiles.length; ++i) {
                    long mod = new File(this.db, outfiles[i]).lastModified();
                    if (mod <= lastModified) continue;
                    lastModified = mod;
                }
                boolean ok = true;
                for (int i = 0; i < files.length; ++i) {
                    long l = new File(this.basedir, files[i]).lastModified();
                    if (l <= lastModified) continue;
                    ok = false;
                    break;
                }
                if (!this.brandings.isEmpty()) {
                    block13: for (FileSet fileSet : this.brandings) {
                        DirectoryScanner scanner2 = fileSet.getDirectoryScanner(this.getProject());
                        String[] files2 = scanner2.getIncludedFiles();
                        for (int i = 0; i < files2.length; ++i) {
                            long mod = new File(this.basedir, files2[i]).lastModified();
                            if (mod <= lastModified) continue;
                            ok = false;
                            continue block13;
                        }
                    }
                }
                if (ok) {
                    return;
                }
            }
        }
        Delete delete = (Delete)this.getProject().createTask("delete");
        delete.setDir(this.db);
        delete.init();
        delete.setLocation(this.getLocation());
        delete.execute();
        Mkdir mkdir = (Mkdir)this.getProject().createTask("mkdir");
        mkdir.setDir(this.db);
        mkdir.init();
        mkdir.setLocation(this.getLocation());
        mkdir.execute();
        String maxbranding = null;
        if (!this.brandings.isEmpty()) {
            File tmp = new File(System.getProperty("java.io.tmpdir"), "jhindexer-branding-merge");
            delete = (Delete)this.getProject().createTask("delete");
            delete.setDir(tmp);
            delete.init();
            delete.setLocation(this.getLocation());
            delete.execute();
            tmp.mkdir();
            Copy copy = (Copy)this.getProject().createTask("copy");
            copy.setTodir(tmp);
            copy.addFileset(this.fileset);
            copy.init();
            copy.setLocation(this.getLocation());
            copy.execute();
            class BrandingLengthComparator
            implements Comparator<BrandedFileSet> {
                BrandingLengthComparator() {
                }

                @Override
                public int compare(BrandedFileSet a, BrandedFileSet b) {
                    return a.branding.length() - b.branding.length();
                }
            }
            Collections.sort(this.brandings, new BrandingLengthComparator());
            for (BrandedFileSet brandedFileSet : this.brandings) {
                if (maxbranding != null && !brandedFileSet.branding.startsWith(maxbranding + "_")) {
                    throw new BuildException("Illegal branding: " + brandedFileSet.branding, this.getLocation());
                }
                maxbranding = brandedFileSet.branding;
                String[] suffixes = new String[]{".html", ".htm", ".xhtml"};
                for (int i = 0; i < suffixes.length; ++i) {
                    String suffix = suffixes[i];
                    copy = (Copy)this.getProject().createTask("copy");
                    copy.setTodir(tmp);
                    copy.setOverwrite(true);
                    copy.addFileset((FileSet)brandedFileSet);
                    Mapper m = copy.createMapper();
                    Mapper.MapperType mt = new Mapper.MapperType();
                    mt.setValue("glob");
                    m.setType(mt);
                    m.setFrom("*_" + brandedFileSet.branding + suffix);
                    m.setTo("*" + suffix);
                    copy.init();
                    copy.setLocation(this.getLocation());
                    copy.execute();
                    if (this.locale == null) continue;
                    suffix = "_" + this.locale + suffix;
                    copy = (Copy)this.getProject().createTask("copy");
                    copy.setTodir(tmp);
                    copy.setOverwrite(true);
                    copy.addFileset((FileSet)brandedFileSet);
                    m = copy.createMapper();
                    mt = new Mapper.MapperType();
                    mt.setValue("glob");
                    m.setType(mt);
                    m.setFrom("*_" + brandedFileSet.branding + suffix);
                    m.setTo("*" + suffix);
                    copy.init();
                    copy.setLocation(this.getLocation());
                    copy.execute();
                }
            }
            this.basedir = tmp;
            FileSet tmpf = new FileSet();
            tmpf.setProject(this.getProject());
            tmpf.setDir(tmp);
            files = tmpf.getDirectoryScanner(this.getProject()).getIncludedFiles();
        }
        this.log("Running JavaHelp search database indexer...");
        try {
            File config = File.createTempFile("jhindexer-config", ".txt");
            try {
                try (FileOutputStream os = new FileOutputStream(config);){
                    void var9_21;
                    PrintWriter pw = new PrintWriter(os);
                    pw.println("IndexRemove " + this.basedir + File.separator);
                    String string = "Files to be indexed:";
                    for (int i = 0; i < files.length; ++i) {
                        String path = this.basedir + File.separator + files[i];
                        pw.println("File " + path);
                        String string2 = (String)var9_21 + "\n\t" + path;
                    }
                    this.log((String)var9_21, 3);
                    pw.flush();
                }
                AntClassLoader loader = new AntClassLoader(this.getProject(), this.classpath);
                loader.addLoaderPackageRoot("com.sun.java.help.search");
                try {
                    Class clazz = loader.loadClass("com.sun.java.help.search.Indexer");
                    Method main = clazz.getMethod("main", String[].class);
                    List<String> args = Arrays.asList("-c", config.getAbsolutePath(), "-db", this.db.getAbsolutePath());
                    if (this.locale != null) {
                        args = new ArrayList<String>(args);
                        args.add("-locale");
                        args.add(this.locale);
                    }
                    main.invoke(null, new Object[]{args.toArray(new String[args.size()])});
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new BuildException(invocationTargetException.getTargetException(), this.getLocation());
                }
                catch (Exception exception) {
                    throw new BuildException((Throwable)exception, this.getLocation());
                }
            }
            finally {
                config.delete();
            }
        }
        catch (IOException ioe) {
            throw new BuildException("Could not make temporary config file", (Throwable)ioe, this.getLocation());
        }
        if (maxbranding != null) {
            String[] dbfiles = this.db.list();
            for (int i = 0; i < dbfiles.length; ++i) {
                void var9_29;
                String basename;
                int idx = dbfiles[i].lastIndexOf(46);
                if (idx != -1) {
                    basename = dbfiles[i].substring(0, idx);
                    String string = dbfiles[i].substring(idx);
                } else {
                    basename = dbfiles[i];
                    String string = "";
                }
                File old = new File(this.db, dbfiles[i]);
                File nue = new File(this.db, basename + "_" + maxbranding + (String)var9_29);
                this.log("Moving " + old + " to " + nue, 3);
                old.renameTo(nue);
            }
        }
    }

    public static final class BrandedFileSet
    extends FileSet {
        String branding;

        public void setBranding(String b) {
            this.branding = b;
        }
    }
}

