/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild.extlibs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class DownloadBinaries
extends Task {
    private File cache;
    private String server;
    private final List<FileSet> manifests = new ArrayList<FileSet>();
    private boolean clean;

    public void setCache(File cache) {
        this.cache = cache;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void addManifest(FileSet manifest) {
        this.manifests.add(manifest);
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        for (FileSet fs : this.manifests) {
            DirectoryScanner scanner = fs.getDirectoryScanner(this.getProject());
            File basedir = scanner.getBasedir();
            for (String include : scanner.getIncludedFiles()) {
                File manifest = new File(basedir, include);
                this.log("Scanning: " + manifest, 3);
                try (FileInputStream is = new FileInputStream(manifest);){
                    String line;
                    BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                    while ((line = r.readLine()) != null) {
                        if (line.startsWith("#") || line.trim().length() == 0) continue;
                        String[] hashAndFile = line.split(" ", 2);
                        if (hashAndFile.length < 2) {
                            throw new BuildException("Bad line '" + line + "' in " + manifest, this.getLocation());
                        }
                        this.hashedFile(hashAndFile[0], hashAndFile[1], manifest);
                    }
                }
                catch (IOException x) {
                    throw new BuildException("Could not open " + manifest + ": " + x, (Throwable)x, this.getLocation());
                }
            }
        }
    }

    private void mavenFile(String id, String baseName, File manifest) throws BuildException {
        String[] ids = id.split(":");
        if (ids.length != 3) {
            throw new BuildException("Expecting groupId:artifactId:version, but was " + id + " in " + manifest);
        }
        File f = new File(manifest.getParentFile(), baseName);
        if (this.clean || !f.exists()) {
            String cacheName = ids[0].replace('.', '/') + "/" + ids[1] + "/" + ids[2] + "/" + ids[1] + "-" + ids[2] + ".jar";
            File local = new File(new File(new File(new File(System.getProperty("user.home")), ".m2"), "repository"), cacheName.replace('/', File.separatorChar));
            String url = local.exists() ? local.toURI().toString() : "http://central.maven.org/maven2/" + cacheName;
            try {
                URL u = new URL(url);
                this.downloadFromServer(u, cacheName, f, null);
            }
            catch (IOException ex) {
                String msg = "Could not download " + url + " to " + f + ": " + cacheName;
                this.log(msg, 1);
                throw new BuildException((Throwable)ex);
            }
        }
    }

    private void hashedFile(String expectedHash, String baseName, File manifest) throws BuildException {
        File f = new File(manifest.getParentFile(), baseName);
        if (!this.clean) {
            String actualHash;
            if (!f.exists() || !this.hash(f).equals(expectedHash)) {
                this.log("Creating " + f);
                String cacheName = expectedHash + "-" + baseName;
                if (this.cache != null) {
                    this.cache.mkdirs();
                    File cacheFile = new File(this.cache, cacheName);
                    if (!cacheFile.exists()) {
                        this.download(cacheName, cacheFile, expectedHash);
                    }
                    if (f.isFile() && !f.delete()) {
                        throw new BuildException("Could not delete " + f);
                    }
                    try {
                        FileUtils.getFileUtils().copyFile(cacheFile, f);
                    }
                    catch (IOException x) {
                        throw new BuildException("Could not copy " + cacheFile + " to " + f + ": " + x, (Throwable)x, this.getLocation());
                    }
                } else {
                    this.download(cacheName, f, expectedHash);
                }
            }
            if (!(actualHash = this.hash(f)).equals(expectedHash)) {
                throw new BuildException("File " + f + " requested by " + manifest + " to have hash " + expectedHash + " actually had hash " + actualHash, this.getLocation());
            }
            this.log("Have " + f + " with expected hash", 3);
        } else if (f.exists()) {
            String actualHash = this.hash(f);
            if (!actualHash.equals(expectedHash)) {
                throw new BuildException("File " + f + " requested by " + manifest + " to have hash " + expectedHash + " actually had hash " + actualHash, this.getLocation());
            }
            this.log("Deleting " + f);
            f.delete();
        }
    }

    private void download(String cacheName, File destination, String expectedHash) {
        if (this.server == null) {
            throw new BuildException("Must specify a server to download files from", this.getLocation());
        }
        Throwable firstProblem = null;
        for (String prefix : this.server.split(" ")) {
            URL url = null;
            try {
                url = new URL(prefix + cacheName);
                if (!this.downloadFromServer(url, cacheName, destination, expectedHash)) continue;
                return;
            }
            catch (IOException x) {
                String msg = "Could not download " + url + " to " + destination + ": " + x;
                this.log(msg, 1);
                if (firstProblem != null) continue;
                firstProblem = new IOException(msg).initCause(x);
            }
        }
        throw new BuildException("Could not download " + cacheName + " from " + this.server + ": " + firstProblem, firstProblem, this.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadFromServer(URL url, String cacheName, File destination, String expectedHash) throws IOException {
        URLConnection conn = url.openConnection();
        conn.connect();
        int code = 200;
        if (conn instanceof HttpURLConnection) {
            code = ((HttpURLConnection)conn).getResponseCode();
        }
        if (code != 200) {
            this.log("Skipping download from " + url + " due to response code " + code, 3);
            return false;
        }
        this.log("Downloading: " + url);
        try (InputStream is = conn.getInputStream();){
            String actualHash;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                int read;
                byte[] buf = new byte[4096];
                while ((read = is.read(buf)) != -1) {
                    baos.write(buf, 0, read);
                }
            }
            catch (IOException x) {
                throw new BuildException((Throwable)x);
            }
            byte[] data = baos.toByteArray();
            if (expectedHash != null && !expectedHash.equals(actualHash = this.hash(new ByteArrayInputStream(data)))) {
                throw new BuildException("Download of " + url + " produced content with hash " + actualHash + " when " + expectedHash + " was expected", this.getLocation());
            }
            FileOutputStream os = new FileOutputStream(destination);
            try {
                ((OutputStream)os).write(data);
            }
            catch (IOException x) {
                ((OutputStream)os).close();
                destination.delete();
                throw x;
            }
            ((OutputStream)os).close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String hash(File f) {
        String string;
        FileInputStream is = new FileInputStream(f);
        try {
            string = this.hash(is);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException x) {
                throw new BuildException("Could not get hash for " + f + ": " + x, (Throwable)x, this.getLocation());
            }
        }
        is.close();
        return string;
    }

    private String hash(InputStream is) throws IOException {
        int r;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException x) {
            throw new BuildException((Throwable)x, this.getLocation());
        }
        byte[] buf = new byte[4096];
        while ((r = is.read(buf)) != -1) {
            digest.update(buf, 0, r);
        }
        return String.format("%040X", new BigInteger(1, digest.digest()));
    }
}

