/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.overrides;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;
import org.netbeans.modules.cnd.navigation.overrides.BaseAnnotation;
import org.netbeans.modules.cnd.navigation.overrides.InheritAnnotation;
import org.netbeans.modules.cnd.navigation.overrides.OverrideAnnotation;
import org.netbeans.modules.cnd.utils.CndUtils;

public class ComputeAnnotations {
    private final CsmFile csmFile;
    private final StyledDocument doc;
    private final AtomicBoolean canceled;

    public static ComputeAnnotations getInstance(CsmFile csmFile, StyledDocument doc, AtomicBoolean canceled) {
        return new ComputeAnnotations(csmFile, doc, canceled);
    }

    private ComputeAnnotations(CsmFile csmFile, StyledDocument doc, AtomicBoolean canceled) {
        this.csmFile = csmFile;
        this.doc = doc;
        this.canceled = canceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void computeAnnotations(Collection<BaseAnnotation> toAdd) {
        if (this.canceled.get()) {
            return;
        }
        CsmCacheManager.enter();
        try {
            HashMap<Integer, List<CsmOffsetableDeclaration>> external = new HashMap<Integer, List<CsmOffsetableDeclaration>>();
            Iterator externalDeclarations = CsmSelect.getExternalDeclarations((CsmFile)this.csmFile);
            if (externalDeclarations != null) {
                while (externalDeclarations.hasNext()) {
                    CsmOffsetableDeclaration next = (CsmOffsetableDeclaration)externalDeclarations.next();
                    int start = next.getStartOffset();
                    ArrayList<CsmOffsetableDeclaration> list = (ArrayList<CsmOffsetableDeclaration>)external.get(start);
                    if (list == null) {
                        list = new ArrayList<CsmOffsetableDeclaration>();
                        external.put(start, list);
                    }
                    list.add(next);
                }
            }
            this.computeAnnotations(this.csmFile.getDeclarations(), toAdd, external);
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    private void computeAnnotations(Collection<? extends CsmOffsetableDeclaration> toProcess, Collection<BaseAnnotation> toAdd, Map<Integer, List<CsmOffsetableDeclaration>> external) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : toProcess) {
            if (this.canceled.get()) {
                return;
            }
            if (!this.csmFile.equals(csmOffsetableDeclaration.getContainingFile())) continue;
            if (CsmKindUtilities.isFunction((CsmObject)csmOffsetableDeclaration)) {
                this.computeAnnotation((CsmFunction)csmOffsetableDeclaration, toAdd, external);
                continue;
            }
            if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
                if (CsmKindUtilities.isTemplate((CsmObject)csmOffsetableDeclaration) && ((CsmTemplate)csmOffsetableDeclaration).isExplicitSpecialization()) continue;
                this.computeAnnotation((CsmClass)csmOffsetableDeclaration, toAdd);
                this.computeAnnotations(((CsmClass)csmOffsetableDeclaration).getMembers(), toAdd, external);
                continue;
            }
            if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) continue;
            this.computeAnnotations(((CsmNamespaceDefinition)csmOffsetableDeclaration).getDeclarations(), toAdd, external);
        }
    }

    private void computeAnnotation(CsmFunction func, Collection<BaseAnnotation> toAdd, Map<Integer, List<CsmOffsetableDeclaration>> external) {
        CsmMethod meth;
        Collection<Object> baseMethods = Collections.emptyList();
        Collection<Object> overriddenMethods = Collections.emptyList();
        CsmVirtualInfoQuery.CsmOverrideInfo thisMethod = null;
        if (CsmKindUtilities.isMethod((CsmObject)func) && (meth = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)func)) != null) {
            CsmVirtualInfoQuery.CsmOverriddenChain chain = CsmVirtualInfoQuery.getDefault().getOverriddenChain(meth);
            if (!chain.getBaseMethods().isEmpty()) {
                baseMethods = chain.getBaseMethods();
            }
            if (!chain.getDerivedMethods().isEmpty()) {
                overriddenMethods = chain.getDerivedMethods();
            }
            thisMethod = chain.getThisMethod();
            if (BaseAnnotation.LOGGER.isLoggable(Level.FINEST)) {
                BaseAnnotation.LOGGER.log(Level.FINEST, "Found {0} base decls for {1}", new Object[]{baseMethods.size(), ComputeAnnotations.toString(func)});
                for (CsmVirtualInfoQuery.CsmOverrideInfo csmOverrideInfo : baseMethods) {
                    BaseAnnotation.LOGGER.log(Level.FINEST, "    {0}", ComputeAnnotations.toString(csmOverrideInfo.getMethod()));
                }
            }
        }
        if (this.canceled.get()) {
            return;
        }
        Collection baseTemplates = CsmInstantiationProvider.getDefault().getBaseTemplate((CsmDeclaration)func);
        if (this.canceled.get()) {
            return;
        }
        Collection templateSpecializations = CsmInstantiationProvider.getDefault().getSpecializations((CsmDeclaration)func);
        if (this.canceled.get()) {
            return;
        }
        if (this.canceled.get()) {
            return;
        }
        List<CsmOffsetableDeclaration> pseudoOverrides = external.get(func.getStartOffset());
        if (pseudoOverrides != null) {
            for (CsmOffsetableDeclaration e : pseudoOverrides) {
                CsmFunction f;
                CsmFunctionDefinition definition;
                overriddenMethods = new ArrayList<Object>(overriddenMethods);
                if (!CsmKindUtilities.isFunction((CsmObject)e) || (definition = (f = (CsmFunction)e).getDefinition()) == null || definition.equals(f)) continue;
                overriddenMethods.add(new CsmVirtualInfoQuery.CsmOverrideInfo((CsmFunction)definition, false));
            }
        }
        if (!(baseMethods.isEmpty() && overriddenMethods.isEmpty() && baseTemplates.isEmpty() && templateSpecializations.isEmpty())) {
            toAdd.add(new OverrideAnnotation(this.doc, func, thisMethod, baseMethods, overriddenMethods, baseTemplates, templateSpecializations));
        }
    }

    private void computeAnnotation(CsmClass cls, Collection<BaseAnnotation> toAdd) {
        Collection subRefs = CsmTypeHierarchyResolver.getDefault().getSubTypes(cls, false);
        if (this.canceled.get()) {
            return;
        }
        ArrayList<CsmClass> subClasses = new ArrayList<CsmClass>(subRefs.size());
        Collection baseTemplateClasses = CsmInstantiationProvider.getDefault().getBaseTemplate((CsmDeclaration)cls);
        if (this.canceled.get()) {
            return;
        }
        Collection templateSpecializationClasses = CsmInstantiationProvider.getDefault().getSpecializations((CsmDeclaration)cls);
        if (this.canceled.get()) {
            return;
        }
        if (!subRefs.isEmpty()) {
            for (CsmReference ref : subRefs) {
                CsmObject obj = ref.getReferencedObject();
                CndUtils.assertTrue((obj == null || obj instanceof CsmClass ? 1 : 0) != 0, (String)"getClassifier() should return either null or CsmClass");
                if (!(obj instanceof CsmClass)) continue;
                subClasses.add((CsmClass)obj);
            }
        }
        if (!(subClasses.isEmpty() && baseTemplateClasses.isEmpty() && templateSpecializationClasses.isEmpty())) {
            toAdd.add(new InheritAnnotation(this.doc, cls, subClasses, baseTemplateClasses, templateSpecializationClasses));
        }
    }

    private static CharSequence toString(CsmFunction func) {
        StringBuilder sb = new StringBuilder();
        sb.append(func.getClass().getSimpleName());
        sb.append(' ');
        sb.append(func.getQualifiedName());
        sb.append(" [");
        sb.append(func.getContainingFile().getName());
        sb.append(':');
        sb.append(func.getStartPosition().getLine());
        sb.append(']');
        return sb;
    }
}

