/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.jsr172.generator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Properties;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.e2e.api.wsdl.wsdl2java.WSDL2Java;
import org.netbeans.modules.e2e.api.wsdl.wsdl2java.WSDL2JavaFactory;
import org.netbeans.modules.mobility.end2end.E2EDataObject;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.spi.mobility.end2end.ServiceGeneratorResult;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Jsr172Generator {
    public static final String CONFIG_FILE_BODY = "<?xml version=''1.0'' encoding=''UTF-8'' ?>\n\t<configuration xmlns=''http://java.sun.com/xml/ns/jax-rpc/ri/config''>\n\t\t<wsdl location=''{0}'' packageName=''{1}''>\n\t</wsdl>\n</configuration>\n";

    private Jsr172Generator() {
    }

    public static ServiceGeneratorResult generate(E2EDataObject e2EDataObject) {
        boolean generationResult;
        ServiceGeneratorResult result = null;
        ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Jsr172Generator.class, (String)"MSG_GeneratingJsr172"));
        ph.start();
        ph.switchToIndeterminate();
        ClientConfiguration configuration = e2EDataObject.getConfiguration().getClientConfiguration();
        ClassDescriptor cd = configuration.getClassDescriptor();
        WSDLService service = (WSDLService)e2EDataObject.getConfiguration().getServices().get(0);
        String file = service.getFile();
        file = cd.getPackageName().replace('.', '/') + '/' + file;
        Sources sources = (Sources)e2EDataObject.getClientProject().getLookup().lookup(Sources.class);
        SourceGroup sg = sources.getSourceGroups("java")[0];
        FileObject wsdlPosition = sg.getRootFolder().getFileObject(file);
        if (wsdlPosition == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(Jsr172Generator.class, (String)"MSG_file_disapeared", (Object)service.getFile()), 0));
            return null;
        }
        FileObject refFolder = sg.getRootFolder().getFileObject(cd.getPackageName().replace('.', '/'));
        refFolder.getChildren(true);
        File f = FileUtil.toFile((FileObject)wsdlPosition);
        String configFileData = MessageFormat.format(CONFIG_FILE_BODY, f.getAbsolutePath(), cd.getPackageName());
        String wsdlUrl = f.toURI().toString();
        WSDL2Java.Configuration config = new WSDL2Java.Configuration();
        config.setWSDLFileName(wsdlUrl);
        config.setOutputDirectory(FileUtil.toFile((FileObject)sg.getRootFolder()).getAbsolutePath());
        config.setPackageName(cd.getPackageName());
        try {
            config.setOriginalWSDLUrl(new URL(service.getUrl()));
        }
        catch (MalformedURLException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
        WSDL2Java wsdl2java = WSDL2JavaFactory.getWSDL2Java(config);
        Properties properties = configuration.getProperties();
        if (properties.getProperty("DataBinding") != null) {
            config.setGenerateDataBinding(properties.getProperty("DataBinding").equals("true"));
        }
        if (generationResult = wsdl2java.generate()) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Jsr172Generator.class, (String)"MSG_Success"));
            if (config.getGenerateDataBinding()) {
                Util.registerDataBindingLibrary((Project)e2EDataObject.getClientProject());
            }
        } else {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(Jsr172Generator.class, (String)"MSG_Failure"));
        }
        ph.finish();
        return result;
    }
}

