/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.spi.debugger.ui.Controller;

public class EditMaxFramePanel
extends JPanel {
    private JLabel maxFrameLabel = null;
    private JTextField maxFrameText = null;
    private String max_frames;
    private NativeDebugger debugger;
    private final MaxFrameController controller = new MaxFrameController();

    public EditMaxFramePanel(NativeDebugger debugger, String initialMaxFrame) {
        if (initialMaxFrame != null) {
            this.max_frames = initialMaxFrame;
        }
        this.debugger = debugger;
        this.initComponents();
        this.maxFrameText.setText(this.max_frames);
    }

    public Controller getController() {
        return this.controller;
    }

    public void refocus() {
        if (this.maxFrameText != null) {
            this.maxFrameText.requestFocusInWindow();
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.maxFrameLabel = new JLabel(Catalog.get("LBL_max_frames"));
        this.maxFrameLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_MaxFrames"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 10);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.add((Component)this.maxFrameLabel, gbc);
        this.maxFrameText = new JTextField();
        Catalog.setAccessibleDescription(this.maxFrameText, "ACSD_MaxFrames");
        this.maxFrameText.setBorder(new CompoundBorder(this.maxFrameText.getBorder(), new EmptyBorder(2, 0, 2, 0)));
        this.maxFrameText.setColumns(25);
        this.maxFrameText.selectAll();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 0;
        this.add((Component)this.maxFrameText, gbc);
        this.maxFrameLabel.setLabelFor(this.maxFrameText);
        this.maxFrameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditMaxFramePanel.this.controller.validChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditMaxFramePanel.this.controller.validChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditMaxFramePanel.this.controller.validChanged();
            }
        });
        this.refocus();
    }

    public boolean validateFields() {
        String expr = this.maxFrameText.getText();
        return !expr.equals("");
    }

    protected void post() {
        this.debugger.setOption("DBX_stack_max_size", this.maxFrameText.getText());
    }

    private class MaxFrameController
    implements Controller {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        private MaxFrameController() {
        }

        public boolean ok() {
            if (!EditMaxFramePanel.this.validateFields()) {
                return false;
            }
            EditMaxFramePanel.this.post();
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            if (IpeUtils.isEmpty(EditMaxFramePanel.this.maxFrameText.getText())) {
                return false;
            }
            try {
                int i = Integer.parseInt(EditMaxFramePanel.this.maxFrameText.getText());
                if (i < 1) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }

        public final void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public final void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        void validChanged() {
            this.pcs.firePropertyChange("valid", null, null);
        }
    }
}

