/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.framework;

import com.sun.tools.ws.api.wsdl.TWSDLParserContext;
import com.sun.tools.ws.resources.WsdlMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wsdl.framework.AbstractDocument;
import com.sun.tools.ws.wsdl.framework.Entity;
import com.sun.tools.ws.wsdl.framework.ParserListener;
import com.sun.tools.ws.wsdl.framework.WSDLLocation;
import com.sun.tools.ws.wsdl.parser.DOMForest;
import com.sun.xml.ws.util.NamespaceSupport;
import com.sun.xml.ws.util.xml.XmlUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TWSDLParserContextImpl
implements TWSDLParserContext {
    private static final String PREFIX_XMLNS = "xmlns";
    private boolean _followImports;
    private final AbstractDocument _document;
    private final NamespaceSupport _nsSupport;
    private final ArrayList<ParserListener> _listeners;
    private final WSDLLocation _wsdlLocation;
    private final DOMForest forest;
    private final ErrorReceiver errorReceiver;

    public TWSDLParserContextImpl(DOMForest forest, AbstractDocument doc, ArrayList<ParserListener> listeners, ErrorReceiver errReceiver) {
        this._document = doc;
        this._listeners = listeners;
        this._nsSupport = new NamespaceSupport();
        this._wsdlLocation = new WSDLLocation();
        this.forest = forest;
        this.errorReceiver = errReceiver;
    }

    public AbstractDocument getDocument() {
        return this._document;
    }

    public boolean getFollowImports() {
        return this._followImports;
    }

    public void setFollowImports(boolean b) {
        this._followImports = b;
    }

    @Override
    public void push() {
        this._nsSupport.pushContext();
    }

    @Override
    public void pop() {
        this._nsSupport.popContext();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this._nsSupport.getURI(prefix);
    }

    @Override
    public Iterable<String> getPrefixes() {
        return this._nsSupport.getPrefixes();
    }

    @Override
    public String getDefaultNamespaceURI() {
        return this.getNamespaceURI("");
    }

    @Override
    public void registerNamespaces(Element e) {
        Iterator iter = XmlUtil.getAllAttributes((Element)e);
        while (iter.hasNext()) {
            Attr a = (Attr)iter.next();
            if (a.getName().equals(PREFIX_XMLNS)) {
                this._nsSupport.declarePrefix("", a.getValue());
                continue;
            }
            String prefix = XmlUtil.getPrefix((String)a.getName());
            if (prefix == null || !prefix.equals(PREFIX_XMLNS)) continue;
            String nsPrefix = XmlUtil.getLocalPart((String)a.getName());
            String uri = a.getValue();
            this._nsSupport.declarePrefix(nsPrefix, uri);
        }
    }

    @Override
    public Locator getLocation(Element e) {
        return this.forest.locatorTable.getStartLocation(e);
    }

    public QName translateQualifiedName(Locator locator, String s) {
        if (s == null) {
            return null;
        }
        String prefix = XmlUtil.getPrefix((String)s);
        String uri = null;
        if (prefix == null) {
            uri = this.getDefaultNamespaceURI();
        } else {
            uri = this.getNamespaceURI(prefix);
            if (uri == null) {
                this.errorReceiver.error(locator, WsdlMessages.PARSING_UNKNOWN_NAMESPACE_PREFIX(prefix));
            }
        }
        return new QName(uri, XmlUtil.getLocalPart((String)s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireIgnoringExtension(Element e, Entity entity) {
        QName name = new QName(e.getNamespaceURI(), e.getLocalName());
        QName parent = entity.getElementName();
        List _targets = null;
        TWSDLParserContextImpl tWSDLParserContextImpl = this;
        synchronized (tWSDLParserContextImpl) {
            if (this._listeners != null) {
                _targets = (List)this._listeners.clone();
            }
        }
        if (_targets != null) {
            for (ParserListener l : _targets) {
                l.ignoringExtension(entity, name, parent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDoneParsingEntity(QName element, Entity entity) {
        List _targets = null;
        TWSDLParserContextImpl tWSDLParserContextImpl = this;
        synchronized (tWSDLParserContextImpl) {
            if (this._listeners != null) {
                _targets = (List)this._listeners.clone();
            }
        }
        if (_targets != null) {
            for (ParserListener l : _targets) {
                l.doneParsingEntity(element, entity);
            }
        }
    }

    public void pushWSDLLocation() {
        this._wsdlLocation.push();
    }

    public void popWSDLLocation() {
        this._wsdlLocation.pop();
    }

    public void setWSDLLocation(String loc) {
        this._wsdlLocation.setLocation(loc);
    }

    public String getWSDLLocation() {
        return this._wsdlLocation.getLocation();
    }
}

