/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.project.classpath.ClassPathModifierLookupMerger;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.java.project.support.ClassPathProviderMerger;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.netbeans.spi.java.queries.support.SourceForBinaryQueryImpl2Base;
import org.netbeans.spi.project.LookupMerger;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public final class LookupMergerSupport {
    public static LookupMerger<SourceForBinaryQueryImplementation> createSFBLookupMerger() {
        return new SFBLookupMerger();
    }

    public static LookupMerger<JavadocForBinaryQueryImplementation> createJFBLookupMerger() {
        return new JFBLookupMerger();
    }

    public static LookupMerger<ClassPathProvider> createClassPathProviderMerger(ClassPathProvider defaultProvider) {
        return new ClassPathProviderMerger(defaultProvider);
    }

    public static LookupMerger<ProjectClassPathModifierImplementation> createClassPathModifierMerger() {
        return new ClassPathModifierLookupMerger();
    }

    private static class JFBIMerged
    implements JavadocForBinaryQueryImplementation {
        private Lookup lookup;

        public JFBIMerged(Lookup lkp) {
            this.lookup = lkp;
        }

        public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
            Collection col = this.lookup.lookupAll(JavadocForBinaryQueryImplementation.class);
            for (JavadocForBinaryQueryImplementation impl : col) {
                JavadocForBinaryQuery.Result res = impl.findJavadoc(binaryRoot);
                if (res == null) continue;
                return res;
            }
            return null;
        }
    }

    private static class JFBLookupMerger
    implements LookupMerger<JavadocForBinaryQueryImplementation> {
        private JFBLookupMerger() {
        }

        public Class<JavadocForBinaryQueryImplementation> getMergeableClass() {
            return JavadocForBinaryQueryImplementation.class;
        }

        public JavadocForBinaryQueryImplementation merge(Lookup lookup) {
            return new JFBIMerged(lookup);
        }
    }

    private static class SFBIMerged
    extends SourceForBinaryQueryImpl2Base {
        private Lookup lookup;
        private Map<URL, SourceForBinaryQueryImplementation2.Result> url2Result = new HashMap<URL, SourceForBinaryQueryImplementation2.Result>();

        public SFBIMerged(Lookup lkp) {
            this.lookup = lkp;
        }

        public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
            return this.findSourceRoots2(binaryRoot);
        }

        public SourceForBinaryQueryImplementation2.Result findSourceRoots2(final URL binaryRoot) {
            return (SourceForBinaryQueryImplementation2.Result)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceForBinaryQueryImplementation2.Result>(){

                public SourceForBinaryQueryImplementation2.Result run() {
                    return this.findSourceRoots2Impl(binaryRoot);
                }
            });
        }

        private synchronized SourceForBinaryQueryImplementation2.Result findSourceRoots2Impl(URL binaryRoot) {
            SourceForBinaryQueryImplementation2.Result result = this.url2Result.get(binaryRoot);
            if (result != null) {
                return result;
            }
            Collection col = this.lookup.lookupAll(SourceForBinaryQueryImplementation.class);
            LinkedList<SourceForBinaryQueryImplementation2.Result> queryResults = new LinkedList<SourceForBinaryQueryImplementation2.Result>();
            for (SourceForBinaryQueryImplementation impl : col) {
                SourceForBinaryQuery.Result res;
                if (impl instanceof SourceForBinaryQueryImplementation2) {
                    res = ((SourceForBinaryQueryImplementation2)impl).findSourceRoots2(binaryRoot);
                    if (res == null) continue;
                    queryResults.add((SourceForBinaryQueryImplementation2.Result)res);
                    continue;
                }
                res = impl.findSourceRoots(binaryRoot);
                if (res == null) continue;
                queryResults.add(this.asResult(res));
            }
            if (queryResults.isEmpty()) {
                return null;
            }
            result = new ResultImpl(queryResults);
            this.url2Result.put(binaryRoot, result);
            return result;
        }

        private static final class ResultImpl
        implements SourceForBinaryQueryImplementation2.Result,
        ChangeListener {
            private final List<SourceForBinaryQueryImplementation2.Result> delegateTo;
            private final ChangeSupport cs = new ChangeSupport((Object)this);

            public ResultImpl(List<SourceForBinaryQueryImplementation2.Result> delegateTo) {
                this.delegateTo = delegateTo;
                for (SourceForBinaryQueryImplementation2.Result r : delegateTo) {
                    r.addChangeListener((ChangeListener)this);
                }
            }

            public boolean preferSources() {
                for (SourceForBinaryQueryImplementation2.Result r : this.delegateTo) {
                    if (!r.preferSources()) continue;
                    return true;
                }
                return false;
            }

            public FileObject[] getRoots() {
                LinkedList<FileObject> result = new LinkedList<FileObject>();
                for (SourceForBinaryQueryImplementation2.Result r : this.delegateTo) {
                    result.addAll(Arrays.asList(r.getRoots()));
                }
                return result.toArray(new FileObject[result.size()]);
            }

            public void addChangeListener(ChangeListener l) {
                this.cs.removeChangeListener(l);
                this.cs.addChangeListener(l);
            }

            public void removeChangeListener(ChangeListener l) {
                this.cs.removeChangeListener(l);
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.cs.fireChange();
            }
        }
    }

    private static class SFBLookupMerger
    implements LookupMerger<SourceForBinaryQueryImplementation> {
        private SFBLookupMerger() {
        }

        public Class<SourceForBinaryQueryImplementation> getMergeableClass() {
            return SourceForBinaryQueryImplementation.class;
        }

        public SourceForBinaryQueryImplementation merge(Lookup lookup) {
            return new SFBIMerged(lookup);
        }
    }
}

