/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.deep.CsmExpressionStatement;
import org.netbeans.modules.cnd.refactoring.actions.RefactoringKind;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.hints.ExpressionFinder;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.HintAction;
import org.netbeans.modules.cnd.refactoring.introduce.ExtendedAssignmentVariableFix;
import org.netbeans.modules.cnd.refactoring.introduce.ExtendedIntroduceVariableFix;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceMethodUI;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class IntroduceAction
extends HintAction {
    private final RefactoringKind type;
    private static final String MENU_TEXT = "menuText";
    private static final String POPUP_TEXT = "popupText";

    private IntroduceAction(RefactoringKind type) {
        super(type.getKey());
        this.type = type;
        this.putValue("Name", type.getKey());
        String displayText = IntroduceAction.getMenuItemText(type);
        this.putValue("ShortDescription", displayText);
        this.putValue(POPUP_TEXT, displayText);
        this.putValue(MENU_TEXT, displayText);
    }

    @Override
    protected void perform(CsmContext context) {
        String error = this.doPerformAction(context);
        if (error != null) {
            String errorText = NbBundle.getMessage(IntroduceAction.class, (String)error);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)errorText, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
    }

    private String doPerformAction(CsmContext context) {
        EnumMap<RefactoringKind, Fix> fixes = new EnumMap<RefactoringKind, Fix>(RefactoringKind.class);
        EnumMap<RefactoringKind, String> errorMessages = new EnumMap<RefactoringKind, String>(RefactoringKind.class);
        try {
            this.computeError(context, fixes, errorMessages, new AtomicBoolean());
            Fix fix = (Fix)fixes.get((Object)this.type);
            if (fix != null) {
                fix.implement();
                return null;
            }
            String errorMessage = (String)errorMessages.get((Object)this.type);
            if (errorMessage != null) {
                return errorMessage;
            }
            return "ERR_Invalid_Selection";
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public static IntroduceAction createVariable() {
        return new IntroduceAction(RefactoringKind.CREATE_VARIABLE);
    }

    public static IntroduceAction createConstant() {
        return new IntroduceAction(RefactoringKind.CREATE_CONSTANT);
    }

    public static IntroduceAction createField() {
        return new IntroduceAction(RefactoringKind.CREATE_FIELD);
    }

    public static IntroduceAction createMethod() {
        return new IntroduceAction(RefactoringKind.CREATE_METHOD){

            @Override
            protected void perform(CsmContext context) {
                final IntroduceMethodUI ui = IntroduceMethodUI.create(null, context);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TopComponent activetc = TopComponent.getRegistry().getActivated();
                        UI.openRefactoringUI((RefactoringUI)ui, (TopComponent)activetc);
                    }
                });
            }
        };
    }

    private static String getMenuItemText(RefactoringKind type) {
        switch (type) {
            case CREATE_CONSTANT: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction");
            }
            case CREATE_VARIABLE: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction");
            }
            case CREATE_FIELD: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction");
            }
            case CREATE_METHOD: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction");
            }
        }
        return null;
    }

    private List<ErrorDescription> computeError(CsmContext info, Map<RefactoringKind, Fix> fixesMap, Map<RefactoringKind, String> errorMessage, AtomicBoolean cancel) {
        LinkedList<ErrorDescription> hints = new LinkedList<ErrorDescription>();
        if (this.type == RefactoringKind.CREATE_VARIABLE) {
            this.detectIntroduceVariable(fixesMap, info.getFile(), info.getCaretOffset(), info.getStartOffset(), info.getEndOffset(), info.getDocument(), cancel, info.getFileObject(), info.getComponent());
        }
        return hints;
    }

    private void detectIntroduceVariable(Map<RefactoringKind, Fix> fixesMap, CsmFile file, int caretOffset, int selectionStart, int selectionEnd, Document doc, AtomicBoolean canceled, FileObject fileObject, JTextComponent comp) {
        CsmOffsetable applicableTextExpression;
        ExpressionFinder expressionFinder = new ExpressionFinder(doc, file, caretOffset, selectionStart, selectionEnd, canceled);
        ExpressionFinder.StatementResult res = expressionFinder.findExpressionStatement();
        if (res == null) {
            return;
        }
        if (canceled.get()) {
            return;
        }
        CsmExpressionStatement expression = res.getExpression();
        if (expression != null) {
            fixesMap.put(RefactoringKind.CREATE_VARIABLE, new ExtendedAssignmentVariableFix(expression.getExpression(), doc, fileObject));
        }
        if (res.getContainer() != null && res.getStatementInBody() != null && comp != null && selectionStart < selectionEnd && expressionFinder.isExpressionSelection() && (res.getContainer().getStartOffset() != selectionStart || res.getContainer().getEndOffset() != selectionEnd) && (applicableTextExpression = expressionFinder.applicableTextExpression()) != null) {
            List<Pair<Integer, Integer>> occurrences = res.getOccurrences(applicableTextExpression);
            fixesMap.put(RefactoringKind.CREATE_VARIABLE, new ExtendedIntroduceVariableFix(res.getStatementInBody(), applicableTextExpression, occurrences, doc, comp, fileObject));
        }
    }

    public static Object createVariableGlobal() {
        return new GlobalActionImpl(NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction"), RefactoringKind.CREATE_VARIABLE.getKey());
    }

    public static Object createMethodGlobal() {
        return new GlobalActionImpl(NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction"), RefactoringKind.CREATE_METHOD.getKey());
    }

    private static final class GlobalActionImpl
    extends MainMenuAction
    implements Presenter.Popup {
        private final String menuItemText;
        private final String actionName;

        public GlobalActionImpl(String menu, String action) {
            this.menuItemText = menu;
            this.actionName = action;
            this.setMenu();
        }

        protected String getMenuItemText() {
            return this.menuItemText;
        }

        protected String getActionName() {
            return this.actionName;
        }

        public JMenuItem getPopupPresenter() {
            return this.getMenuPresenter();
        }
    }
}

