/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.spi;

import java.text.MessageFormat;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.plugins.CsmModificationRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class CheckModificationHook {
    public abstract Problem appendProblem(AbstractRefactoring var1, Problem var2, CsmObject var3);

    protected final Problem defaultCheckIfModificationPossible(Problem problem, CsmObject referencedObject) {
        if ((problem = this.checkIfModificationPossibleInFile(problem, referencedObject)) != null) {
            return problem;
        }
        if (CsmKindUtilities.isMethod((CsmObject)referencedObject)) {
            Collection overridenMethods;
            CsmMethod method = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)referencedObject));
            if (CsmVirtualInfoQuery.getDefault().isVirtual(method) && (overridenMethods = CsmVirtualInfoQuery.getDefault().getOverriddenMethods(method, true)).size() > 1) {
                for (CsmMethod csmMethod : overridenMethods) {
                    problem = this.checkIfModificationPossibleInFile(problem, (CsmObject)csmMethod);
                    CsmFunctionDefinition def = csmMethod.getDefinition();
                    if (def == null || csmMethod.equals(def)) continue;
                    problem = this.checkIfModificationPossibleInFile(problem, (CsmObject)def);
                }
                boolean fatal = problem != null;
                String msg = fatal ? this.getString("ERR_Overrides_Fatal") : this.getString("ERR_OverridesOrOverriden");
                problem = this.createProblem(problem, fatal, msg);
            }
        }
        return problem;
    }

    protected String getString(String key) {
        return NbBundle.getMessage(CsmModificationRefactoringPlugin.class, (String)key);
    }

    protected Problem checkIfModificationPossibleInFile(Problem problem, CsmObject csmObject) {
        CsmFile csmFile = null;
        if (CsmKindUtilities.isFile((CsmObject)csmObject)) {
            csmFile = (CsmFile)csmObject;
        } else if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
            csmFile = ((CsmOffsetable)csmObject).getContainingFile();
        }
        if (csmFile != null) {
            FileObject fo = CsmUtilities.getFileObject((CsmFile)csmFile);
            if (!CsmRefactoringUtils.isRefactorable(fo)) {
                problem = this.createProblem(problem, true, this.getCannotRename(fo));
            }
            if (problem == null && !CsmRefactoringUtils.isElementInOpenProject(csmFile)) {
                problem = new Problem(false, NbBundle.getMessage(CsmModificationRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
        }
        return problem;
    }

    protected String getCannotRename(FileObject r) {
        return new MessageFormat(NbBundle.getMessage(CsmModificationRefactoringPlugin.class, (String)"ERR_CannotModifyInFile")).format(new Object[]{r.getNameExt()});
    }

    protected Problem createProblem(Problem problem, boolean fatal, String msg) {
        return CsmModificationRefactoringPlugin.createProblem(problem, fatal, msg);
    }
}

