/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.openide.awt.Mnemonics;

public class LocationCustomizer
extends ValidityAwarePanel
implements ActionListener,
ChangeListener,
DocumentListener,
HierarchyListener {
    private static int defaultTextComponentHeight = -1;
    private static JFileChooser fileChooser;
    private JButton fileButton;
    private JButton fromEditorButton;
    private JLabel fileLabel;
    private JLabel lineLabel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel secondLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JRadioButton lineBeginRadio;
    private JRadioButton lineEndRadio;
    private JRadioButton lineOffsetRadio;
    private JSeparator fromEditorSeparator;
    private JSpinner lineNumberSpinner;
    private JSpinner lineOffsetSpinner;
    private JTextField fileTextField;

    public LocationCustomizer() {
        this.initComponents();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fileLabel.setEnabled(enabled);
        this.fileTextField.setEnabled(enabled);
        this.fileButton.setEnabled(enabled);
        this.lineLabel.setEnabled(enabled);
        this.lineNumberSpinner.setEnabled(enabled);
        this.lineBeginRadio.setEnabled(enabled);
        this.lineEndRadio.setEnabled(enabled);
        this.lineOffsetRadio.setEnabled(enabled);
        this.lineOffsetSpinner.setEnabled(!enabled ? false : this.lineOffsetRadio.isSelected());
        this.fromEditorButton.setEnabled(enabled);
    }

    public void setPPLocation(CodeProfilingPoint.Location location) {
        this.fileTextField.setText(location.getFile());
        this.lineNumberSpinner.setValue(location.getLine());
        int offset = location.getOffset();
        if (offset == Integer.MIN_VALUE) {
            this.lineBeginRadio.setSelected(true);
        } else if (offset == Integer.MAX_VALUE) {
            this.lineEndRadio.setSelected(true);
        } else {
            this.lineOffsetRadio.setSelected(true);
            this.lineOffsetSpinner.setValue(offset);
        }
    }

    public CodeProfilingPoint.Location getPPLocation() {
        int offset = (Integer)this.lineOffsetSpinner.getValue();
        if (this.lineBeginRadio.isSelected()) {
            offset = Integer.MIN_VALUE;
        } else if (this.lineEndRadio.isSelected()) {
            offset = Integer.MAX_VALUE;
        }
        return new CodeProfilingPoint.Location(this.fileTextField.getText(), (Integer)this.lineNumberSpinner.getValue(), offset);
    }

    public int getPreferredCaptionAreaWidth() {
        return Math.max(this.fileLabel.getPreferredSize().width, this.lineLabel.getPreferredSize().width);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fileButton) {
            JFileChooser fileChooser = this.getFileChooser();
            fileChooser.setCurrentDirectory(new File(this.fileTextField.getText()));
            if (fileChooser.showOpenDialog(null) == 0) {
                this.fileTextField.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        } else if (e.getSource() == this.fromEditorButton) {
            if (this.lineBeginRadio.isSelected()) {
                this.setPPLocation(Utils.getCurrentLocation(Integer.MIN_VALUE));
            } else if (this.lineEndRadio.isSelected()) {
                this.setPPLocation(Utils.getCurrentLocation(Integer.MAX_VALUE));
            } else {
                this.setPPLocation(Utils.getCurrentLocation((Integer)this.lineOffsetSpinner.getValue()));
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L) {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window instanceof Dialog && !((Dialog)window).isModal()) {
                this.showFromEditor();
            } else {
                this.hideFromEditor();
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        LocationCustomizer main = new LocationCustomizer();
        JFrame frame = new JFrame("Customize Profiling Point");
        frame.getContentPane().add(main);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth(int captionAreaWidth) {
        int requiredCaptionAreaWidth = this.getPreferredCaptionAreaWidth();
        int diffCaptionAreaWidth = captionAreaWidth - requiredCaptionAreaWidth;
        int normalizedCaptionAreaWidth = diffCaptionAreaWidth > 0 ? diffCaptionAreaWidth : 0;
        this.firstLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, normalizedCaptionAreaWidth, 0, 0));
        this.secondLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, normalizedCaptionAreaWidth, 0, 0));
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public void resetMnemonic() {
        this.fileLabel.setDisplayedMnemonic(0);
        this.fileLabel.setDisplayedMnemonicIndex(-1);
        this.fileButton.setMnemonic(0);
        this.fileButton.setDisplayedMnemonicIndex(-1);
        this.fromEditorButton.setMnemonic(0);
        this.fromEditorButton.setDisplayedMnemonicIndex(-1);
        this.lineLabel.setDisplayedMnemonic(0);
        this.lineLabel.setDisplayedMnemonicIndex(-1);
        this.lineBeginRadio.setMnemonic(0);
        this.lineBeginRadio.setDisplayedMnemonicIndex(-1);
        this.lineEndRadio.setMnemonic(0);
        this.lineEndRadio.setDisplayedMnemonicIndex(-1);
        this.lineOffsetRadio.setMnemonic(0);
        this.lineOffsetRadio.setDisplayedMnemonicIndex(-1);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.lineOffsetRadio) {
            this.lineOffsetSpinner.setEnabled(this.lineOffsetRadio.isSelected());
        }
    }

    private JFileChooser getFileChooser() {
        if (fileChooser == null) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setDialogType(0);
            chooser.setDialogTitle(Bundle.LocationCustomizer_ChooseFileDialogCaption());
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".java");
                }

                @Override
                public String getDescription() {
                    return Bundle.LocationCustomizer_FileDialogFilterName();
                }
            });
            fileChooser = chooser;
        }
        return fileChooser;
    }

    private boolean isFileValid() {
        File file = new File(this.fileTextField.getText());
        return file.exists() && file.isFile();
    }

    private void hideFromEditor() {
        this.fromEditorSeparator.setVisible(false);
        this.fromEditorButton.setVisible(false);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.fileLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)Bundle.LocationCustomizer_FileLabelText());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.fileLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.firstLineCaptionSpacer, constraints);
        this.fileTextField = new JTextField(""){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.fileLabel.setLabelFor(this.fileTextField);
        this.fileTextField.getDocument().addDocumentListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 5, 5);
        this.add((Component)this.fileTextField, constraints);
        this.fileButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.fileButton, (String)Bundle.LocationCustomizer_BrowseButtonText());
        this.fileButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.fileButton, constraints);
        this.fromEditorSeparator = new JSeparator(1){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.gridheight = 2;
        constraints.anchor = 18;
        constraints.fill = 3;
        constraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.fromEditorSeparator, constraints);
        this.fromEditorButton = new HTMLButton();
        Mnemonics.setLocalizedText((AbstractButton)this.fromEditorButton, (String)Bundle.LocationCustomizer_CurrentLineButtonText());
        this.fromEditorButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 5;
        constraints.gridy = 0;
        constraints.gridheight = 2;
        constraints.anchor = 18;
        constraints.fill = 3;
        constraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)this.fromEditorButton, constraints);
        ButtonGroup lineRadiosGroup = new ButtonGroup();
        this.lineLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.lineLabel, (String)Bundle.LocationCustomizer_LineLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.lineLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.secondLineCaptionSpacer, constraints);
        JPanel lineSettingsContainer = new JPanel(new GridBagLayout());
        SpinnerNumberModel lineNumberModel = new SpinnerNumberModel();
        lineNumberModel.setMinimum(Integer.valueOf(1));
        this.lineNumberSpinner = new JExtendedSpinner(lineNumberModel){

            public Dimension getPreferredSize() {
                return new Dimension(Math.max(super.getPreferredSize().width, 55), 4.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.lineLabel.setLabelFor(this.lineNumberSpinner);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 10);
        lineSettingsContainer.add((Component)this.lineNumberSpinner, constraints);
        this.lineBeginRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.lineBeginRadio, (String)Bundle.LocationCustomizer_BeginRadioText());
        this.lineBeginRadio.getAccessibleContext().setAccessibleDescription(Bundle.LocationCustomizer_LineLabelText() + Bundle.LocationCustomizer_BeginRadioText());
        lineRadiosGroup.add(this.lineBeginRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 3);
        lineSettingsContainer.add((Component)this.lineBeginRadio, constraints);
        this.lineEndRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.lineEndRadio, (String)Bundle.LocationCustomizer_EndRadioText());
        this.lineEndRadio.getAccessibleContext().setAccessibleDescription(Bundle.LocationCustomizer_LineLabelText() + Bundle.LocationCustomizer_EndRadioText());
        lineRadiosGroup.add(this.lineEndRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 3);
        lineSettingsContainer.add((Component)this.lineEndRadio, constraints);
        this.lineOffsetRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.lineOffsetRadio, (String)Bundle.LocationCustomizer_OffsetRadioText());
        this.lineOffsetRadio.getAccessibleContext().setAccessibleDescription(Bundle.LocationCustomizer_LineLabelText() + Bundle.LocationCustomizer_OffsetRadioText());
        lineRadiosGroup.add(this.lineOffsetRadio);
        this.lineOffsetRadio.addChangeListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        lineSettingsContainer.add((Component)new JPanel(new FlowLayout(3, 0, 0)){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(((LocationCustomizer)LocationCustomizer.this).lineOffsetRadio.getPreferredSize().width + ((LocationCustomizer)LocationCustomizer.this).lineOffsetSpinner.getPreferredSize().width, Math.max(((LocationCustomizer)LocationCustomizer.this).lineOffsetRadio.getPreferredSize().height, ((LocationCustomizer)LocationCustomizer.this).lineOffsetSpinner.getPreferredSize().height));
            }
        }, constraints);
        this.lineOffsetSpinner = new JExtendedSpinner(){

            public Dimension getPreferredSize() {
                return new Dimension(Math.max(super.getPreferredSize().width, 55), 6.getDefaultSpinnerHeight());
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)lineSettingsContainer, constraints);
        JPanel fillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)fillerPanel, constraints);
        this.addHierarchyListener(this);
    }

    private void showFromEditor() {
        this.fromEditorSeparator.setVisible(true);
        this.fromEditorButton.setVisible(true);
    }

    private void updateValidity() {
        boolean isValid = this.isFileValid();
        this.fileTextField.setForeground(isValid ? UIManager.getColor("TextField.foreground") : Color.RED);
        if (isValid != this.areSettingsValid()) {
            this.fireValidityChanged(isValid);
        }
    }

    private static class HTMLButton
    extends JButton {
        private HTMLButton() {
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.setForeground(enabled ? SystemColor.textText : SystemColor.textInactiveText);
            super.setEnabled(enabled);
        }

        @Override
        public void setText(String value) {
            super.setText("<html><center><nobr>" + value.replace("\\n", "<br>") + "</nobr></center></html>");
            this.getAccessibleContext().setAccessibleName(value);
        }
    }
}

