/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.netbeans.modules.java.debug.TreeNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class DocTreeNode
extends AbstractNode
implements OffsetProvider {
    private final CompilationInfo info;
    private final DocCommentTree docComment;
    private final DocTree tree;

    public DocTreeNode(CompilationInfo info, TreePath declaration, DocCommentTree docComment, DocTree tree) {
        super((Children)new TreeNode.NodeChilren(DocTreeNode.children(info, declaration, docComment, tree)));
        this.info = info;
        this.docComment = docComment;
        this.tree = tree;
        this.setDisplayName((Object)((Object)tree.getKind()) + ":" + tree.toString());
    }

    private static List<Node> children(final CompilationInfo info, final TreePath declaration, final DocCommentTree docComment, final DocTree tree) {
        final ArrayList<Node> result = new ArrayList<Node>();
        tree.accept(new DocTreeScanner<Void, Void>(){

            @Override
            public Void scan(DocTree node, Void p) {
                result.add(new DocTreeNode(info, declaration, docComment, node));
                return null;
            }

            @Override
            public Void visitReference(ReferenceTree node, Void p) {
                List methodParameters;
                DocTreePath currentPath = new DocTreePath(new DocTreePath(declaration, docComment), tree);
                result.add(TreeNode.nodeForElement(info, ((DocTrees)info.getTrees()).getElement(currentPath)));
                ExpressionTree classReference = info.getTreeUtilities().getReferenceClass(currentPath);
                if (classReference != null) {
                    result.add(TreeNode.getTree(info, new TreePath(declaration, classReference), new AtomicBoolean()));
                }
                if ((methodParameters = info.getTreeUtilities().getReferenceParameters(currentPath)) != null) {
                    for (Tree param : methodParameters) {
                        result.add(TreeNode.getTree(info, new TreePath(declaration, param), new AtomicBoolean()));
                    }
                }
                return (Void)super.visitReference(node, p);
            }
        }, null);
        return result;
    }

    @Override
    public int getStart() {
        return (int)((DocTrees)this.info.getTrees()).getSourcePositions().getStartPosition(this.info.getCompilationUnit(), this.docComment, this.tree);
    }

    @Override
    public int getEnd() {
        return (int)((DocTrees)this.info.getTrees()).getSourcePositions().getEndPosition(this.info.getCompilationUnit(), this.docComment, this.tree);
    }

    @Override
    public int getPreferredPosition() {
        return -1;
    }
}

