/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.HostNameValidator;
import org.netbeans.validation.api.builtin.stringvalidation.IpAddressValidator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.openide.util.NbBundle;

final class ValidHostNameOrIPValidator
extends StringValidator {
    private final HostNameValidator hostVal;
    private final IpAddressValidator ipVal = new IpAddressValidator();

    ValidHostNameOrIPValidator(boolean allowPort) {
        this.hostVal = new HostNameValidator(allowPort);
    }

    ValidHostNameOrIPValidator() {
        this(true);
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        String[] parts = model.split("\\.");
        boolean hasIntParts = false;
        boolean hasNonIntParts = false;
        if (model.indexOf(" ") > 0 || model.indexOf("\t") > 0) {
            problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"HOST_MAY_NOT_CONTAIN_WHITESPACE", (Object)compName, (Object)model));
            return;
        }
        if (parts.length == 0) {
            problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"INVALID_HOST_OR_IP", (Object)compName, (Object)model));
            return;
        }
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (i == parts.length - 1 && s.contains(":")) {
                String[] partAndPort = s.split(":");
                if (partAndPort.length > 2) {
                    problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"TOO_MANY_COLONS", (Object)compName, (Object)model));
                    return;
                }
                if (partAndPort.length == 0) {
                    problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"INVALID_HOST_OR_IP", (Object)compName, (Object)model));
                    return;
                }
                s = partAndPort[0];
                if (partAndPort.length == 2) {
                    try {
                        Integer.parseInt(partAndPort[1]);
                    }
                    catch (NumberFormatException nfe) {
                        problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"INVALID_PORT", (Object)compName, (Object)partAndPort[1]));
                        return;
                    }
                }
            }
            try {
                Integer.parseInt(s);
                hasIntParts = true;
            }
            catch (NumberFormatException nfe) {
                hasNonIntParts = true;
            }
            if (!hasIntParts || !hasNonIntParts) continue;
            problems.add(NbBundle.getMessage(ValidHostNameOrIPValidator.class, (String)"ADDRESS_CONTAINS_INT_AND_NON_INT_LABELS", (Object)compName, (Object)model));
            return;
        }
        if (hasNonIntParts) {
            this.hostVal.validate(problems, compName, model);
        } else {
            assert (hasIntParts);
            this.ipVal.validate(problems, compName, model);
        }
    }
}

