/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationGroupProvider;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;
import org.openide.util.NbBundle;

public final class ValidationPanel
extends JPanel
implements ValidationGroupProvider {
    private final JComponent problemLabel;
    private boolean initialized;
    private Problem problem = null;
    private final List<ChangeListener> listeners = Collections.synchronizedList(new LinkedList());
    protected final SwingValidationGroup group;
    private final VUI vui = new VUI();

    public ValidationPanel(SwingValidationGroup group) {
        super(new BorderLayout());
        if (group == null) {
            group = SwingValidationGroup.create(this.vui);
        } else {
            group.addUI(this.vui);
        }
        this.group = group;
        this.problemLabel = group.createProblemLabel();
        this.problemLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.add((Component)this.problemLabel, "South");
        this.initialized = true;
        int b = System.getProperty("mrj.version") != null ? 12 : 5;
        this.setBorder(BorderFactory.createEmptyBorder(b, b, b, b));
    }

    public ValidationPanel() {
        this((SwingValidationGroup)null);
    }

    public void setDelegateValidationUI(ValidationUI ui) {
        this.group.addUI(ui);
    }

    public void removeDelegateValidationUI(ValidationUI ui) {
        this.group.removeUI(ui);
    }

    private JDialog createDialog() {
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (w == null) {
            Frame[] f = Frame.getFrames();
            Window window = w = f == null || f.length == 0 ? null : f[0];
        }
        JDialog result = w instanceof Frame ? new JDialog((Frame)w) : (w instanceof Dialog ? new JDialog((Dialog)w) : new JDialog());
        if (w != null) {
            result.setLocationRelativeTo(w);
        }
        return result;
    }

    public boolean showOkCancelDialog(String title) {
        final JDialog dlg = this.createDialog();
        dlg.setModal(true);
        dlg.setTitle(title);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this, "Center");
        dlg.setContentPane(content);
        JPanel buttons = new JPanel(new FlowLayout(4));
        final JButton ok = new JButton(NbBundle.getMessage(ValidationPanel.class, (String)"OK"));
        final JButton cancel = new JButton(NbBundle.getMessage(ValidationPanel.class, (String)"Cancel"));
        boolean mac = System.getProperty("mrj.version") != null;
        buttons.add(mac ? cancel : ok);
        buttons.add(mac ? ok : cancel);
        final ValidationUI okButtonEnabler = new ValidationUI(){

            @Override
            public void showProblem(Problem problem) {
                if (problem == null || !problem.isFatal()) {
                    ok.setEnabled(true);
                } else {
                    ok.setEnabled(false);
                }
            }

            @Override
            public void clearProblem() {
                this.showProblem(null);
            }
        };
        this.group.addUI(okButtonEnabler);
        content.add((Component)buttons, "South");
        dlg.getRootPane().getActionMap().put("esc", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                cancel.doClick();
            }
        });
        dlg.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "esc");
        final boolean[] result = new boolean[1];
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidationPanel.this.group.removeUI(okButtonEnabler);
                result[0] = true;
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidationPanel.this.group.removeUI(okButtonEnabler);
                result[0] = false;
                dlg.setVisible(false);
                dlg.dispose();
            }
        });
        dlg.getRootPane().setDefaultButton(ok);
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                this.centerScreen(e.getWindow());
            }

            public void centerScreen(Window w) {
                if (w.getOwner() == null) {
                    Dimension dim = ValidationPanel.this.getToolkit().getScreenSize();
                    Rectangle abounds = w.getBounds();
                    w.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                cancel.doClick();
            }
        });
        dlg.pack();
        dlg.setVisible(true);
        return result[0];
    }

    @Override
    public final ValidationGroup getValidationGroup() {
        return this.group;
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
        if (this.initialized) {
            throw new IllegalStateException("Use setInnerComponent, do not set the layout");
        }
        super.setLayout(mgr);
    }

    public final void setInnerComponent(Component c) {
        this.removeAll();
        this.add((Component)this.problemLabel, "South");
        this.add(c, "Center");
        if (this.isDisplayable()) {
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (comp instanceof ValidationGroupProvider) {
            ValidationGroup g = ((ValidationGroupProvider)((Object)comp)).getValidationGroup();
            this.group.addItem(g, false);
        }
        if (comp instanceof ValidationUI) {
            ValidationUI theUI = (ValidationUI)((Object)comp);
            this.group.addUI(theUI);
        }
    }

    public final Problem getProblem() {
        return this.problem;
    }

    public final boolean isFatalProblem() {
        return this.problem != null && this.problem.isFatal();
    }

    public final void addChangeListener(ChangeListener cl) {
        this.listeners.add(cl);
    }

    public final void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    private void fireChange() {
        ChangeListener[] cl = this.listeners.toArray(new ChangeListener[0]);
        if (cl.length > 0) {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : cl) {
                l.stateChanged(e);
            }
        }
    }

    private class VUI
    implements ValidationUI {
        private VUI() {
        }

        @Override
        public final void showProblem(Problem problem) {
            Problem old = ValidationPanel.this.problem;
            ValidationPanel.this.problem = problem;
            if (old != null && !old.equals(problem) || old == null && problem != null) {
                ValidationPanel.this.fireChange();
            }
        }

        @Override
        public void clearProblem() {
            this.showProblem(null);
        }
    }
}

