/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class HistorySettings {
    private static final HistorySettings INSTANCE = new HistorySettings();
    private static final String PROP_TTL = "timeToLive";
    public static final String PROP_INCREMENTS = "history.increments";
    private static final String PROP_CLEANUP_LABELED = "noLabelCleanUp";
    private static final String PROP_KEEP_FOREVER = "keepForever";
    public static final String PROP_LOAD_ALL = "history.loadAll";
    public static final String PROP_ALL_MODE = "history.AllMode";
    public static final String PROP_VCS_MODE = "history.VCSMode";
    public static final String PROP_LH_MODE = "history.LHMode";

    private HistorySettings() {
    }

    public static HistorySettings getInstance() {
        HistorySettings.migrate();
        return INSTANCE;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(HistorySettings.class);
    }

    public void setTTL(int ttl) {
        this.getPreferences().putInt(PROP_TTL, ttl);
    }

    public void setIncrements(int ttl) {
        this.getPreferences().putInt(PROP_INCREMENTS, ttl);
    }

    public int getTTL() {
        return this.getPreferences().getInt(PROP_TTL, 7);
    }

    public int getIncrements() {
        int i = this.getPreferences().getInt(PROP_INCREMENTS, 30);
        return i < 1 ? (i = 7) : i;
    }

    public void setCleanUpLabeled(boolean selected) {
        this.getPreferences().putBoolean(PROP_CLEANUP_LABELED, selected);
    }

    public boolean getCleanUpLabeled() {
        return this.getPreferences().getBoolean(PROP_CLEANUP_LABELED, true);
    }

    public long getTTLMillis() {
        return (long)this.getTTL() * 24L * 60L * 60L * 1000L;
    }

    public boolean getKeepForever() {
        return this.getPreferences().getBoolean(PROP_KEEP_FOREVER, false);
    }

    public void setKeepForever(boolean forever) {
        this.getPreferences().putBoolean(PROP_KEEP_FOREVER, forever);
    }

    public boolean getLoadAll() {
        return this.getPreferences().getBoolean(PROP_LOAD_ALL, false);
    }

    public void setLoadAll(boolean loadAll) {
        this.getPreferences().putBoolean(PROP_LOAD_ALL, loadAll);
    }

    public void addPreferenceListener(PreferenceChangeListener l) {
        this.getPreferences().addPreferenceChangeListener(l);
    }

    public void removePreferenceListener(PreferenceChangeListener l) {
        this.getPreferences().removePreferenceChangeListener(l);
    }

    void setAllMode(String name) {
        this.getPreferences().put(PROP_ALL_MODE, name);
    }

    void setVCSMode(String name) {
        this.getPreferences().put(PROP_VCS_MODE, name);
    }

    void setLHMode(String name) {
        this.getPreferences().put(PROP_LH_MODE, name);
    }

    String getAllMode(String def) {
        return this.getPreferences().get(PROP_ALL_MODE, def);
    }

    String getVCSMode(String def) {
        return this.getPreferences().get(PROP_VCS_MODE, def);
    }

    String getLHMode(String def) {
        return this.getPreferences().get(PROP_LH_MODE, def);
    }

    private static void migrate() {
        String prevPath = "org/netbeans/modules/localhistory";
        try {
            String[] keys;
            if (!NbPreferences.root().nodeExists(prevPath)) {
                return;
            }
            Preferences prev = NbPreferences.root().node(prevPath);
            Preferences cur = NbPreferences.forModule(HistorySettings.class);
            for (String key : keys = prev.keys()) {
                String value = prev.get(key, null);
                if (value == null || cur.get(key, null) != null) continue;
                cur.put(key, value);
            }
            prev.removeNode();
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

