/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui;

import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

final class RemoveClassPathRootAction
extends NodeAction {
    RemoveClassPathRootAction() {
    }

    protected void performAction(final Node[] activatedNodes) {
        assert (!ProjectManager.mutex().isReadAccess() && !ProjectManager.mutex().isReadAccess());
        final AtomicBoolean cancel = new AtomicBoolean();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                ProjectManager.mutex().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        if (cancel.get()) {
                            return;
                        }
                        HashSet<Project> changedProjectsSet = new HashSet<Project>();
                        for (int i = 0; i < activatedNodes.length; ++i) {
                            Removable removable = (Removable)activatedNodes[i].getLookup().lookup(Removable.class);
                            if (removable == null) continue;
                            if (cancel.get()) break;
                            Project p = removable.remove();
                            if (p == null) continue;
                            changedProjectsSet.add(p);
                        }
                        for (Project p : changedProjectsSet) {
                            try {
                                ProjectManager.getDefault().saveProject(p);
                            }
                            catch (IOException e) {
                                Exceptions.printStackTrace((Throwable)e);
                            }
                        }
                    }
                });
            }
        };
        ProgressUtils.runOffEventDispatchThread((Runnable)action, (String)NbBundle.getMessage(RemoveClassPathRootAction.class, (String)"TXT_RemovingClassPathRoots"), (AtomicBoolean)cancel, (boolean)false);
    }

    protected boolean enable(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            Removable removable = (Removable)activatedNodes[i].getLookup().lookup(Removable.class);
            if (removable == null) {
                return false;
            }
            if (removable.canRemove()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(RemoveClassPathRootAction.class, (String)"CTL_RemoveProject");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RemoveClassPathRootAction.class);
    }

    protected boolean asynchronous() {
        return false;
    }

    static interface Removable {
        public boolean canRemove();

        public Project remove();
    }
}

