/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.metadata;

import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class QNameTransformer
implements AttributeTransformer,
FieldTransformer {
    private static final char COLON = ':';
    private static final char HASH = '#';
    public static final String QNAME_NAMESPACE_PREFIX = "qns";
    private static final String DEFAULT_NAMESPACE_PREFIX = "";
    AbstractTransformationMapping transformationMapping;
    private XMLField xPath;

    public QNameTransformer(String xPath) {
        this.xPath = new XMLField(xPath);
    }

    @Override
    public void initialize(AbstractTransformationMapping mapping) {
        this.transformationMapping = mapping;
        NamespaceResolver namespaceResolver = ((XMLDescriptor)mapping.getDescriptor()).getNamespaceResolver();
        this.xPath.setNamespaceResolver(namespaceResolver);
    }

    @Override
    public Object buildAttributeValue(Record record, Object object, Session session) {
        if (record == null) {
            return null;
        }
        String value = (String)record.get(this.xPath);
        if (value == null) {
            return null;
        }
        int index = value.lastIndexOf(58);
        if (index > -1) {
            String prefix = value.substring(0, index);
            String localName = value.substring(index + 1);
            String namespaceURI = ((XMLRecord)record).resolveNamespacePrefix(prefix);
            if (namespaceURI != null) {
                return String.valueOf(namespaceURI) + '#' + localName;
            }
            return localName;
        }
        String namespaceURI = ((XMLRecord)record).resolveNamespacePrefix(DEFAULT_NAMESPACE_PREFIX);
        if (namespaceURI != null) {
            return String.valueOf(namespaceURI) + '#' + value;
        }
        return value;
    }

    @Override
    public Object buildFieldValue(Object instance, String fieldName, Session session) {
        if (instance == null) {
            return null;
        }
        String value = (String)this.transformationMapping.getAttributeValueFromObject(instance);
        if (value == null) {
            return null;
        }
        int index = value.lastIndexOf(35);
        if (index > -1) {
            String namespaceURI = value.substring(0, index);
            String localName = value.substring(index + 1);
            String prefix = null;
            NamespaceResolver namespaceResolver = this.xPath.getNamespaceResolver();
            if (namespaceResolver != null) {
                prefix = namespaceResolver.resolveNamespaceURI(namespaceURI);
                if (prefix == null && namespaceURI.equals(namespaceResolver.getDefaultNamespaceURI())) {
                    return localName;
                }
                return String.valueOf(prefix) + ':' + localName;
            }
            return localName;
        }
        return value;
    }
}

