/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.queues;

import java.util.List;
import java.util.Set;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.remote.ui.queues.Bundle;
import org.netbeans.modules.mercurial.remote.ui.queues.CreateRefreshAction;
import org.netbeans.modules.mercurial.remote.ui.queues.QCommitPanel;
import org.netbeans.modules.mercurial.remote.ui.queues.QCreatePatchParameters;
import org.netbeans.modules.mercurial.remote.ui.queues.QPatch;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class QRefreshPatchAction
extends CreateRefreshAction {
    static final String KEY_CANCELED_MESSAGE = "qrefresh.";

    public QRefreshPatchAction() {
        super("refresh");
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_QRefreshPatch";
    }

    @Override
    QCommitPanel createPanel(VCSFileProxy root, VCSFileProxy[] roots) {
        QPatch currentPatch = null;
        try {
            for (QPatch p : HgCommand.qListSeries(root)) {
                if (!p.isApplied()) break;
                currentPatch = p;
            }
            if (currentPatch != null) {
                List<HgLogMessage> msgs;
                HgLogMessage.HgRevision parent = HgCommand.getParent(root, null, currentPatch.getId());
                String commitMessage = HgModuleConfig.getDefault(root).getLastCanceledCommitMessage(KEY_CANCELED_MESSAGE + currentPatch.getId());
                if (commitMessage.isEmpty() && (commitMessage = HgModuleConfig.getDefault(root).getLastUsedQPatchMessage(currentPatch.getId())).isEmpty() && !(msgs = HgCommand.getParents(root, null, null)).isEmpty()) {
                    commitMessage = msgs.get(0).getMessage();
                }
                return QCommitPanel.createRefreshPanel(roots, root, commitMessage, currentPatch, parent, QRefreshPatchAction.class.getName());
            }
            NotifyDescriptor.Message e = new NotifyDescriptor.Message((Object)Bundle.MSG_QRefreshPatchAction_err_noPatchApplied(root.getName()));
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        catch (HgException.HgCommandCanceledException parent) {
        }
        catch (HgException ex) {
            NotifyDescriptor.Message e = new NotifyDescriptor.Message((Object)ex.getMessage());
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        return null;
    }

    @Override
    CreateRefreshAction.Cmd.CreateRefreshPatchCmd createHgCommand(VCSFileProxy root, List<VCSFileProxy> candidates, OutputLogger logger, String message, String patchName, String user, String bundleKeyPostfix, List<VCSFileProxy> roots, Set<VCSFileProxy> excludedFiles, Set<VCSFileProxy> filesToRefresh) {
        return new CreateRefreshAction.Cmd.CreateRefreshPatchCmd(root, candidates, logger, message, patchName, user, bundleKeyPostfix, roots, excludedFiles, filesToRefresh){

            @Override
            protected void runHgCommand(VCSFileProxy repository, List<VCSFileProxy> candidates, Set<VCSFileProxy> excludedFiles, String patchId, String msg, String user, OutputLogger logger) throws HgException {
                HgCommand.qRefreshPatch(repository, candidates, excludedFiles, msg, user, logger);
            }
        };
    }

    @Override
    void persistCanceledCommitMessage(VCSFileProxy root, QCreatePatchParameters parameters, String canceledCommitMessage) {
        HgModuleConfig.getDefault(root).setLastCanceledCommitMessage(KEY_CANCELED_MESSAGE + parameters.getPatch().getId(), canceledCommitMessage);
    }
}

