/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.update;

import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.modules.mercurial.remote.ui.update.RevertModificationsPanel;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RevertModifications
implements PropertyChangeListener {
    private RevertModificationsPanel panel;
    private JButton okButton;
    private JButton cancelButton;
    private final VCSFileProxy repository;

    public RevertModifications(VCSFileProxy repository, VCSFileProxy[] files) {
        this(repository, files, null);
    }

    public RevertModifications(VCSFileProxy repository, VCSFileProxy[] files, String defaultRevision) {
        this.repository = repository;
        this.panel = new RevertModificationsPanel(repository, files);
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertForm_Action_Revert"));
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertForm_Action_Revert"));
        this.okButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RevertModifications.class, (String)"ACSN_RevertForm_Action_Revert"));
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertForm_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertForm_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(RevertModifications.class, (String)"ACSN_RevertForm_Action_Cancel"));
        this.okButton.setEnabled(false);
        this.panel.addPropertyChangeListener(this);
    }

    public boolean showDialog() {
        VCSFileProxy[] revertFiles = this.panel.getRootFiles();
        if (revertFiles == null) {
            revertFiles = new VCSFileProxy[]{this.repository};
        }
        String title = revertFiles.length == 1 ? NbBundle.getMessage(RevertModifications.class, (String)"CTL_RevertDialog", (Object)revertFiles[0].getName()) : NbBundle.getMessage(RevertModifications.class, (String)"CTL_MultiRevertDialog");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, title, true, new Object[]{this.okButton, this.cancelButton}, (Object)this.okButton, 0, new HelpCtx(this.getClass()), null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        if (revertFiles.length == 1) {
            dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_RevertDialog", (Object)revertFiles[0].getName()));
        } else {
            dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RevertModifications.class, (String)"ACSD_MultiRevertDialog"));
        }
        dialog.setVisible(true);
        dialog.setResizable(false);
        boolean ret = dialogDescriptor.getValue() == this.okButton;
        return ret;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("prop.valid".equals(evt.getPropertyName()) && this.okButton != null) {
            boolean valid = (Boolean)evt.getNewValue();
            this.okButton.setEnabled(valid);
        }
    }

    public String getSelectionRevision() {
        if (this.panel == null) {
            return null;
        }
        return this.panel.getSelectedRevisionCSetId();
    }

    public boolean isBackupRequested() {
        if (this.panel == null) {
            return false;
        }
        return this.panel.isBackupRequested();
    }

    boolean isRemoveNewFilesRequested() {
        if (this.panel == null) {
            return false;
        }
        return this.panel.isPurgeRequested();
    }
}

