/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.MutableObject;

public class CompletionUtilities {
    private CompletionUtilities() {
    }

    public static List<CsmDeclaration> findFunctionLocalVariables(Document doc, int offset, FileReferencesContext fileReferncesContext) {
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        if (file == null || !file.isValid()) {
            return Collections.emptyList();
        }
        CsmContext context = CsmOffsetResolver.findContext(file, offset, fileReferncesContext);
        return CsmContextUtilities.findFunctionLocalVariables(context);
    }

    public static List<CsmDeclaration> findFileVariables(Document doc, int offset) {
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        if (file == null || !file.isValid()) {
            return Collections.emptyList();
        }
        CsmContext context = CsmOffsetResolver.findContext(file, offset, null);
        return CsmContextUtilities.findFileLocalVariables(context);
    }

    public static CsmClass findClassOnPosition(CsmFile file, Document doc, int offset) {
        if (file == null) {
            file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        }
        if (file == null || !file.isValid()) {
            return null;
        }
        CsmContext context = CsmOffsetResolver.findContext(file, offset, null);
        CsmClass clazz = CsmContextUtilities.getClass(context, true, false);
        return clazz;
    }

    public static CsmOffsetableDeclaration findFunDefinitionOrClassOnPosition(CsmFile file, Document doc, int offset, FileReferencesContext fileReferncesContext) {
        CsmContext context;
        CsmFunctionDefinition out = null;
        if (file == null) {
            file = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
        }
        if (!(file == null || (out = CsmContextUtilities.getFunctionDefinition(context = CsmOffsetResolver.findContext(file, offset, fileReferncesContext))) != null && CsmContextUtilities.isInFunctionBodyOrInitializerListOrCastOperatorType(context, offset))) {
            out = CsmContextUtilities.getClass(context, false, false);
        }
        return out;
    }

    public static Collection<CsmObject> findItemsReferencedAtCaretPos(JTextComponent target, Document doc, CsmCompletionQuery query, int dotPos) {
        List<CsmObject> out = new ArrayList<CsmObject>();
        try {
            CsmFile currentFile;
            BaseDocument baseDoc = null;
            if (doc instanceof BaseDocument) {
                baseDoc = (BaseDocument)doc;
            }
            baseDoc = baseDoc != null ? baseDoc : (BaseDocument)target.getDocument();
            boolean searchFunctionsOnly = false;
            boolean searchSpecializationsOnly = false;
            int[] idBlk = CompletionUtilities.getIdentifierAndMethodBlock(baseDoc, dotPos);
            boolean bl = idBlk != null ? idBlk.length == 3 : (searchFunctionsOnly = false);
            if (idBlk == null || idBlk.length == 2) {
                idBlk = CompletionUtilities.getIdentifierAndInstantiationBlock(baseDoc, dotPos);
                boolean bl2 = idBlk != null ? idBlk.length == 3 : (searchSpecializationsOnly = false);
            }
            if (idBlk == null) {
                idBlk = new int[]{dotPos, dotPos};
            }
            if ((currentFile = query.getCsmFile()) == null) {
                currentFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
            }
            for (int ind = idBlk.length - 1; ind >= 1; --ind) {
                CsmCompletionQuery.CsmCompletionResult result = query.query(target, baseDoc, idBlk[ind], true, false, false);
                if (result != null && !result.getItems().isEmpty()) {
                    CsmCompletionQuery.CsmCompletionResult resultx;
                    int endOfMethod;
                    List<CsmObject> filtered = CompletionUtilities.getAssociatedObjects(result.getItems(), searchFunctionsOnly, currentFile, dotPos);
                    List<CsmObject> list = out = !filtered.isEmpty() ? filtered : CompletionUtilities.getAssociatedObjects(result.getItems(), false, currentFile, dotPos);
                    if (filtered.size() > 1 && searchFunctionsOnly && (endOfMethod = CompletionUtilities.findEndOfMethod((Document)baseDoc, idBlk[ind] - 1)) > -1 && (resultx = query.query(target, baseDoc, endOfMethod, true, false, false)) != null && !resultx.getItems().isEmpty()) {
                        out = CompletionUtilities.getAssociatedObjects(resultx.getItems(), false, currentFile, dotPos);
                    }
                    if (filtered.size() > 1 && searchSpecializationsOnly && (endOfMethod = CompletionUtilities.findEndOfInstantiation((Document)baseDoc, idBlk[ind] - 1)) > -1 && (resultx = query.query(target, baseDoc, endOfMethod, true, false, false)) != null && !resultx.getItems().isEmpty()) {
                        out = CompletionUtilities.getAssociatedObjects(resultx.getItems(), false, currentFile, dotPos);
                    }
                } else {
                    CsmCompletionQuery.CsmCompletionResult resultx;
                    int endOfMethod;
                    if (!searchFunctionsOnly || ind != idBlk.length - 1 || (endOfMethod = CompletionUtilities.findEndOfMethod((Document)baseDoc, idBlk[ind] - 1)) <= -1 || (resultx = query.query(target, baseDoc, endOfMethod, true, false, false)) == null || resultx.getItems().isEmpty()) continue;
                    out = CompletionUtilities.getAssociatedObjects(resultx.getItems(), false, currentFile, dotPos);
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return out;
    }

    private static int[] getIdentifierBlock(BaseDocument doc, int offset) throws BadLocationException {
        int[] ret = null;
        if (offset == 0) {
            int wordStart = LineDocumentUtils.getWordStart((LineDocument)doc, (int)offset);
            int wordEnd = LineDocumentUtils.getWordEnd((LineDocument)doc, (int)wordStart);
            if (wordStart >= 0 && wordEnd >= 0) {
                ret = new int[]{wordStart, wordEnd};
            }
        } else if (offset > 0) {
            ret = Utilities.getIdentifierBlock((BaseDocument)doc, (int)offset);
        }
        return ret;
    }

    private static int[] getIdentifierAndMethodBlock(BaseDocument doc, int offset) throws BadLocationException {
        int[] funBlk;
        int[] idBlk = CompletionUtilities.getIdentifierBlock(doc, offset);
        if (idBlk != null && (funBlk = CompletionUtilities.getFunctionBlock(doc, idBlk)) != null) {
            return new int[]{idBlk[0], idBlk[1], funBlk[1]};
        }
        return idBlk;
    }

    private static int[] getFunctionBlock(BaseDocument doc, int[] identifierBlock) throws BadLocationException {
        if (identifierBlock != null) {
            int eoi;
            int nwPos = LineDocumentUtils.getNextNonWhitespace((LineDocument)doc, (int)identifierBlock[1]);
            if (nwPos >= 0 && doc.getChars(nwPos, 1)[0] == '(') {
                return new int[]{identifierBlock[0], nwPos + 1};
            }
            if (nwPos >= 0 && doc.getChars(nwPos, 1)[0] == '<' && (eoi = CompletionUtilities.findEndOfInstantiation((Document)doc, nwPos)) >= 0 && (nwPos = LineDocumentUtils.getNextNonWhitespace((LineDocument)doc, (int)eoi)) >= 0 && doc.getChars(nwPos, 1)[0] == '(') {
                return new int[]{identifierBlock[0], nwPos + 1};
            }
        }
        return null;
    }

    private static int[] getIdentifierAndInstantiationBlock(BaseDocument doc, int offset) throws BadLocationException {
        int[] instBlk;
        int[] idBlk = CompletionUtilities.getIdentifierBlock(doc, offset);
        if (idBlk != null && (instBlk = CompletionUtilities.getInstantiationBlock(doc, idBlk)) != null) {
            return new int[]{idBlk[0], idBlk[1], instBlk[1]};
        }
        return idBlk;
    }

    private static int[] getInstantiationBlock(BaseDocument doc, int[] identifierBlock) throws BadLocationException {
        int nwPos;
        if (identifierBlock != null && (nwPos = LineDocumentUtils.getNextNonWhitespace((LineDocument)doc, (int)identifierBlock[1])) >= 0 && doc.getChars(nwPos, 1)[0] == '<') {
            return new int[]{identifierBlock[0], nwPos + 1};
        }
        return null;
    }

    private static List<CsmObject> getAssociatedObjects(List items, boolean wantFuncsOnly, CsmFile contextFile, int offset) {
        ArrayList<CsmObject> visible = new ArrayList<CsmObject>();
        ArrayList<CsmObject> all = new ArrayList<CsmObject>();
        ArrayList<CsmObject> funcs = new ArrayList<CsmObject>();
        ArrayList<CsmObject> visibleFuncs = new ArrayList<CsmObject>();
        for (Object item : items) {
            if (!(item instanceof CsmResultItem)) continue;
            CsmObject ret = CompletionUtilities.getAssociatedObject(item);
            boolean isVisible = contextFile == null ? false : CsmIncludeResolver.getDefault().isObjectVisible(contextFile, ret);
            boolean isFunc = CsmKindUtilities.isFunction((CsmObject)ret);
            if (isFunc) {
                if (isVisible) {
                    visibleFuncs.add(ret);
                } else {
                    funcs.add(ret);
                }
            }
            if (isVisible) {
                visible.add(ret);
                continue;
            }
            all.add(ret);
        }
        List<CsmObject> out = wantFuncsOnly ? (!visibleFuncs.isEmpty() ? visibleFuncs : funcs) : CompletionUtilities.computeCandidatesList(visible, all, contextFile);
        return out;
    }

    private static List<CsmObject> computeCandidatesList(List<CsmObject> visible, List<CsmObject> invisible, CsmFile contextFile) {
        List<CsmObject> result;
        if (!visible.isEmpty()) {
            result = visible;
            HashMap clsMap = null;
            for (int i = 0; i < result.size(); ++i) {
                CsmTypedef td;
                CsmObject candidate = result.get(i);
                if (!CsmKindUtilities.isTypedef((CsmObject)candidate)) continue;
                if (clsMap == null) {
                    clsMap = new HashMap();
                    for (CsmObject obj : invisible) {
                        List<CsmClassifier> classifiers;
                        if (!CsmKindUtilities.isClass((CsmObject)obj) && !CsmKindUtilities.isEnum((CsmObject)obj)) continue;
                        CsmClassifier cls = (CsmClassifier)obj;
                        if (clsMap.containsKey(cls.getQualifiedName())) {
                            classifiers = (List)clsMap.get(cls.getQualifiedName());
                        } else {
                            classifiers = new ArrayList();
                            clsMap.put(cls.getQualifiedName(), classifiers);
                        }
                        classifiers.add(cls);
                    }
                }
                if (!clsMap.containsKey((td = (CsmTypedef)candidate).getQualifiedName())) continue;
                List classifiers = (List)clsMap.get(td.getQualifiedName());
                for (CsmClassifier cls : classifiers) {
                    CsmFile clsFile = ((CsmOffsetable)cls).getContainingFile();
                    if (clsFile == null || !CsmIncludeResolver.getDefault().isObjectVisible(clsFile, (CsmObject)contextFile) && !CsmIncludeResolver.getDefault().isObjectVisible(contextFile, (CsmObject)clsFile)) continue;
                    visible.add(i++, (CsmObject)cls);
                }
            }
        } else {
            result = invisible;
        }
        return result;
    }

    private static CsmObject getAssociatedObject(Object item) {
        CsmObject ret;
        if (item instanceof CsmResultItem && (ret = (CsmObject)((CsmResultItem)item).getAssociatedObject()) != null) {
            return ret;
        }
        return null;
    }

    public static int findEndOfMethod(final Document doc, final int startPos) {
        final MutableObject result = new MutableObject((Object)-1);
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)startPos, (boolean)false, (startPos > 0 ? 1 : 0) != 0);
                if (ts != null) {
                    int parenLevel = 0;
                    int braceLevel = 0;
                    while (ts.token() != null && ts.token().id() instanceof CppTokenId && braceLevel >= 0 && parenLevel >= 0) {
                        Token token = ts.token();
                        CppTokenId cppTokenId = (CppTokenId)token.id();
                        if (braceLevel == 0 && cppTokenId == CppTokenId.SEMICOLON) break;
                        if (cppTokenId == CppTokenId.LBRACE) {
                            ++braceLevel;
                        }
                        if (cppTokenId == CppTokenId.RBRACE) {
                            --braceLevel;
                        }
                        if (cppTokenId == CppTokenId.LPAREN) {
                            ++parenLevel;
                        }
                        if (cppTokenId == CppTokenId.RPAREN && --parenLevel == 0) {
                            result.value = ts.offset() + token.length();
                            break;
                        }
                        if (ts.moveNext()) continue;
                        break;
                    }
                }
            }
        });
        return (Integer)result.value;
    }

    public static int findEndOfInstantiation(Document doc, int startPos) {
        int level = 0;
        CharSequence text = DocumentUtilities.getText((Document)doc);
        for (int i = startPos; i < doc.getLength(); ++i) {
            char ch = text.charAt(i);
            if (ch == ';') {
                return -1;
            }
            if (ch == '<') {
                ++level;
            }
            if (ch != '>' || --level != 0) continue;
            return i + 1;
        }
        return -1;
    }
}

