/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.run;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.phpunit.run.Bundle;
import org.netbeans.modules.php.phpunit.run.TestCaseVo;
import org.netbeans.modules.php.phpunit.run.TestSessionVo;
import org.netbeans.modules.php.phpunit.run.TestSuiteVo;
import org.netbeans.modules.php.spi.testing.run.TestCase;

public final class JsonParser {
    private static final Logger LOGGER = Logger.getLogger(JsonParser.class.getName());
    private static final String INCOMPLETE_TEST_PREFIX = "Incomplete Test: ";
    private static final String SKIPPED_TEST_PREFIX = "Skipped Test: ";
    private final File logFile;
    private final Handler handler;
    private final JSONParser parser = new JSONParser();
    private final TestSessionVo actualSession;
    private final TestSuiteVo noSuite;
    private final StringBuilder inputData = new StringBuilder();
    private TestSuiteVo actualSuite = null;
    private TestCaseVo actualTest = null;
    private int curlyBalance = 0;
    private int inputIndex = 0;
    private boolean inString = false;

    public JsonParser(@NonNull File logFile, @NonNull Handler handler, @NullAllowed String customSuitePath) {
        assert (logFile != null);
        assert (handler != null);
        this.logFile = logFile;
        this.handler = handler;
        this.actualSession = new TestSessionVo(customSuitePath);
        this.noSuite = new TestSuiteVo(Bundle.JsonParser_suite_none());
    }

    public void parse(String input) {
        if (StringUtils.isEmpty((String)input)) {
            return;
        }
        if (!this.actualSession.isStarted()) {
            this.actualSession.setStarted(true);
            this.handler.onSessionStart(this.actualSession);
        }
        this.inputData.append(input);
        int prevCh = 32;
        for (int i = this.inputIndex; i < this.inputData.length(); ++i) {
            char ch = this.inputData.charAt(i);
            if (ch == '\"' && prevCh != 92) {
                boolean bl = this.inString = !this.inString;
            }
            if (!this.inString) {
                if (ch == '{') {
                    ++this.curlyBalance;
                } else if (ch == '}') {
                    --this.curlyBalance;
                    if (this.curlyBalance == 0) {
                        this.parseJson(this.inputData.substring(0, i + 1));
                        this.inputData.delete(0, i + 1);
                        i = -1;
                    }
                }
            }
            prevCh = ch;
        }
        this.inputIndex = this.inputData.length();
    }

    public void finish() {
        assert (!StringUtils.hasText((String)this.inputData.toString())) : this.inputData + this.dumpAllData();
        LOGGER.log(Level.FINE, "Parse finish");
        this.suiteFinish();
        if (!this.noSuite.getPureTestCases().isEmpty()) {
            this.actualSession.addTestSuite(this.noSuite);
            this.handler.onSuiteStart(this.noSuite);
            for (TestCaseVo testCaseVo : this.noSuite.getPureTestCases()) {
                this.handler.onTestStart(testCaseVo);
                this.handler.onTestFinish(testCaseVo);
            }
            this.handler.onSuiteFinish(this.noSuite);
        }
        this.handler.onSessionFinish(this.actualSession);
    }

    private void parseJson(String input) {
        String event;
        JSONObject data;
        LOGGER.log(Level.FINE, "JSON: {0}", input);
        try {
            data = (JSONObject)this.parser.parse(input);
        }
        catch (ParseException ex) {
            LOGGER.log(Level.WARNING, input, ex);
            return;
        }
        assert (data != null) : input + this.dumpAllData();
        switch (event = (String)data.get((Object)"event")) {
            case "suiteStart": {
                this.suiteFinish();
                this.suiteStart(data);
                break;
            }
            case "testStart": {
                this.testStart(data);
                break;
            }
            case "test": {
                this.testFinish(data);
                break;
            }
            default: {
                assert (false) : "Unknown event: " + event + " [" + input + "]" + this.dumpAllData();
                break;
            }
        }
    }

    private void suiteStart(JSONObject data) {
        String suiteName = (String)data.get((Object)"suite");
        assert (suiteName != null) : data + this.dumpAllData();
        if (StringUtils.hasText((String)suiteName)) {
            this.actualSuite = new TestSuiteVo(suiteName);
            this.actualSession.addTestSuite(this.actualSuite);
            this.handler.onSuiteStart(this.actualSuite);
        }
    }

    private void suiteFinish() {
        if (this.isActualNoSuite()) {
            return;
        }
        if (this.actualSuite != null) {
            this.handler.onSuiteFinish(this.actualSuite);
        }
    }

    private void testStart(JSONObject data) {
        String suite;
        assert (this.actualSuite != null) : data + this.dumpAllData();
        assert (this.actualTest == null) : this.actualTest + " :: " + data + this.dumpAllData();
        switch (suite = (String)data.get((Object)"suite")) {
            case "": {
                suite = null;
                if (this.isActualNoSuite()) break;
                this.suiteFinish();
                this.actualSuite = this.noSuite;
                break;
            }
            default: {
                assert (this.actualSuite.getName().equals(suite)) : this.actualSuite + " != " + data + this.dumpAllData();
                break;
            }
        }
        String testName = (String)data.get((Object)"test");
        assert (testName != null) : data + this.dumpAllData();
        this.actualTest = new TestCaseVo(suite, this.extractTestName(testName));
        this.actualSuite.addTestCase(this.actualTest);
        if (!this.isActualNoSuite()) {
            this.handler.onTestStart(this.actualTest);
        }
    }

    private void testFinish(JSONObject data) {
        JSONArray trace;
        String suite;
        if (this.actualTest == null) {
            JSONObject testStart = new JSONObject();
            testStart.put((Object)"event", (Object)"testStart");
            testStart.put((Object)"suite", data.get((Object)"suite"));
            testStart.put((Object)"test", data.get((Object)"test"));
            this.testStart(testStart);
        }
        assert (this.actualTest != null) : data + this.dumpAllData();
        switch (suite = (String)data.get((Object)"suite")) {
            case "": {
                assert (this.isActualNoSuite()) : this.actualSuite + this.dumpAllData();
                break;
            }
            default: {
                assert (this.actualSuite.getName().equals(suite)) : this.actualSuite + " != " + this.dumpAllData();
                break;
            }
        }
        String testName = (String)data.get((Object)"test");
        assert (testName != null) : data + this.dumpAllData();
        assert (this.actualTest.getName().equals(this.extractTestName(testName))) : data + " != " + this.actualTest + this.dumpAllData();
        Number time = (Number)data.get((Object)"time");
        if (time instanceof Double) {
            this.actualTest.setTime((long)(time.doubleValue() * 1000.0));
        } else {
            assert (time instanceof Long) : time.getClass().getName() + " [" + data + "]" + this.dumpAllData();
            this.actualTest.setTime(time.longValue() * 1000L);
        }
        String message = (String)data.get((Object)"message");
        String status = (String)data.get((Object)"status");
        assert (status != null) : data + this.dumpAllData();
        switch (status) {
            case "pass": {
                this.actualTest.setStatus(TestCase.Status.PASSED);
                break;
            }
            case "fail": {
                this.actualTest.setStatus(TestCase.Status.FAILED);
                break;
            }
            case "warning": {
                this.actualTest.setStatus(TestCase.Status.PASSEDWITHERRORS);
                break;
            }
            case "error": {
                TestCase.Status testStatus = TestCase.Status.ERROR;
                if (message != null) {
                    if (message.startsWith(INCOMPLETE_TEST_PREFIX)) {
                        message = message.substring(INCOMPLETE_TEST_PREFIX.length());
                        testStatus = TestCase.Status.PENDING;
                    } else if (message.startsWith(SKIPPED_TEST_PREFIX)) {
                        message = message.substring(SKIPPED_TEST_PREFIX.length());
                        testStatus = TestCase.Status.SKIPPED;
                    }
                }
                this.actualTest.setStatus(testStatus);
                break;
            }
            default: {
                assert (false) : "Unknown status: " + status + " [" + data + "]" + this.dumpAllData();
                break;
            }
        }
        if (message != null) {
            this.actualTest.addStacktrace(message);
        }
        if (!(trace = (JSONArray)data.get((Object)"trace")).isEmpty()) {
            boolean first = true;
            for (Object object : trace) {
                JSONObject traceData = (JSONObject)object;
                String file = (String)traceData.get((Object)"file");
                assert (file != null) : traceData + " [" + data + "]" + this.dumpAllData();
                Long line = (Long)traceData.get((Object)"line");
                this.actualTest.addStacktrace(file + ":" + line);
                if (!first) continue;
                first = false;
                this.actualTest.setFile(file);
                this.actualTest.setLine(line.intValue());
            }
        }
        if (!this.isActualNoSuite()) {
            this.handler.onTestFinish(this.actualTest);
        }
        this.actualTest = null;
    }

    private String extractTestName(String testName) {
        String name;
        if (this.isActualNoSuite()) {
            return testName;
        }
        int idx = testName.indexOf("::");
        if (idx != -1 && StringUtils.hasText((String)(name = testName.substring(idx + 2)))) {
            return name;
        }
        return testName;
    }

    private boolean isActualNoSuite() {
        return this.noSuite == this.actualSuite;
    }

    private String dumpAllData() {
        String content;
        try {
            content = new String(Files.readAllBytes(this.logFile.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Cannot read PHPUnit log file " + this.logFile, ex);
            content = "???";
        }
        return " ((:" + content + ":))";
    }

    public static interface Handler {
        public void onSessionStart(TestSessionVo var1);

        public void onSessionFinish(TestSessionVo var1);

        public void onSuiteStart(TestSuiteVo var1);

        public void onSuiteFinish(TestSuiteVo var1);

        public void onTestStart(TestCaseVo var1);

        public void onTestFinish(TestCaseVo var1);
    }
}

