/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.run;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.phpunit.run.TestCaseVo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class TestSuiteVo {
    private final List<TestCaseVo> testCases = new ArrayList<TestCaseVo>();
    private final String name;

    public TestSuiteVo(String name) {
        assert (name != null);
        this.name = name;
    }

    void addTestCase(TestCaseVo testCase) {
        this.testCases.add(testCase);
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public FileObject getLocation() {
        for (TestCaseVo testCase : this.testCases) {
            String file = testCase.getFile();
            if (!StringUtils.hasText((String)file)) continue;
            return FileUtil.toFileObject((File)new File(file));
        }
        return null;
    }

    public List<TestCaseVo> getPureTestCases() {
        return Collections.unmodifiableList(this.testCases);
    }

    public List<TestCaseVo> getTestCases() {
        return this.sanitizedTestCases();
    }

    public long getTime() {
        long time = 0L;
        for (TestCaseVo testCase : this.testCases) {
            time += testCase.getTime();
        }
        return time;
    }

    private List<TestCaseVo> sanitizedTestCases() {
        if (!this.testCases.isEmpty()) {
            return Collections.unmodifiableList(this.testCases);
        }
        return Collections.singletonList(TestCaseVo.skippedTestCase());
    }

    public String toString() {
        return String.format("TestSuiteVo{name: %s, location: %s, time: %d, cases: %d}", this.name, this.getLocation(), this.getTime(), this.testCases.size());
    }
}

