/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clang.frontend.impl.FileEntryPTHEntryInfo;
import org.clang.frontend.impl.OffsetOpt;
import org.clang.frontend.impl.PTHEntry;
import org.clang.frontend.impl.PTHEntryKeyVariant;
import org.clang.frontend.impl.PTHIdKey;
import org.clang.frontend.impl.PTHIdentifierTableTrait;
import org.clang.lex.Lexer;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.lex.java.PTHManagerDriver;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.NativeMemory;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.DenseMapIteratorTypeInt;
import org.llvm.adt.aliases.DenseMapTypeInt;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.OnDiskChainedHashTableGenerator;
import org.llvm.support.endian.Writer;
import org.llvm.support.llvm;
import org.llvm.support.raw_fd_ostream;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.path;

public class PTHWriter
implements Destructors.ClassWithDestructor {
    private DenseMapTypeInt<IdentifierInfo> IM = new DenseMapTypeInt(IdentifierInfo.DenseMapInfo, 0);
    private raw_fd_ostream Out;
    private Preprocessor PP;
    private int idcount;
    private OnDiskChainedHashTableGenerator<Void, PTHEntryKeyVariant, PTHEntry> PM;
    private StringMap<OffsetOpt> CachedStrs;
    private int CurStrOffset;
    private std.vector<StringMapEntry<OffsetOpt>> StrEntries;
    private final boolean keepComments;
    private final boolean emitIncompleteTokenState;

    private int ResolveID(IdentifierInfo II) {
        if (II == null) {
            return 0;
        }
        std_pair.pairTypeInt Entry2 = this.IM.FindAndConstruct((Object)II);
        if (Entry2.second > 0) {
            return Entry2.second;
        }
        Entry2.second = ++this.idcount;
        return this.idcount;
    }

    private void EmitToken(Token T) {
        int Word0 = T.getKind() | (0xFF & T.getFlags()) << 8 | T.getLength() << 16;
        this.Emit32(Word0);
        assert ((short)(Word0 & 0xFF) == T.getKind()) : T + " vs " + (short)(Word0 & 0xFF);
        assert ((Word0 >>> 8 & 0xFF) == (T.getFlags() & 0xFFFF7FFF)) : T + " vs " + (Word0 >>> 8 & 0xFF);
        assert ((Word0 >>> 16 & 0xFFFF) == T.getLength()) : T + " vs " + (Word0 >>> 16 & 0xFFFF);
        if (!T.isLiteral()) {
            this.Emit32(this.ResolveID(T.getIdentifierInfo()));
        } else {
            char.ptr LData;
            byte[] $CharPtrData = T.$CharPtrData();
            int TokLen = T.getLength();
            StringMapEntry E = $CharPtrData != null ? this.CachedStrs.GetOrCreateValue($CharPtrData, T.$CharPtrDataIndex(), TokLen) : ((LData = T.getLiteralData()) != null ? this.CachedStrs.GetOrCreateValue(LData, T.getLength()) : null);
            assert (E == null || E.second == null || ((OffsetOpt)E.second).hasOffset()) : "must be absent or with offset " + E.second;
            if (E != null && E.second == null) {
                E.second = new OffsetOpt();
                ((OffsetOpt)E.second).setOffset(this.CurStrOffset);
                this.StrEntries.push_back((Object)E);
                this.CurStrOffset += TokLen + 1;
            }
            this.Emit32(E == null ? 0 : ((OffsetOpt)E.second).getOffset());
        }
        int FileOffset = this.PP.getSourceManager().getFileOffset(T.$getLocation());
        assert (FileOffset >= 0);
        if (this.emitIncompleteTokenState && T.isIncomplete()) {
            FileOffset |= Integer.MIN_VALUE;
        }
        this.Emit32(FileOffset);
    }

    private void Emit8(int V) {
        new Writer(llvm.support.endianness.little, (raw_ostream)this.Out).write_uint8(V);
    }

    private void Emit16(int V) {
        new Writer(llvm.support.endianness.little, (raw_ostream)this.Out).write_uint16(V);
    }

    private void Emit32(int V) {
        new Writer(llvm.support.endianness.little, (raw_ostream)this.Out).write_uint32(V);
    }

    private void EmitBuf(char.ptr Ptr, int NumBytes) {
        this.Out.write(Ptr, NumBytes);
    }

    private void EmitBuf(byte[] Ptr, int PtrIdx, int NumBytes) {
        this.Out.write(Ptr, PtrIdx, NumBytes);
    }

    private void EmitString(StringRef V) {
        new Writer(llvm.support.endianness.little, (raw_ostream)this.Out).write_uint16(V.size());
        this.EmitBuf(V.data(), V.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private std_pair.pairIntInt EmitIdentifierTable() {
        OnDiskChainedHashTableGenerator IIOffMap = null;
        try {
            PTHIdKey[] IIDMap = new PTHIdKey[this.idcount];
            for (int i = 0; i < this.idcount; ++i) {
                IIDMap[i] = new PTHIdKey();
            }
            IIOffMap = new OnDiskChainedHashTableGenerator((OnDiskChainedHashTableGenerator.EmitInfoInterface)new PTHIdentifierTableTrait());
            DenseMapIteratorTypeInt I = this.IM.begin();
            DenseMapIteratorTypeInt E = this.IM.end();
            while (I.$noteq(E)) {
                assert (I.$star().second > 0);
                assert (I.$star().second - 1 < this.idcount);
                int idx = I.$star().second - 1;
                IIDMap[idx].II = (IdentifierInfo)I.$star().first;
                IIOffMap.insert((Object)IIDMap[idx], (Object)I.$star().second);
                I.$preInc();
            }
            int StringTableOffset = IIOffMap.Emit((raw_ostream)this.Out);
            int IDOff = Unsigned.$long2uint((long)this.Out.tell());
            this.Emit32(this.idcount);
            for (int i = 0; i < this.idcount; ++i) {
                this.Emit32(IIDMap[i].FileOffset);
            }
            std.free((Object)IIDMap);
            std_pair.pairIntInt pairIntInt2 = std.make_pair_int_int((int)IDOff, (int)StringTableOffset);
            return pairIntInt2;
        }
        finally {
            if (IIOffMap != null) {
                IIOffMap.$destroy();
            }
        }
    }

    private int EmitFileTable() {
        return this.PM.Emit((raw_ostream)this.Out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PTHEntry LexTokens(Lexer L) {
        std.vector PPCond = null;
        std.vectorInt PPStartCond = null;
        try {
            Writer LE = new Writer(llvm.support.endianness.little, (raw_ostream)this.Out);
            int TokenOff = Unsigned.$long2uint((long)this.Out.tell());
            long N = llvm.OffsetToAlignment((long)TokenOff, (long)4L);
            while (N != 0L) {
                LE.write_uint8(0);
                --N;
                ++TokenOff;
            }
            PPCond = new std.vector((Object)new std_pair.pairIntInt(0, 0));
            PPStartCond = new std.vectorInt();
            Token Tok = new Token();
            do {
                L.LexFromRawLexer(Tok);
                if (Tok.is('\u0006')) {
                    this.PP.LookUpIdentifierInfo(Tok);
                    Tok.setKind('\u0005');
                } else if (Tok.is('A') && Tok.isAtStartOfLine()) {
                    assert (!L.isParsingPreprocessorDirective());
                    int HashOff = Unsigned.$long2uint((long)this.Out.tell());
                    this.EmitToken(Tok);
                    L.setParsingPreprocessorDirective(true);
                    L.LexFromRawLexer(Tok);
                    while (Tok.is('\u0004')) {
                        this.EmitToken(Tok);
                        L.LexFromRawLexer(Tok);
                    }
                    assert (!Tok.isAtStartOfLine()) : "JAVA: Couldn't be in Parsing PP mode, at least eod must be met: " + Tok;
                    if (Tok.is('\u0006')) {
                        IdentifierInfo II = this.PP.LookUpIdentifierInfo(Tok);
                        char K = II.getPPKeywordID();
                        switch (K) {
                            default: {
                                Tok.setKind('\u0005');
                                break;
                            }
                            case '\b': 
                            case '\u000f': 
                            case '\u0010': {
                                this.EmitToken(Tok);
                                L.LexIncludeFilename(Tok);
                                assert (!Tok.isAtStartOfLine());
                                while (Tok.is('\u0004')) {
                                    this.EmitToken(Tok);
                                    L.LexIncludeFilename(Tok);
                                    assert (!Tok.isAtStartOfLine());
                                }
                                if (!Tok.is('\u0006')) break;
                                this.PP.LookUpIdentifierInfo(Tok);
                                Tok.setKind('\u0005');
                                break;
                            }
                            case '\u0001': 
                            case '\u0002': 
                            case '\u0003': {
                                PPStartCond.push_back(PPCond.size());
                                PPCond.push_back((Object)std.make_pair_int_int((int)HashOff, (int)0));
                                break;
                            }
                            case '\u0006': {
                                int index;
                                if (!PPStartCond.empty()) {
                                    index = PPCond.size();
                                    this.finishEndif(index, (std.vector<std_pair.pairIntInt>)PPCond, PPStartCond, HashOff);
                                } else {
                                    this.Diag(Tok, "Error: imbalanced #endif preprocessor conditionals.");
                                }
                                if (this.keepComments) break;
                                this.EmitToken(Tok);
                                do {
                                    L.LexFromRawLexer(Tok);
                                } while (Tok.isNot('\u0002'));
                                break;
                            }
                            case '\u0004': 
                            case '\u0005': {
                                int index;
                                if (!PPStartCond.empty()) {
                                    index = PPCond.size();
                                    assert (PPCond.size() > PPStartCond.back());
                                    assert (((std_pair.pairIntInt)PPCond.$at((int)PPStartCond.back())).second == 0);
                                    ((std_pair.pairIntInt)PPCond.$at((int)PPStartCond.back())).second = index;
                                    PPStartCond.pop_back();
                                    PPCond.push_back((Object)std.make_pair_int_int((int)HashOff, (int)0));
                                    PPStartCond.push_back(index);
                                    break;
                                }
                                this.Diag(Tok, "Error: imbalanced #else/#elif preprocessor conditionals ");
                            }
                        }
                    }
                }
                assert (Tok.isNot('\u0002') || !L.isParsingPreprocessorDirective()) : "must be false after producing EOD " + Tok + " vs. " + L.isParsingPreprocessorDirective();
                this.EmitToken(Tok);
            } while (Tok.isNot('\u0001'));
            int PPCondOff = Unsigned.$long2uint((long)this.Out.tell());
            assert (Tok.is('\u0001')) : "it must be end of file";
            if (!PPStartCond.empty() && this.emitIncompleteTokenState) {
                int EofAsFakeHashOffsetInStream = PPCondOff - 12;
                int fakeEndifIndex = PPCond.size();
                while (!PPStartCond.empty()) {
                    this.finishEndif(fakeEndifIndex, (std.vector<std_pair.pairIntInt>)PPCond, PPStartCond, EofAsFakeHashOffsetInStream);
                    ++fakeEndifIndex;
                }
            }
            this.Emit32(PPCond.size());
            int e = PPCond.size();
            for (int i = 0; i != e; ++i) {
                this.Emit32(((std_pair.pairIntInt)PPCond.$at((int)i)).first - TokenOff);
                int x = ((std_pair.pairIntInt)PPCond.$at((int)i)).second;
                assert (x != 0) : "PPCond entry not backpatched.";
                this.Emit32(x == i ? 0 : x);
            }
            PTHEntry pTHEntry = new PTHEntry(TokenOff, PPCondOff);
            return pTHEntry;
        }
        finally {
            if (PPStartCond != null) {
                PPStartCond.$destroy();
            }
            if (PPCond != null) {
                PPCond.$destroy();
            }
        }
    }

    private void finishEndif(int index, std.vector<std_pair.pairIntInt> PPCond, std.vectorInt PPStartCond, int HashOff) {
        assert (!PPCond.empty()) : "must be called only when has block to complete";
        assert (PPCond.size() > PPStartCond.back());
        assert (((std_pair.pairIntInt)PPCond.$at((int)PPStartCond.back())).second == 0);
        ((std_pair.pairIntInt)PPCond.$at((int)PPStartCond.back())).second = index;
        PPStartCond.pop_back();
        PPCond.push_back((Object)std.make_pair_int_int((int)HashOff, (int)index));
    }

    private int EmitCachedSpellings() {
        int SpellingsOff = Unsigned.$long2uint((long)this.Out.tell());
        for (int i = 0; i < this.StrEntries.size(); ++i) {
            StringMapEntry Str = (StringMapEntry)this.StrEntries.$at(i);
            this.EmitBuf(Str.getKeyArray(), Str.getKeyArrayIndex(), Str.getKeyLength() + 1);
        }
        return SpellingsOff;
    }

    public PTHWriter(raw_fd_ostream out, Preprocessor pp) {
        this(out, pp, PTHManagerDriver.KEEP_PTH_COMMENTS, PTHManagerDriver.KEEP_INCOMPLETE_TOKEN_STATE);
    }

    public PTHWriter(raw_fd_ostream out, Preprocessor pp, boolean needComments, boolean emitIncompleteTokenState) {
        this.Out = out;
        this.PP = pp;
        this.idcount = 0;
        this.PM = new OnDiskChainedHashTableGenerator((OnDiskChainedHashTableGenerator.EmitInfoInterface)new FileEntryPTHEntryInfo());
        this.CachedStrs = new StringMap((NativeMemory.Allocator)new BumpPtrAllocator(), null);
        this.CurStrOffset = 0;
        this.StrEntries = new std.vector(0, (Object)null);
        this.keepComments = needComments;
        this.emitIncompleteTokenState = emitIncompleteTokenState;
    }

    public OnDiskChainedHashTableGenerator<Void, PTHEntryKeyVariant, PTHEntry> getPM() {
        return this.PM;
    }

    public void GeneratePTH(std.string MainFile) {
        this.GeneratePTH(MainFile, FileID.getInvalidID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GeneratePTH(std.string MainFile, int CachedFID) {
        Lexer L;
        this.Out.$out(NativePointer.$cfe_pth).$out_char((byte)0);
        this.Emit32(10);
        int PrologueOffset = Unsigned.$long2uint((long)this.Out.tell());
        for (int i = 0; i < 4; ++i) {
            this.Emit32(0);
        }
        if (!MainFile.empty()) {
            this.EmitString(new StringRef(MainFile));
        } else {
            this.Emit16(0);
        }
        this.Emit8(0);
        SourceManager SM = this.PP.getSourceManager();
        LangOptions LOpts = this.$LangOptions();
        if (CachedFID != FileID.getInvalidID()) {
            FileEntry CacheOnlyOneFE = SM.getFileEntryForID(CachedFID);
            MemoryBuffer FromFile = SM.getBuffer(CachedFID);
            L = null;
            try {
                L = new Lexer(CachedFID, FromFile, SM, LOpts);
                L.SetCommentRetentionState(this.keepComments);
                this.PM.insert((Object)new PTHEntryKeyVariant(CacheOnlyOneFE), (Object)this.LexTokens(L));
            }
            finally {
                if (L != null) {
                    L.$destroy();
                }
            }
        }
        DenseMapIterator I = SM.fileinfo_begin();
        DenseMapIterator E = SM.fileinfo_end();
        while (I.$noteq(E)) {
            L = null;
            try {
                MemoryBuffer B;
                SrcMgr.ContentCache C = (SrcMgr.ContentCache)I.$star().second;
                FileEntry FE = C.OrigEntry;
                if (!path.is_relative((Twine)new Twine(FE.getName())) && (B = C.getBuffer(this.PP.getDiagnostics(), SM)) != null) {
                    int FID = SM.createFileID(FE, new SourceLocation(), SrcMgr.CharacteristicKind.C_User);
                    MemoryBuffer FromFile = SM.getBuffer(FID);
                    L = new Lexer(FID, FromFile, SM, LOpts);
                    L.SetCommentRetentionState(this.keepComments);
                    this.PM.insert((Object)new PTHEntryKeyVariant(FE), (Object)this.LexTokens(L));
                }
            }
            finally {
                if (L != null) {
                    L.$destroy();
                }
            }
            I.$preInc();
        }
        std_pair.pairIntInt IdTableOff = this.EmitIdentifierTable();
        int SpellingOff = this.EmitCachedSpellings();
        int FileTableOff = this.EmitFileTable();
        this.Out.seek((long)PrologueOffset);
        this.Emit32(IdTableOff.first);
        this.Emit32(IdTableOff.second);
        this.Emit32(FileTableOff);
        this.Emit32(SpellingOff);
    }

    public void $destroy() {
        this.StrEntries.$destroy();
        this.CachedStrs.$destroy();
        this.PM.$destroy();
        this.IM.$destroy();
    }

    public String toString() {
        return "IM=" + this.IM.size() + ", Out=" + this.Out + ", idcount=" + this.idcount + ", PM=" + this.PM + ", CachedStrs=" + this.CachedStrs.size() + ", CurStrOffset=" + this.CurStrOffset + ", StrEntries=" + this.StrEntries.size();
    }

    private LangOptions $LangOptions() {
        LangOptions Opts = new LangOptions();
        Opts.C11 = true;
        Opts.CPlusPlus = true;
        Opts.CPlusPlus11 = true;
        Opts.CPlusPlus14 = true;
        Opts.CPlusPlus1z = true;
        Opts.Digraphs = true;
        Opts.Trigraphs = true;
        Opts.LineComment = true;
        return Opts;
    }

    private void Diag(Token Tok, String msg) {
        if (!NativeTrace.USE_PTH_DRIVER_IN_TEST) {
            BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.PP.getDiagnostics().Report(Tok.$getLocation(), 739), (StringRef)StringRef.R$EMPTY).$destroy();
        }
    }
}

